/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.windows.WinUser;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.platform.win32.ObjectPicker;
import com.install4j.runtime.util.StandardDialog;
import com.install4j.runtime.util.TextAndButtonPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class CreateUserDialog
extends StandardDialog {
    private JTextField txtUserName;
    private JTextField txtPassword;
    private JTextField txtDescription;
    private JTextField txtGroupName;
    private JButton btnSelectGroup;
    private WinUser.AddUserResult result;

    public static CreateUserDialog create(Window window) {
        if (window instanceof Frame) {
            return new CreateUserDialog((Frame)window);
        }
        return new CreateUserDialog((Dialog)window);
    }

    private CreateUserDialog(Frame frame) {
        super(frame);
        this.init();
    }

    private CreateUserDialog(Dialog dialog) {
        super(dialog);
        this.init();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.btnSelectGroup) {
            this.doSelectGroup();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public WinUser.AddUserResult getResult() {
        return this.result;
    }

    public String getPassword() {
        return this.txtPassword.getText().trim();
    }

    protected int getFrameHeight() {
        return -1;
    }

    protected int getFrameWidth() {
        return 400;
    }

    protected void setupControls() {
        super.setupControls();
        this.txtUserName = new JTextField();
        this.txtPassword = new JPasswordField(20);
        this.txtDescription = new JTextField();
        this.txtGroupName = new JTextField();
        this.btnSelectGroup = new JButton(Messages.getMessages().getString("ButtonBrowse"));
    }

    protected void setupEventHandlers() {
        super.setupEventHandlers();
        this.btnSelectGroup.addActionListener(this);
    }

    protected void setupComponent() {
        super.setupComponent();
        this.setTitle(Messages.getMessages().getString("ButtonCreateUser"));
    }

    protected void doOk() {
        if (this.checkTextField(this.txtUserName) && this.checkTextField(this.txtPassword)) {
            try {
                this.result = WinUser.addUser(this.txtUserName.getText().trim(), this.getPassword(), this.txtDescription.getText().trim(), WinUser.GroupCreationMode.CREATE_IF_NECESSARY, this.txtGroupName.getText().trim(), "");
                if (this.result.getType() != WinUser.AddUserResultType.SUCCESS) {
                    this.showCreationError();
                    return;
                }
            }
            catch (Exception exception) {
                this.showCreationError();
                return;
            }
            GUIHelper.showMessage(this, Messages.getMessages().getString("CreateUserSuccess"), 1);
            super.doOk();
        }
    }

    private void showCreationError() {
        String string = null;
        if (this.result.getType() == WinUser.AddUserResultType.ERROR_ACCESS_DENIED) {
            string = "CreateUserErrorAccessDenied";
        } else if (this.result.getType() == WinUser.AddUserResultType.ERROR_GROUP_EXISTS) {
            string = "CreateUserErrorGroupExists";
        } else if (this.result.getType() == WinUser.AddUserResultType.ERROR_GROUP_NOT_FOUND) {
            string = "CreateUserErrorGroupNotFound";
        } else if (this.result.getType() == WinUser.AddUserResultType.ERROR_PASSWORD_REQUIREMENTS) {
            string = "CreateUserErrorPasswordRequirements";
        } else if (this.result.getType() == WinUser.AddUserResultType.ERROR_USER_EXISTS) {
            string = "CreateUserErrorUserExists";
        }
        String string2 = Messages.getMessages().getString("CreateUserError");
        if (string != null) {
            string2 = string2 + "\n\n" + Messages.getMessages().getString(string);
        }
        GUIHelper.showMessage(this, string2, 0);
    }

    protected void addScreenContent(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.bottom = 15;
        jPanel.add((Component)new JLabel(Messages.getMessages().getString("CreateUserHeader")), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)new JLabel(Messages.getMessages().getString("UserNameLabel")), gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel(Messages.getMessages().getString("DescriptionLabel")), gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel(Messages.getMessages().getString("LocalGroupNameLabel")), gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel(Messages.getMessages().getString("PasswordLabel")), gridBagConstraints);
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.gridy -= 3;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.txtUserName, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.txtDescription, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new TextAndButtonPanel(this.txtGroupName, this.btnSelectGroup), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.txtPassword, gridBagConstraints);
    }

    protected boolean isFillVertical() {
        return false;
    }

    private void doSelectGroup() {
        ObjectPicker.Result[] resultArray = ObjectPicker.show(false, true, false, false, true);
        if (resultArray != null && resultArray.length > 0) {
            this.txtGroupName.setText(resultArray[0].getName());
        }
    }
}

