/* Copyright 2021 Stanford University
 * Copyright 2021 Los Alamos National Laboratory 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "task_throughput.h"

#include <cuda_runtime.h>

__global__ void dummy_kernel()
{}

void dummy_gpu_task(const void *args, size_t arglen, 
		    const void *userdata, size_t userlen, Processor p)
{
  int threads = 1;
  int blocks = 1;
  dummy_kernel<<<blocks, threads>>>();

  dummy_task_body(args, arglen, userdata, userlen, p);
}
