// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/storageinsights/v1/storageinsights.proto

#include "google/cloud/storageinsights/v1/internal/storage_insights_auth_decorator.h"
#include <google/cloud/storageinsights/v1/storageinsights.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace storageinsights_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

StorageInsightsAuth::StorageInsightsAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<StorageInsightsStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::cloud::storageinsights::v1::ListReportConfigsResponse>
StorageInsightsAuth::ListReportConfigs(
    grpc::ClientContext& context, Options const& options,
    google::cloud::storageinsights::v1::ListReportConfigsRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListReportConfigs(context, options, request);
}

StatusOr<google::cloud::storageinsights::v1::ReportConfig>
StorageInsightsAuth::GetReportConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::storageinsights::v1::GetReportConfigRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetReportConfig(context, options, request);
}

StatusOr<google::cloud::storageinsights::v1::ReportConfig>
StorageInsightsAuth::CreateReportConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::storageinsights::v1::CreateReportConfigRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateReportConfig(context, options, request);
}

StatusOr<google::cloud::storageinsights::v1::ReportConfig>
StorageInsightsAuth::UpdateReportConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::storageinsights::v1::UpdateReportConfigRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateReportConfig(context, options, request);
}

Status StorageInsightsAuth::DeleteReportConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::storageinsights::v1::DeleteReportConfigRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteReportConfig(context, options, request);
}

StatusOr<google::cloud::storageinsights::v1::ListReportDetailsResponse>
StorageInsightsAuth::ListReportDetails(
    grpc::ClientContext& context, Options const& options,
    google::cloud::storageinsights::v1::ListReportDetailsRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListReportDetails(context, options, request);
}

StatusOr<google::cloud::storageinsights::v1::ReportDetail>
StorageInsightsAuth::GetReportDetail(
    grpc::ClientContext& context, Options const& options,
    google::cloud::storageinsights::v1::GetReportDetailRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetReportDetail(context, options, request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace storageinsights_v1_internal
}  // namespace cloud
}  // namespace google
