// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/sql/v1/cloud_sql_operations.proto

#include "google/cloud/sql/v1/internal/sql_operations_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace sql_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

SqlOperationsServiceTracingConnection::SqlOperationsServiceTracingConnection(
    std::shared_ptr<sql_v1::SqlOperationsServiceConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::sql::v1::Operation>
SqlOperationsServiceTracingConnection::Get(
    google::cloud::sql::v1::SqlOperationsGetRequest const& request) {
  auto span = internal::MakeSpan("sql_v1::SqlOperationsServiceConnection::Get");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->Get(request));
}

StreamRange<google::cloud::sql::v1::Operation>
SqlOperationsServiceTracingConnection::List(
    google::cloud::sql::v1::SqlOperationsListRequest request) {
  auto span =
      internal::MakeSpan("sql_v1::SqlOperationsServiceConnection::List");
  internal::OTelScope scope(span);
  auto sr = child_->List(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::sql::v1::Operation>(
      std::move(span), std::move(sr));
}

Status SqlOperationsServiceTracingConnection::Cancel(
    google::cloud::sql::v1::SqlOperationsCancelRequest const& request) {
  auto span =
      internal::MakeSpan("sql_v1::SqlOperationsServiceConnection::Cancel");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->Cancel(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<sql_v1::SqlOperationsServiceConnection>
MakeSqlOperationsServiceTracingConnection(
    std::shared_ptr<sql_v1::SqlOperationsServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<SqlOperationsServiceTracingConnection>(
        std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace sql_v1_internal
}  // namespace cloud
}  // namespace google
