// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/shell/v1/cloudshell.proto

#include "google/cloud/shell/v1/cloud_shell_connection.h"
#include "google/cloud/shell/v1/cloud_shell_options.h"
#include "google/cloud/shell/v1/internal/cloud_shell_connection_impl.h"
#include "google/cloud/shell/v1/internal/cloud_shell_option_defaults.h"
#include "google/cloud/shell/v1/internal/cloud_shell_stub_factory.h"
#include "google/cloud/shell/v1/internal/cloud_shell_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace shell_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CloudShellServiceConnection::~CloudShellServiceConnection() = default;

StatusOr<google::cloud::shell::v1::Environment>
CloudShellServiceConnection::GetEnvironment(
    google::cloud::shell::v1::GetEnvironmentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::shell::v1::StartEnvironmentResponse>>
CloudShellServiceConnection::StartEnvironment(
    google::cloud::shell::v1::StartEnvironmentRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::shell::v1::StartEnvironmentResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CloudShellServiceConnection::StartEnvironment(
    NoAwaitTag, google::cloud::shell::v1::StartEnvironmentRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::shell::v1::StartEnvironmentResponse>>
CloudShellServiceConnection::StartEnvironment(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::shell::v1::StartEnvironmentResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::shell::v1::AuthorizeEnvironmentResponse>>
CloudShellServiceConnection::AuthorizeEnvironment(
    google::cloud::shell::v1::AuthorizeEnvironmentRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::shell::v1::AuthorizeEnvironmentResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CloudShellServiceConnection::AuthorizeEnvironment(
    NoAwaitTag, google::cloud::shell::v1::AuthorizeEnvironmentRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::shell::v1::AuthorizeEnvironmentResponse>>
CloudShellServiceConnection::AuthorizeEnvironment(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::shell::v1::AuthorizeEnvironmentResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::shell::v1::AddPublicKeyResponse>>
CloudShellServiceConnection::AddPublicKey(
    google::cloud::shell::v1::AddPublicKeyRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::shell::v1::AddPublicKeyResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CloudShellServiceConnection::AddPublicKey(
    NoAwaitTag, google::cloud::shell::v1::AddPublicKeyRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::shell::v1::AddPublicKeyResponse>>
CloudShellServiceConnection::AddPublicKey(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::shell::v1::AddPublicKeyResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::shell::v1::RemovePublicKeyResponse>>
CloudShellServiceConnection::RemovePublicKey(
    google::cloud::shell::v1::RemovePublicKeyRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::shell::v1::RemovePublicKeyResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CloudShellServiceConnection::RemovePublicKey(
    NoAwaitTag, google::cloud::shell::v1::RemovePublicKeyRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::shell::v1::RemovePublicKeyResponse>>
CloudShellServiceConnection::RemovePublicKey(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::shell::v1::RemovePublicKeyResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<CloudShellServiceConnection> MakeCloudShellServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 CloudShellServicePolicyOptionList>(options,
                                                                    __func__);
  options =
      shell_v1_internal::CloudShellServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = shell_v1_internal::CreateDefaultCloudShellServiceStub(
      std::move(auth), options);
  return shell_v1_internal::MakeCloudShellServiceTracingConnection(
      std::make_shared<shell_v1_internal::CloudShellServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace shell_v1
}  // namespace cloud
}  // namespace google
