// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/securitycentermanagement/v1/security_center_management.proto

#include "google/cloud/securitycentermanagement/v1/internal/security_center_management_connection_impl.h"
#include "google/cloud/securitycentermanagement/v1/internal/security_center_management_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace securitycentermanagement_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<
    securitycentermanagement_v1::SecurityCenterManagementRetryPolicy>
retry_policy(Options const& options) {
  return options
      .get<securitycentermanagement_v1::
               SecurityCenterManagementRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options
      .get<securitycentermanagement_v1::
               SecurityCenterManagementBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<securitycentermanagement_v1::
                    SecurityCenterManagementConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<securitycentermanagement_v1::
               SecurityCenterManagementConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

SecurityCenterManagementConnectionImpl::SecurityCenterManagementConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<
        securitycentermanagement_v1_internal::SecurityCenterManagementStub>
        stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), SecurityCenterManagementConnection::options())) {}

StreamRange<google::cloud::securitycentermanagement::v1::
                EffectiveSecurityHealthAnalyticsCustomModule>
SecurityCenterManagementConnectionImpl::
    ListEffectiveSecurityHealthAnalyticsCustomModules(
        google::cloud::securitycentermanagement::v1::
            ListEffectiveSecurityHealthAnalyticsCustomModulesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)
          ->ListEffectiveSecurityHealthAnalyticsCustomModules(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::securitycentermanagement::v1::
                      EffectiveSecurityHealthAnalyticsCustomModule>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           securitycentermanagement_v1::SecurityCenterManagementRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::securitycentermanagement::v1::
              ListEffectiveSecurityHealthAnalyticsCustomModulesRequest const&
                  r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::securitycentermanagement::v1::
                    ListEffectiveSecurityHealthAnalyticsCustomModulesRequest const&
                        request) {
              return stub->ListEffectiveSecurityHealthAnalyticsCustomModules(
                  context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::securitycentermanagement::v1::
             ListEffectiveSecurityHealthAnalyticsCustomModulesResponse r) {
        std::vector<google::cloud::securitycentermanagement::v1::
                        EffectiveSecurityHealthAnalyticsCustomModule>
            result(
                r.effective_security_health_analytics_custom_modules().size());
        auto& messages =
            *r.mutable_effective_security_health_analytics_custom_modules();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::securitycentermanagement::v1::
             EffectiveSecurityHealthAnalyticsCustomModule>
SecurityCenterManagementConnectionImpl::
    GetEffectiveSecurityHealthAnalyticsCustomModule(
        google::cloud::securitycentermanagement::v1::
            GetEffectiveSecurityHealthAnalyticsCustomModuleRequest const&
                request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)
          ->GetEffectiveSecurityHealthAnalyticsCustomModule(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycentermanagement::v1::
                 GetEffectiveSecurityHealthAnalyticsCustomModuleRequest const&
                     request) {
        return stub_->GetEffectiveSecurityHealthAnalyticsCustomModule(
            context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::securitycentermanagement::v1::
                SecurityHealthAnalyticsCustomModule>
SecurityCenterManagementConnectionImpl::
    ListSecurityHealthAnalyticsCustomModules(
        google::cloud::securitycentermanagement::v1::
            ListSecurityHealthAnalyticsCustomModulesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListSecurityHealthAnalyticsCustomModules(
          request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::securitycentermanagement::v1::
                      SecurityHealthAnalyticsCustomModule>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           securitycentermanagement_v1::SecurityCenterManagementRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::securitycentermanagement::v1::
              ListSecurityHealthAnalyticsCustomModulesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::securitycentermanagement::v1::
                       ListSecurityHealthAnalyticsCustomModulesRequest const&
                           request) {
              return stub->ListSecurityHealthAnalyticsCustomModules(
                  context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::securitycentermanagement::v1::
             ListSecurityHealthAnalyticsCustomModulesResponse r) {
        std::vector<google::cloud::securitycentermanagement::v1::
                        SecurityHealthAnalyticsCustomModule>
            result(r.security_health_analytics_custom_modules().size());
        auto& messages = *r.mutable_security_health_analytics_custom_modules();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::securitycentermanagement::v1::
                SecurityHealthAnalyticsCustomModule>
SecurityCenterManagementConnectionImpl::
    ListDescendantSecurityHealthAnalyticsCustomModules(
        google::cloud::securitycentermanagement::v1::
            ListDescendantSecurityHealthAnalyticsCustomModulesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)
          ->ListDescendantSecurityHealthAnalyticsCustomModules(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::securitycentermanagement::v1::
                      SecurityHealthAnalyticsCustomModule>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           securitycentermanagement_v1::SecurityCenterManagementRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::securitycentermanagement::v1::
              ListDescendantSecurityHealthAnalyticsCustomModulesRequest const&
                  r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::securitycentermanagement::v1::
                    ListDescendantSecurityHealthAnalyticsCustomModulesRequest const&
                        request) {
              return stub->ListDescendantSecurityHealthAnalyticsCustomModules(
                  context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::securitycentermanagement::v1::
             ListDescendantSecurityHealthAnalyticsCustomModulesResponse r) {
        std::vector<google::cloud::securitycentermanagement::v1::
                        SecurityHealthAnalyticsCustomModule>
            result(r.security_health_analytics_custom_modules().size());
        auto& messages = *r.mutable_security_health_analytics_custom_modules();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::securitycentermanagement::v1::
             SecurityHealthAnalyticsCustomModule>
SecurityCenterManagementConnectionImpl::GetSecurityHealthAnalyticsCustomModule(
    google::cloud::securitycentermanagement::v1::
        GetSecurityHealthAnalyticsCustomModuleRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetSecurityHealthAnalyticsCustomModule(
          request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycentermanagement::v1::
                 GetSecurityHealthAnalyticsCustomModuleRequest const& request) {
        return stub_->GetSecurityHealthAnalyticsCustomModule(context, options,
                                                             request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::securitycentermanagement::v1::
             SecurityHealthAnalyticsCustomModule>
SecurityCenterManagementConnectionImpl::
    CreateSecurityHealthAnalyticsCustomModule(
        google::cloud::securitycentermanagement::v1::
            CreateSecurityHealthAnalyticsCustomModuleRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateSecurityHealthAnalyticsCustomModule(
          request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::securitycentermanagement::v1::
              CreateSecurityHealthAnalyticsCustomModuleRequest const& request) {
        return stub_->CreateSecurityHealthAnalyticsCustomModule(
            context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::securitycentermanagement::v1::
             SecurityHealthAnalyticsCustomModule>
SecurityCenterManagementConnectionImpl::
    UpdateSecurityHealthAnalyticsCustomModule(
        google::cloud::securitycentermanagement::v1::
            UpdateSecurityHealthAnalyticsCustomModuleRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateSecurityHealthAnalyticsCustomModule(
          request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::securitycentermanagement::v1::
              UpdateSecurityHealthAnalyticsCustomModuleRequest const& request) {
        return stub_->UpdateSecurityHealthAnalyticsCustomModule(
            context, options, request);
      },
      *current, request, __func__);
}

Status SecurityCenterManagementConnectionImpl::
    DeleteSecurityHealthAnalyticsCustomModule(
        google::cloud::securitycentermanagement::v1::
            DeleteSecurityHealthAnalyticsCustomModuleRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteSecurityHealthAnalyticsCustomModule(
          request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::securitycentermanagement::v1::
              DeleteSecurityHealthAnalyticsCustomModuleRequest const& request) {
        return stub_->DeleteSecurityHealthAnalyticsCustomModule(
            context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::securitycentermanagement::v1::
             SimulateSecurityHealthAnalyticsCustomModuleResponse>
SecurityCenterManagementConnectionImpl::
    SimulateSecurityHealthAnalyticsCustomModule(
        google::cloud::securitycentermanagement::v1::
            SimulateSecurityHealthAnalyticsCustomModuleRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->SimulateSecurityHealthAnalyticsCustomModule(
          request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycentermanagement::v1::
                 SimulateSecurityHealthAnalyticsCustomModuleRequest const&
                     request) {
        return stub_->SimulateSecurityHealthAnalyticsCustomModule(
            context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::securitycentermanagement::v1::
                EffectiveEventThreatDetectionCustomModule>
SecurityCenterManagementConnectionImpl::
    ListEffectiveEventThreatDetectionCustomModules(
        google::cloud::securitycentermanagement::v1::
            ListEffectiveEventThreatDetectionCustomModulesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)
          ->ListEffectiveEventThreatDetectionCustomModules(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::securitycentermanagement::v1::
                      EffectiveEventThreatDetectionCustomModule>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           securitycentermanagement_v1::SecurityCenterManagementRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::securitycentermanagement::v1::
              ListEffectiveEventThreatDetectionCustomModulesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::securitycentermanagement::v1::
                    ListEffectiveEventThreatDetectionCustomModulesRequest const&
                        request) {
              return stub->ListEffectiveEventThreatDetectionCustomModules(
                  context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::securitycentermanagement::v1::
             ListEffectiveEventThreatDetectionCustomModulesResponse r) {
        std::vector<google::cloud::securitycentermanagement::v1::
                        EffectiveEventThreatDetectionCustomModule>
            result(r.effective_event_threat_detection_custom_modules().size());
        auto& messages =
            *r.mutable_effective_event_threat_detection_custom_modules();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::securitycentermanagement::v1::
             EffectiveEventThreatDetectionCustomModule>
SecurityCenterManagementConnectionImpl::
    GetEffectiveEventThreatDetectionCustomModule(
        google::cloud::securitycentermanagement::v1::
            GetEffectiveEventThreatDetectionCustomModuleRequest const&
                request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)
          ->GetEffectiveEventThreatDetectionCustomModule(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycentermanagement::v1::
                 GetEffectiveEventThreatDetectionCustomModuleRequest const&
                     request) {
        return stub_->GetEffectiveEventThreatDetectionCustomModule(
            context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::securitycentermanagement::v1::
                EventThreatDetectionCustomModule>
SecurityCenterManagementConnectionImpl::ListEventThreatDetectionCustomModules(
    google::cloud::securitycentermanagement::v1::
        ListEventThreatDetectionCustomModulesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListEventThreatDetectionCustomModules(
          request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::securitycentermanagement::v1::
                      EventThreatDetectionCustomModule>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           securitycentermanagement_v1::SecurityCenterManagementRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::securitycentermanagement::v1::
              ListEventThreatDetectionCustomModulesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::securitycentermanagement::v1::
                       ListEventThreatDetectionCustomModulesRequest const&
                           request) {
              return stub->ListEventThreatDetectionCustomModules(
                  context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::securitycentermanagement::v1::
             ListEventThreatDetectionCustomModulesResponse r) {
        std::vector<google::cloud::securitycentermanagement::v1::
                        EventThreatDetectionCustomModule>
            result(r.event_threat_detection_custom_modules().size());
        auto& messages = *r.mutable_event_threat_detection_custom_modules();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::securitycentermanagement::v1::
                EventThreatDetectionCustomModule>
SecurityCenterManagementConnectionImpl::
    ListDescendantEventThreatDetectionCustomModules(
        google::cloud::securitycentermanagement::v1::
            ListDescendantEventThreatDetectionCustomModulesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)
          ->ListDescendantEventThreatDetectionCustomModules(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::securitycentermanagement::v1::
                      EventThreatDetectionCustomModule>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           securitycentermanagement_v1::SecurityCenterManagementRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::securitycentermanagement::v1::
              ListDescendantEventThreatDetectionCustomModulesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::securitycentermanagement::v1::
                    ListDescendantEventThreatDetectionCustomModulesRequest const&
                        request) {
              return stub->ListDescendantEventThreatDetectionCustomModules(
                  context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::securitycentermanagement::v1::
             ListDescendantEventThreatDetectionCustomModulesResponse r) {
        std::vector<google::cloud::securitycentermanagement::v1::
                        EventThreatDetectionCustomModule>
            result(r.event_threat_detection_custom_modules().size());
        auto& messages = *r.mutable_event_threat_detection_custom_modules();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::securitycentermanagement::v1::
             EventThreatDetectionCustomModule>
SecurityCenterManagementConnectionImpl::GetEventThreatDetectionCustomModule(
    google::cloud::securitycentermanagement::v1::
        GetEventThreatDetectionCustomModuleRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetEventThreatDetectionCustomModule(
          request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycentermanagement::v1::
                 GetEventThreatDetectionCustomModuleRequest const& request) {
        return stub_->GetEventThreatDetectionCustomModule(context, options,
                                                          request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::securitycentermanagement::v1::
             EventThreatDetectionCustomModule>
SecurityCenterManagementConnectionImpl::CreateEventThreatDetectionCustomModule(
    google::cloud::securitycentermanagement::v1::
        CreateEventThreatDetectionCustomModuleRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateEventThreatDetectionCustomModule(
          request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycentermanagement::v1::
                 CreateEventThreatDetectionCustomModuleRequest const& request) {
        return stub_->CreateEventThreatDetectionCustomModule(context, options,
                                                             request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::securitycentermanagement::v1::
             EventThreatDetectionCustomModule>
SecurityCenterManagementConnectionImpl::UpdateEventThreatDetectionCustomModule(
    google::cloud::securitycentermanagement::v1::
        UpdateEventThreatDetectionCustomModuleRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateEventThreatDetectionCustomModule(
          request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycentermanagement::v1::
                 UpdateEventThreatDetectionCustomModuleRequest const& request) {
        return stub_->UpdateEventThreatDetectionCustomModule(context, options,
                                                             request);
      },
      *current, request, __func__);
}

Status
SecurityCenterManagementConnectionImpl::DeleteEventThreatDetectionCustomModule(
    google::cloud::securitycentermanagement::v1::
        DeleteEventThreatDetectionCustomModuleRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteEventThreatDetectionCustomModule(
          request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycentermanagement::v1::
                 DeleteEventThreatDetectionCustomModuleRequest const& request) {
        return stub_->DeleteEventThreatDetectionCustomModule(context, options,
                                                             request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::securitycentermanagement::v1::
             ValidateEventThreatDetectionCustomModuleResponse>
SecurityCenterManagementConnectionImpl::
    ValidateEventThreatDetectionCustomModule(
        google::cloud::securitycentermanagement::v1::
            ValidateEventThreatDetectionCustomModuleRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ValidateEventThreatDetectionCustomModule(
          request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::securitycentermanagement::v1::
              ValidateEventThreatDetectionCustomModuleRequest const& request) {
        return stub_->ValidateEventThreatDetectionCustomModule(context, options,
                                                               request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::securitycentermanagement::v1::SecurityCenterService>
SecurityCenterManagementConnectionImpl::GetSecurityCenterService(
    google::cloud::securitycentermanagement::v1::
        GetSecurityCenterServiceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetSecurityCenterService(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycentermanagement::v1::
                 GetSecurityCenterServiceRequest const& request) {
        return stub_->GetSecurityCenterService(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::securitycentermanagement::v1::SecurityCenterService>
SecurityCenterManagementConnectionImpl::ListSecurityCenterServices(
    google::cloud::securitycentermanagement::v1::
        ListSecurityCenterServicesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListSecurityCenterServices(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<StreamRange<
      google::cloud::securitycentermanagement::v1::SecurityCenterService>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           securitycentermanagement_v1::SecurityCenterManagementRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::securitycentermanagement::v1::
              ListSecurityCenterServicesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::securitycentermanagement::v1::
                       ListSecurityCenterServicesRequest const& request) {
              return stub->ListSecurityCenterServices(context, options,
                                                      request);
            },
            options, r, function_name);
      },
      [](google::cloud::securitycentermanagement::v1::
             ListSecurityCenterServicesResponse r) {
        std::vector<
            google::cloud::securitycentermanagement::v1::SecurityCenterService>
            result(r.security_center_services().size());
        auto& messages = *r.mutable_security_center_services();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::securitycentermanagement::v1::SecurityCenterService>
SecurityCenterManagementConnectionImpl::UpdateSecurityCenterService(
    google::cloud::securitycentermanagement::v1::
        UpdateSecurityCenterServiceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateSecurityCenterService(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycentermanagement::v1::
                 UpdateSecurityCenterServiceRequest const& request) {
        return stub_->UpdateSecurityCenterService(context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace securitycentermanagement_v1_internal
}  // namespace cloud
}  // namespace google
