// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/retail/v2/prediction_service.proto

#include "google/cloud/retail/v2/prediction_connection.h"
#include "google/cloud/retail/v2/internal/prediction_connection_impl.h"
#include "google/cloud/retail/v2/internal/prediction_option_defaults.h"
#include "google/cloud/retail/v2/internal/prediction_stub_factory.h"
#include "google/cloud/retail/v2/internal/prediction_tracing_connection.h"
#include "google/cloud/retail/v2/prediction_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace retail_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

PredictionServiceConnection::~PredictionServiceConnection() = default;

StatusOr<google::cloud::retail::v2::PredictResponse>
PredictionServiceConnection::Predict(
    google::cloud::retail::v2::PredictRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<PredictionServiceConnection> MakePredictionServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 PredictionServicePolicyOptionList>(options,
                                                                    __func__);
  options =
      retail_v2_internal::PredictionServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = retail_v2_internal::CreateDefaultPredictionServiceStub(
      std::move(auth), options);
  return retail_v2_internal::MakePredictionServiceTracingConnection(
      std::make_shared<retail_v2_internal::PredictionServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace retail_v2
}  // namespace cloud
}  // namespace google
