// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/oslogin/v1/oslogin.proto

#include "google/cloud/oslogin/v1/internal/os_login_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace oslogin_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

OsLoginServiceTracingStub::OsLoginServiceTracingStub(
    std::shared_ptr<OsLoginServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::oslogin::common::SshPublicKey>
OsLoginServiceTracingStub::CreateSshPublicKey(
    grpc::ClientContext& context, Options const& options,
    google::cloud::oslogin::v1::CreateSshPublicKeyRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.oslogin.v1.OsLoginService",
                                     "CreateSshPublicKey");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->CreateSshPublicKey(context, options, request));
}

Status OsLoginServiceTracingStub::DeletePosixAccount(
    grpc::ClientContext& context, Options const& options,
    google::cloud::oslogin::v1::DeletePosixAccountRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.oslogin.v1.OsLoginService",
                                     "DeletePosixAccount");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->DeletePosixAccount(context, options, request));
}

Status OsLoginServiceTracingStub::DeleteSshPublicKey(
    grpc::ClientContext& context, Options const& options,
    google::cloud::oslogin::v1::DeleteSshPublicKeyRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.oslogin.v1.OsLoginService",
                                     "DeleteSshPublicKey");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->DeleteSshPublicKey(context, options, request));
}

StatusOr<google::cloud::oslogin::v1::LoginProfile>
OsLoginServiceTracingStub::GetLoginProfile(
    grpc::ClientContext& context, Options const& options,
    google::cloud::oslogin::v1::GetLoginProfileRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.oslogin.v1.OsLoginService",
                                     "GetLoginProfile");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetLoginProfile(context, options, request));
}

StatusOr<google::cloud::oslogin::common::SshPublicKey>
OsLoginServiceTracingStub::GetSshPublicKey(
    grpc::ClientContext& context, Options const& options,
    google::cloud::oslogin::v1::GetSshPublicKeyRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.oslogin.v1.OsLoginService",
                                     "GetSshPublicKey");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetSshPublicKey(context, options, request));
}

StatusOr<google::cloud::oslogin::v1::ImportSshPublicKeyResponse>
OsLoginServiceTracingStub::ImportSshPublicKey(
    grpc::ClientContext& context, Options const& options,
    google::cloud::oslogin::v1::ImportSshPublicKeyRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.oslogin.v1.OsLoginService",
                                     "ImportSshPublicKey");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ImportSshPublicKey(context, options, request));
}

StatusOr<google::cloud::oslogin::common::SshPublicKey>
OsLoginServiceTracingStub::UpdateSshPublicKey(
    grpc::ClientContext& context, Options const& options,
    google::cloud::oslogin::v1::UpdateSshPublicKeyRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.oslogin.v1.OsLoginService",
                                     "UpdateSshPublicKey");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->UpdateSshPublicKey(context, options, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<OsLoginServiceStub> MakeOsLoginServiceTracingStub(
    std::shared_ptr<OsLoginServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<OsLoginServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace oslogin_v1_internal
}  // namespace cloud
}  // namespace google
