// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/osconfig/v1/osconfig_zonal_service.proto

#include "google/cloud/osconfig/v1/internal/os_config_zonal_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace osconfig_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

OsConfigZonalServiceTracingConnection::OsConfigZonalServiceTracingConnection(
    std::shared_ptr<osconfig_v1::OsConfigZonalServiceConnection> child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>>
OsConfigZonalServiceTracingConnection::CreateOSPolicyAssignment(
    google::cloud::osconfig::v1::CreateOSPolicyAssignmentRequest const&
        request) {
  auto span = internal::MakeSpan(
      "osconfig_v1::OsConfigZonalServiceConnection::CreateOSPolicyAssignment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateOSPolicyAssignment(request));
}

StatusOr<google::longrunning::Operation>
OsConfigZonalServiceTracingConnection::CreateOSPolicyAssignment(
    NoAwaitTag,
    google::cloud::osconfig::v1::CreateOSPolicyAssignmentRequest const&
        request) {
  auto span = internal::MakeSpan(
      "osconfig_v1::OsConfigZonalServiceConnection::CreateOSPolicyAssignment");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->CreateOSPolicyAssignment(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>>
OsConfigZonalServiceTracingConnection::CreateOSPolicyAssignment(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "osconfig_v1::OsConfigZonalServiceConnection::CreateOSPolicyAssignment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateOSPolicyAssignment(operation));
}

future<StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>>
OsConfigZonalServiceTracingConnection::UpdateOSPolicyAssignment(
    google::cloud::osconfig::v1::UpdateOSPolicyAssignmentRequest const&
        request) {
  auto span = internal::MakeSpan(
      "osconfig_v1::OsConfigZonalServiceConnection::UpdateOSPolicyAssignment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateOSPolicyAssignment(request));
}

StatusOr<google::longrunning::Operation>
OsConfigZonalServiceTracingConnection::UpdateOSPolicyAssignment(
    NoAwaitTag,
    google::cloud::osconfig::v1::UpdateOSPolicyAssignmentRequest const&
        request) {
  auto span = internal::MakeSpan(
      "osconfig_v1::OsConfigZonalServiceConnection::UpdateOSPolicyAssignment");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->UpdateOSPolicyAssignment(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>>
OsConfigZonalServiceTracingConnection::UpdateOSPolicyAssignment(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "osconfig_v1::OsConfigZonalServiceConnection::UpdateOSPolicyAssignment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateOSPolicyAssignment(operation));
}

StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>
OsConfigZonalServiceTracingConnection::GetOSPolicyAssignment(
    google::cloud::osconfig::v1::GetOSPolicyAssignmentRequest const& request) {
  auto span = internal::MakeSpan(
      "osconfig_v1::OsConfigZonalServiceConnection::GetOSPolicyAssignment");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetOSPolicyAssignment(request));
}

StreamRange<google::cloud::osconfig::v1::OSPolicyAssignment>
OsConfigZonalServiceTracingConnection::ListOSPolicyAssignments(
    google::cloud::osconfig::v1::ListOSPolicyAssignmentsRequest request) {
  auto span = internal::MakeSpan(
      "osconfig_v1::OsConfigZonalServiceConnection::ListOSPolicyAssignments");
  internal::OTelScope scope(span);
  auto sr = child_->ListOSPolicyAssignments(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::osconfig::v1::OSPolicyAssignment>(std::move(span),
                                                       std::move(sr));
}

StreamRange<google::cloud::osconfig::v1::OSPolicyAssignment>
OsConfigZonalServiceTracingConnection::ListOSPolicyAssignmentRevisions(
    google::cloud::osconfig::v1::ListOSPolicyAssignmentRevisionsRequest
        request) {
  auto span = internal::MakeSpan(
      "osconfig_v1::OsConfigZonalServiceConnection::"
      "ListOSPolicyAssignmentRevisions");
  internal::OTelScope scope(span);
  auto sr = child_->ListOSPolicyAssignmentRevisions(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::osconfig::v1::OSPolicyAssignment>(std::move(span),
                                                       std::move(sr));
}

future<
    StatusOr<google::cloud::osconfig::v1::OSPolicyAssignmentOperationMetadata>>
OsConfigZonalServiceTracingConnection::DeleteOSPolicyAssignment(
    google::cloud::osconfig::v1::DeleteOSPolicyAssignmentRequest const&
        request) {
  auto span = internal::MakeSpan(
      "osconfig_v1::OsConfigZonalServiceConnection::DeleteOSPolicyAssignment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteOSPolicyAssignment(request));
}

StatusOr<google::longrunning::Operation>
OsConfigZonalServiceTracingConnection::DeleteOSPolicyAssignment(
    NoAwaitTag,
    google::cloud::osconfig::v1::DeleteOSPolicyAssignmentRequest const&
        request) {
  auto span = internal::MakeSpan(
      "osconfig_v1::OsConfigZonalServiceConnection::DeleteOSPolicyAssignment");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->DeleteOSPolicyAssignment(NoAwaitTag{}, request));
}

future<
    StatusOr<google::cloud::osconfig::v1::OSPolicyAssignmentOperationMetadata>>
OsConfigZonalServiceTracingConnection::DeleteOSPolicyAssignment(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "osconfig_v1::OsConfigZonalServiceConnection::DeleteOSPolicyAssignment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteOSPolicyAssignment(operation));
}

StatusOr<google::cloud::osconfig::v1::OSPolicyAssignmentReport>
OsConfigZonalServiceTracingConnection::GetOSPolicyAssignmentReport(
    google::cloud::osconfig::v1::GetOSPolicyAssignmentReportRequest const&
        request) {
  auto span = internal::MakeSpan(
      "osconfig_v1::OsConfigZonalServiceConnection::"
      "GetOSPolicyAssignmentReport");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetOSPolicyAssignmentReport(request));
}

StreamRange<google::cloud::osconfig::v1::OSPolicyAssignmentReport>
OsConfigZonalServiceTracingConnection::ListOSPolicyAssignmentReports(
    google::cloud::osconfig::v1::ListOSPolicyAssignmentReportsRequest request) {
  auto span = internal::MakeSpan(
      "osconfig_v1::OsConfigZonalServiceConnection::"
      "ListOSPolicyAssignmentReports");
  internal::OTelScope scope(span);
  auto sr = child_->ListOSPolicyAssignmentReports(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::osconfig::v1::OSPolicyAssignmentReport>(std::move(span),
                                                             std::move(sr));
}

StatusOr<google::cloud::osconfig::v1::Inventory>
OsConfigZonalServiceTracingConnection::GetInventory(
    google::cloud::osconfig::v1::GetInventoryRequest const& request) {
  auto span = internal::MakeSpan(
      "osconfig_v1::OsConfigZonalServiceConnection::GetInventory");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetInventory(request));
}

StreamRange<google::cloud::osconfig::v1::Inventory>
OsConfigZonalServiceTracingConnection::ListInventories(
    google::cloud::osconfig::v1::ListInventoriesRequest request) {
  auto span = internal::MakeSpan(
      "osconfig_v1::OsConfigZonalServiceConnection::ListInventories");
  internal::OTelScope scope(span);
  auto sr = child_->ListInventories(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::osconfig::v1::Inventory>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::osconfig::v1::VulnerabilityReport>
OsConfigZonalServiceTracingConnection::GetVulnerabilityReport(
    google::cloud::osconfig::v1::GetVulnerabilityReportRequest const& request) {
  auto span = internal::MakeSpan(
      "osconfig_v1::OsConfigZonalServiceConnection::GetVulnerabilityReport");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetVulnerabilityReport(request));
}

StreamRange<google::cloud::osconfig::v1::VulnerabilityReport>
OsConfigZonalServiceTracingConnection::ListVulnerabilityReports(
    google::cloud::osconfig::v1::ListVulnerabilityReportsRequest request) {
  auto span = internal::MakeSpan(
      "osconfig_v1::OsConfigZonalServiceConnection::ListVulnerabilityReports");
  internal::OTelScope scope(span);
  auto sr = child_->ListVulnerabilityReports(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::osconfig::v1::VulnerabilityReport>(std::move(span),
                                                        std::move(sr));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<osconfig_v1::OsConfigZonalServiceConnection>
MakeOsConfigZonalServiceTracingConnection(
    std::shared_ptr<osconfig_v1::OsConfigZonalServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<OsConfigZonalServiceTracingConnection>(
        std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace osconfig_v1_internal
}  // namespace cloud
}  // namespace google
