// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networksecurity/v1/network_security.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSECURITY_V1_MOCKS_MOCK_NETWORK_SECURITY_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSECURITY_V1_MOCKS_MOCK_NETWORK_SECURITY_CONNECTION_H

#include "google/cloud/networksecurity/v1/network_security_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace networksecurity_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `NetworkSecurityConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `NetworkSecurityClient`. To do so,
 * construct an object of type `NetworkSecurityClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockNetworkSecurityConnection
    : public networksecurity_v1::NetworkSecurityConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::networksecurity::v1::AuthorizationPolicy>),
      ListAuthorizationPolicies,
      (google::cloud::networksecurity::v1::ListAuthorizationPoliciesRequest
           request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>,
      GetAuthorizationPolicy,
      (google::cloud::networksecurity::v1::GetAuthorizationPolicyRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateAuthorizationPolicy(Matcher<google::cloud::networksecurity::v1::CreateAuthorizationPolicyRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>>,
      CreateAuthorizationPolicy,
      (google::cloud::networksecurity::v1::
           CreateAuthorizationPolicyRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateAuthorizationPolicy(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>,
              CreateAuthorizationPolicy,
              (NoAwaitTag, google::cloud::networksecurity::v1::
                               CreateAuthorizationPolicyRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateAuthorizationPolicy(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>>,
      CreateAuthorizationPolicy,
      (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateAuthorizationPolicy(Matcher<google::cloud::networksecurity::v1::UpdateAuthorizationPolicyRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>>,
      UpdateAuthorizationPolicy,
      (google::cloud::networksecurity::v1::
           UpdateAuthorizationPolicyRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateAuthorizationPolicy(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>,
              UpdateAuthorizationPolicy,
              (NoAwaitTag, google::cloud::networksecurity::v1::
                               UpdateAuthorizationPolicyRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateAuthorizationPolicy(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>>,
      UpdateAuthorizationPolicy,
      (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteAuthorizationPolicy(Matcher<google::cloud::networksecurity::v1::DeleteAuthorizationPolicyRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>,
      DeleteAuthorizationPolicy,
      (google::cloud::networksecurity::v1::
           DeleteAuthorizationPolicyRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteAuthorizationPolicy(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>,
              DeleteAuthorizationPolicy,
              (NoAwaitTag, google::cloud::networksecurity::v1::
                               DeleteAuthorizationPolicyRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteAuthorizationPolicy(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>,
      DeleteAuthorizationPolicy,
      (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::networksecurity::v1::ServerTlsPolicy>),
      ListServerTlsPolicies,
      (google::cloud::networksecurity::v1::ListServerTlsPoliciesRequest
           request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>,
      GetServerTlsPolicy,
      (google::cloud::networksecurity::v1::GetServerTlsPolicyRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateServerTlsPolicy(Matcher<google::cloud::networksecurity::v1::CreateServerTlsPolicyRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>>,
      CreateServerTlsPolicy,
      (google::cloud::networksecurity::v1::CreateServerTlsPolicyRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateServerTlsPolicy(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateServerTlsPolicy,
      (NoAwaitTag,
       google::cloud::networksecurity::v1::CreateServerTlsPolicyRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateServerTlsPolicy(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>>,
      CreateServerTlsPolicy, (google::longrunning::Operation const& operation),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateServerTlsPolicy(Matcher<google::cloud::networksecurity::v1::UpdateServerTlsPolicyRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>>,
      UpdateServerTlsPolicy,
      (google::cloud::networksecurity::v1::UpdateServerTlsPolicyRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateServerTlsPolicy(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UpdateServerTlsPolicy,
      (NoAwaitTag,
       google::cloud::networksecurity::v1::UpdateServerTlsPolicyRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateServerTlsPolicy(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>>,
      UpdateServerTlsPolicy, (google::longrunning::Operation const& operation),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteServerTlsPolicy(Matcher<google::cloud::networksecurity::v1::DeleteServerTlsPolicyRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>,
      DeleteServerTlsPolicy,
      (google::cloud::networksecurity::v1::DeleteServerTlsPolicyRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteServerTlsPolicy(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteServerTlsPolicy,
      (NoAwaitTag,
       google::cloud::networksecurity::v1::DeleteServerTlsPolicyRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteServerTlsPolicy(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>,
      DeleteServerTlsPolicy, (google::longrunning::Operation const& operation),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::networksecurity::v1::ClientTlsPolicy>),
      ListClientTlsPolicies,
      (google::cloud::networksecurity::v1::ListClientTlsPoliciesRequest
           request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>,
      GetClientTlsPolicy,
      (google::cloud::networksecurity::v1::GetClientTlsPolicyRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateClientTlsPolicy(Matcher<google::cloud::networksecurity::v1::CreateClientTlsPolicyRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>>,
      CreateClientTlsPolicy,
      (google::cloud::networksecurity::v1::CreateClientTlsPolicyRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateClientTlsPolicy(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateClientTlsPolicy,
      (NoAwaitTag,
       google::cloud::networksecurity::v1::CreateClientTlsPolicyRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateClientTlsPolicy(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>>,
      CreateClientTlsPolicy, (google::longrunning::Operation const& operation),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateClientTlsPolicy(Matcher<google::cloud::networksecurity::v1::UpdateClientTlsPolicyRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>>,
      UpdateClientTlsPolicy,
      (google::cloud::networksecurity::v1::UpdateClientTlsPolicyRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateClientTlsPolicy(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UpdateClientTlsPolicy,
      (NoAwaitTag,
       google::cloud::networksecurity::v1::UpdateClientTlsPolicyRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateClientTlsPolicy(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>>,
      UpdateClientTlsPolicy, (google::longrunning::Operation const& operation),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteClientTlsPolicy(Matcher<google::cloud::networksecurity::v1::DeleteClientTlsPolicyRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>,
      DeleteClientTlsPolicy,
      (google::cloud::networksecurity::v1::DeleteClientTlsPolicyRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteClientTlsPolicy(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteClientTlsPolicy,
      (NoAwaitTag,
       google::cloud::networksecurity::v1::DeleteClientTlsPolicyRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteClientTlsPolicy(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>,
      DeleteClientTlsPolicy, (google::longrunning::Operation const& operation),
      (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networksecurity_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSECURITY_V1_MOCKS_MOCK_NETWORK_SECURITY_CONNECTION_H
