// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/notification_service.proto

#include "google/cloud/monitoring/v3/internal/notification_channel_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace monitoring_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

NotificationChannelServiceTracingConnection::
    NotificationChannelServiceTracingConnection(
        std::shared_ptr<monitoring_v3::NotificationChannelServiceConnection>
            child)
    : child_(std::move(child)) {}

StreamRange<google::monitoring::v3::NotificationChannelDescriptor>
NotificationChannelServiceTracingConnection::ListNotificationChannelDescriptors(
    google::monitoring::v3::ListNotificationChannelDescriptorsRequest request) {
  auto span = internal::MakeSpan(
      "monitoring_v3::NotificationChannelServiceConnection::"
      "ListNotificationChannelDescriptors");
  internal::OTelScope scope(span);
  auto sr = child_->ListNotificationChannelDescriptors(std::move(request));
  return internal::MakeTracedStreamRange<
      google::monitoring::v3::NotificationChannelDescriptor>(std::move(span),
                                                             std::move(sr));
}

StatusOr<google::monitoring::v3::NotificationChannelDescriptor>
NotificationChannelServiceTracingConnection::GetNotificationChannelDescriptor(
    google::monitoring::v3::GetNotificationChannelDescriptorRequest const&
        request) {
  auto span = internal::MakeSpan(
      "monitoring_v3::NotificationChannelServiceConnection::"
      "GetNotificationChannelDescriptor");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span,
                           child_->GetNotificationChannelDescriptor(request));
}

StreamRange<google::monitoring::v3::NotificationChannel>
NotificationChannelServiceTracingConnection::ListNotificationChannels(
    google::monitoring::v3::ListNotificationChannelsRequest request) {
  auto span = internal::MakeSpan(
      "monitoring_v3::NotificationChannelServiceConnection::"
      "ListNotificationChannels");
  internal::OTelScope scope(span);
  auto sr = child_->ListNotificationChannels(std::move(request));
  return internal::MakeTracedStreamRange<
      google::monitoring::v3::NotificationChannel>(std::move(span),
                                                   std::move(sr));
}

StatusOr<google::monitoring::v3::NotificationChannel>
NotificationChannelServiceTracingConnection::GetNotificationChannel(
    google::monitoring::v3::GetNotificationChannelRequest const& request) {
  auto span = internal::MakeSpan(
      "monitoring_v3::NotificationChannelServiceConnection::"
      "GetNotificationChannel");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetNotificationChannel(request));
}

StatusOr<google::monitoring::v3::NotificationChannel>
NotificationChannelServiceTracingConnection::CreateNotificationChannel(
    google::monitoring::v3::CreateNotificationChannelRequest const& request) {
  auto span = internal::MakeSpan(
      "monitoring_v3::NotificationChannelServiceConnection::"
      "CreateNotificationChannel");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateNotificationChannel(request));
}

StatusOr<google::monitoring::v3::NotificationChannel>
NotificationChannelServiceTracingConnection::UpdateNotificationChannel(
    google::monitoring::v3::UpdateNotificationChannelRequest const& request) {
  auto span = internal::MakeSpan(
      "monitoring_v3::NotificationChannelServiceConnection::"
      "UpdateNotificationChannel");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateNotificationChannel(request));
}

Status NotificationChannelServiceTracingConnection::DeleteNotificationChannel(
    google::monitoring::v3::DeleteNotificationChannelRequest const& request) {
  auto span = internal::MakeSpan(
      "monitoring_v3::NotificationChannelServiceConnection::"
      "DeleteNotificationChannel");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteNotificationChannel(request));
}

Status NotificationChannelServiceTracingConnection::
    SendNotificationChannelVerificationCode(
        google::monitoring::v3::
            SendNotificationChannelVerificationCodeRequest const& request) {
  auto span = internal::MakeSpan(
      "monitoring_v3::NotificationChannelServiceConnection::"
      "SendNotificationChannelVerificationCode");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(
      *span, child_->SendNotificationChannelVerificationCode(request));
}

StatusOr<google::monitoring::v3::GetNotificationChannelVerificationCodeResponse>
NotificationChannelServiceTracingConnection::
    GetNotificationChannelVerificationCode(
        google::monitoring::v3::
            GetNotificationChannelVerificationCodeRequest const& request) {
  auto span = internal::MakeSpan(
      "monitoring_v3::NotificationChannelServiceConnection::"
      "GetNotificationChannelVerificationCode");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(
      *span, child_->GetNotificationChannelVerificationCode(request));
}

StatusOr<google::monitoring::v3::NotificationChannel>
NotificationChannelServiceTracingConnection::VerifyNotificationChannel(
    google::monitoring::v3::VerifyNotificationChannelRequest const& request) {
  auto span = internal::MakeSpan(
      "monitoring_v3::NotificationChannelServiceConnection::"
      "VerifyNotificationChannel");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->VerifyNotificationChannel(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<monitoring_v3::NotificationChannelServiceConnection>
MakeNotificationChannelServiceTracingConnection(
    std::shared_ptr<monitoring_v3::NotificationChannelServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<NotificationChannelServiceTracingConnection>(
        std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3_internal
}  // namespace cloud
}  // namespace google
