// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/dashboard/v1/dashboards_service.proto

#include "google/cloud/monitoring/dashboard/v1/internal/dashboards_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/monitoring/dashboard/v1/dashboards_service.grpc.pb.h>
#include <memory>
#include <set>
#include <string>
#include <utility>

namespace google {
namespace cloud {
namespace monitoring_dashboard_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DashboardsServiceLogging::DashboardsServiceLogging(
    std::shared_ptr<DashboardsServiceStub> child,
    TracingOptions tracing_options, std::set<std::string> const&)
    : child_(std::move(child)), tracing_options_(std::move(tracing_options)) {}

StatusOr<google::monitoring::dashboard::v1::Dashboard>
DashboardsServiceLogging::CreateDashboard(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::dashboard::v1::CreateDashboardRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::monitoring::dashboard::v1::CreateDashboardRequest const&
                 request) {
        return child_->CreateDashboard(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::monitoring::dashboard::v1::ListDashboardsResponse>
DashboardsServiceLogging::ListDashboards(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::dashboard::v1::ListDashboardsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::monitoring::dashboard::v1::ListDashboardsRequest const&
                 request) {
        return child_->ListDashboards(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::monitoring::dashboard::v1::Dashboard>
DashboardsServiceLogging::GetDashboard(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::dashboard::v1::GetDashboardRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::monitoring::dashboard::v1::GetDashboardRequest const&
                 request) {
        return child_->GetDashboard(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status DashboardsServiceLogging::DeleteDashboard(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::dashboard::v1::DeleteDashboardRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::monitoring::dashboard::v1::DeleteDashboardRequest const&
                 request) {
        return child_->DeleteDashboard(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::monitoring::dashboard::v1::Dashboard>
DashboardsServiceLogging::UpdateDashboard(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::dashboard::v1::UpdateDashboardRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::monitoring::dashboard::v1::UpdateDashboardRequest const&
                 request) {
        return child_->UpdateDashboard(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_dashboard_v1_internal
}  // namespace cloud
}  // namespace google
