// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

#include "google/cloud/migrationcenter/v1/internal/migration_center_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/migrationcenter/v1/migrationcenter.grpc.pb.h>
#include <memory>
#include <set>
#include <string>
#include <utility>

namespace google {
namespace cloud {
namespace migrationcenter_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

MigrationCenterLogging::MigrationCenterLogging(
    std::shared_ptr<MigrationCenterStub> child, TracingOptions tracing_options,
    std::set<std::string> const&)
    : child_(std::move(child)), tracing_options_(std::move(tracing_options)) {}

StatusOr<google::cloud::migrationcenter::v1::ListAssetsResponse>
MigrationCenterLogging::ListAssets(
    grpc::ClientContext& context, Options const& options,
    google::cloud::migrationcenter::v1::ListAssetsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::ListAssetsRequest const&
                 request) {
        return child_->ListAssets(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::migrationcenter::v1::Asset>
MigrationCenterLogging::GetAsset(
    grpc::ClientContext& context, Options const& options,
    google::cloud::migrationcenter::v1::GetAssetRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::migrationcenter::v1::GetAssetRequest const& request) {
        return child_->GetAsset(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::migrationcenter::v1::Asset>
MigrationCenterLogging::UpdateAsset(
    grpc::ClientContext& context, Options const& options,
    google::cloud::migrationcenter::v1::UpdateAssetRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::UpdateAssetRequest const&
                 request) {
        return child_->UpdateAsset(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::migrationcenter::v1::BatchUpdateAssetsResponse>
MigrationCenterLogging::BatchUpdateAssets(
    grpc::ClientContext& context, Options const& options,
    google::cloud::migrationcenter::v1::BatchUpdateAssetsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::BatchUpdateAssetsRequest const&
                 request) {
        return child_->BatchUpdateAssets(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status MigrationCenterLogging::DeleteAsset(
    grpc::ClientContext& context, Options const& options,
    google::cloud::migrationcenter::v1::DeleteAssetRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::DeleteAssetRequest const&
                 request) {
        return child_->DeleteAsset(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status MigrationCenterLogging::BatchDeleteAssets(
    grpc::ClientContext& context, Options const& options,
    google::cloud::migrationcenter::v1::BatchDeleteAssetsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::BatchDeleteAssetsRequest const&
                 request) {
        return child_->BatchDeleteAssets(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::migrationcenter::v1::ReportAssetFramesResponse>
MigrationCenterLogging::ReportAssetFrames(
    grpc::ClientContext& context, Options const& options,
    google::cloud::migrationcenter::v1::ReportAssetFramesRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::ReportAssetFramesRequest const&
                 request) {
        return child_->ReportAssetFrames(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::migrationcenter::v1::AggregateAssetsValuesResponse>
MigrationCenterLogging::AggregateAssetsValues(
    grpc::ClientContext& context, Options const& options,
    google::cloud::migrationcenter::v1::AggregateAssetsValuesRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::
                 AggregateAssetsValuesRequest const& request) {
        return child_->AggregateAssetsValues(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
MigrationCenterLogging::AsyncCreateImportJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::migrationcenter::v1::CreateImportJobRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::migrationcenter::v1::CreateImportJobRequest const&
                 request) {
        return child_->AsyncCreateImportJob(cq, std::move(context),
                                            std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
MigrationCenterLogging::CreateImportJob(
    grpc::ClientContext& context, Options options,
    google::cloud::migrationcenter::v1::CreateImportJobRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::CreateImportJobRequest const&
                 request) {
        return child_->CreateImportJob(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::migrationcenter::v1::ListImportJobsResponse>
MigrationCenterLogging::ListImportJobs(
    grpc::ClientContext& context, Options const& options,
    google::cloud::migrationcenter::v1::ListImportJobsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::ListImportJobsRequest const&
                 request) {
        return child_->ListImportJobs(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::migrationcenter::v1::ImportJob>
MigrationCenterLogging::GetImportJob(
    grpc::ClientContext& context, Options const& options,
    google::cloud::migrationcenter::v1::GetImportJobRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::GetImportJobRequest const&
                 request) {
        return child_->GetImportJob(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
MigrationCenterLogging::AsyncDeleteImportJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::migrationcenter::v1::DeleteImportJobRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::migrationcenter::v1::DeleteImportJobRequest const&
                 request) {
        return child_->AsyncDeleteImportJob(cq, std::move(context),
                                            std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
MigrationCenterLogging::DeleteImportJob(
    grpc::ClientContext& context, Options options,
    google::cloud::migrationcenter::v1::DeleteImportJobRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::DeleteImportJobRequest const&
                 request) {
        return child_->DeleteImportJob(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
MigrationCenterLogging::AsyncUpdateImportJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::migrationcenter::v1::UpdateImportJobRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::migrationcenter::v1::UpdateImportJobRequest const&
                 request) {
        return child_->AsyncUpdateImportJob(cq, std::move(context),
                                            std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
MigrationCenterLogging::UpdateImportJob(
    grpc::ClientContext& context, Options options,
    google::cloud::migrationcenter::v1::UpdateImportJobRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::UpdateImportJobRequest const&
                 request) {
        return child_->UpdateImportJob(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
MigrationCenterLogging::AsyncValidateImportJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::migrationcenter::v1::ValidateImportJobRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::migrationcenter::v1::ValidateImportJobRequest const&
                 request) {
        return child_->AsyncValidateImportJob(cq, std::move(context),
                                              std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
MigrationCenterLogging::ValidateImportJob(
    grpc::ClientContext& context, Options options,
    google::cloud::migrationcenter::v1::ValidateImportJobRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::ValidateImportJobRequest const&
                 request) {
        return child_->ValidateImportJob(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
MigrationCenterLogging::AsyncRunImportJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::migrationcenter::v1::RunImportJobRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::migrationcenter::v1::RunImportJobRequest const&
                 request) {
        return child_->AsyncRunImportJob(cq, std::move(context),
                                         std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> MigrationCenterLogging::RunImportJob(
    grpc::ClientContext& context, Options options,
    google::cloud::migrationcenter::v1::RunImportJobRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::RunImportJobRequest const&
                 request) {
        return child_->RunImportJob(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::migrationcenter::v1::ImportDataFile>
MigrationCenterLogging::GetImportDataFile(
    grpc::ClientContext& context, Options const& options,
    google::cloud::migrationcenter::v1::GetImportDataFileRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::GetImportDataFileRequest const&
                 request) {
        return child_->GetImportDataFile(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::migrationcenter::v1::ListImportDataFilesResponse>
MigrationCenterLogging::ListImportDataFiles(
    grpc::ClientContext& context, Options const& options,
    google::cloud::migrationcenter::v1::ListImportDataFilesRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::migrationcenter::v1::ListImportDataFilesRequest const&
              request) {
        return child_->ListImportDataFiles(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
MigrationCenterLogging::AsyncCreateImportDataFile(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::migrationcenter::v1::CreateImportDataFileRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::migrationcenter::v1::CreateImportDataFileRequest const&
              request) {
        return child_->AsyncCreateImportDataFile(cq, std::move(context),
                                                 std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
MigrationCenterLogging::CreateImportDataFile(
    grpc::ClientContext& context, Options options,
    google::cloud::migrationcenter::v1::CreateImportDataFileRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::migrationcenter::v1::CreateImportDataFileRequest const&
              request) {
        return child_->CreateImportDataFile(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
MigrationCenterLogging::AsyncDeleteImportDataFile(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::migrationcenter::v1::DeleteImportDataFileRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::migrationcenter::v1::DeleteImportDataFileRequest const&
              request) {
        return child_->AsyncDeleteImportDataFile(cq, std::move(context),
                                                 std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
MigrationCenterLogging::DeleteImportDataFile(
    grpc::ClientContext& context, Options options,
    google::cloud::migrationcenter::v1::DeleteImportDataFileRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::migrationcenter::v1::DeleteImportDataFileRequest const&
              request) {
        return child_->DeleteImportDataFile(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::migrationcenter::v1::ListGroupsResponse>
MigrationCenterLogging::ListGroups(
    grpc::ClientContext& context, Options const& options,
    google::cloud::migrationcenter::v1::ListGroupsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::ListGroupsRequest const&
                 request) {
        return child_->ListGroups(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::migrationcenter::v1::Group>
MigrationCenterLogging::GetGroup(
    grpc::ClientContext& context, Options const& options,
    google::cloud::migrationcenter::v1::GetGroupRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::migrationcenter::v1::GetGroupRequest const& request) {
        return child_->GetGroup(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
MigrationCenterLogging::AsyncCreateGroup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::migrationcenter::v1::CreateGroupRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::migrationcenter::v1::CreateGroupRequest const&
                 request) {
        return child_->AsyncCreateGroup(cq, std::move(context),
                                        std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> MigrationCenterLogging::CreateGroup(
    grpc::ClientContext& context, Options options,
    google::cloud::migrationcenter::v1::CreateGroupRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::CreateGroupRequest const&
                 request) {
        return child_->CreateGroup(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
MigrationCenterLogging::AsyncUpdateGroup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::migrationcenter::v1::UpdateGroupRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::migrationcenter::v1::UpdateGroupRequest const&
                 request) {
        return child_->AsyncUpdateGroup(cq, std::move(context),
                                        std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> MigrationCenterLogging::UpdateGroup(
    grpc::ClientContext& context, Options options,
    google::cloud::migrationcenter::v1::UpdateGroupRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::UpdateGroupRequest const&
                 request) {
        return child_->UpdateGroup(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
MigrationCenterLogging::AsyncDeleteGroup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::migrationcenter::v1::DeleteGroupRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::migrationcenter::v1::DeleteGroupRequest const&
                 request) {
        return child_->AsyncDeleteGroup(cq, std::move(context),
                                        std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> MigrationCenterLogging::DeleteGroup(
    grpc::ClientContext& context, Options options,
    google::cloud::migrationcenter::v1::DeleteGroupRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::DeleteGroupRequest const&
                 request) {
        return child_->DeleteGroup(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
MigrationCenterLogging::AsyncAddAssetsToGroup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::migrationcenter::v1::AddAssetsToGroupRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::migrationcenter::v1::AddAssetsToGroupRequest const&
                 request) {
        return child_->AsyncAddAssetsToGroup(cq, std::move(context),
                                             std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
MigrationCenterLogging::AddAssetsToGroup(
    grpc::ClientContext& context, Options options,
    google::cloud::migrationcenter::v1::AddAssetsToGroupRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::AddAssetsToGroupRequest const&
                 request) {
        return child_->AddAssetsToGroup(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
MigrationCenterLogging::AsyncRemoveAssetsFromGroup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::migrationcenter::v1::RemoveAssetsFromGroupRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::migrationcenter::v1::
                 RemoveAssetsFromGroupRequest const& request) {
        return child_->AsyncRemoveAssetsFromGroup(cq, std::move(context),
                                                  std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
MigrationCenterLogging::RemoveAssetsFromGroup(
    grpc::ClientContext& context, Options options,
    google::cloud::migrationcenter::v1::RemoveAssetsFromGroupRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::
                 RemoveAssetsFromGroupRequest const& request) {
        return child_->RemoveAssetsFromGroup(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::migrationcenter::v1::ListErrorFramesResponse>
MigrationCenterLogging::ListErrorFrames(
    grpc::ClientContext& context, Options const& options,
    google::cloud::migrationcenter::v1::ListErrorFramesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::ListErrorFramesRequest const&
                 request) {
        return child_->ListErrorFrames(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::migrationcenter::v1::ErrorFrame>
MigrationCenterLogging::GetErrorFrame(
    grpc::ClientContext& context, Options const& options,
    google::cloud::migrationcenter::v1::GetErrorFrameRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::GetErrorFrameRequest const&
                 request) {
        return child_->GetErrorFrame(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::migrationcenter::v1::ListSourcesResponse>
MigrationCenterLogging::ListSources(
    grpc::ClientContext& context, Options const& options,
    google::cloud::migrationcenter::v1::ListSourcesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::ListSourcesRequest const&
                 request) {
        return child_->ListSources(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::migrationcenter::v1::Source>
MigrationCenterLogging::GetSource(
    grpc::ClientContext& context, Options const& options,
    google::cloud::migrationcenter::v1::GetSourceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::migrationcenter::v1::GetSourceRequest const& request) {
        return child_->GetSource(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
MigrationCenterLogging::AsyncCreateSource(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::migrationcenter::v1::CreateSourceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::migrationcenter::v1::CreateSourceRequest const&
                 request) {
        return child_->AsyncCreateSource(cq, std::move(context),
                                         std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> MigrationCenterLogging::CreateSource(
    grpc::ClientContext& context, Options options,
    google::cloud::migrationcenter::v1::CreateSourceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::CreateSourceRequest const&
                 request) {
        return child_->CreateSource(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
MigrationCenterLogging::AsyncUpdateSource(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::migrationcenter::v1::UpdateSourceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::migrationcenter::v1::UpdateSourceRequest const&
                 request) {
        return child_->AsyncUpdateSource(cq, std::move(context),
                                         std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> MigrationCenterLogging::UpdateSource(
    grpc::ClientContext& context, Options options,
    google::cloud::migrationcenter::v1::UpdateSourceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::UpdateSourceRequest const&
                 request) {
        return child_->UpdateSource(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
MigrationCenterLogging::AsyncDeleteSource(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::migrationcenter::v1::DeleteSourceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::migrationcenter::v1::DeleteSourceRequest const&
                 request) {
        return child_->AsyncDeleteSource(cq, std::move(context),
                                         std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> MigrationCenterLogging::DeleteSource(
    grpc::ClientContext& context, Options options,
    google::cloud::migrationcenter::v1::DeleteSourceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::DeleteSourceRequest const&
                 request) {
        return child_->DeleteSource(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::migrationcenter::v1::ListPreferenceSetsResponse>
MigrationCenterLogging::ListPreferenceSets(
    grpc::ClientContext& context, Options const& options,
    google::cloud::migrationcenter::v1::ListPreferenceSetsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::migrationcenter::v1::ListPreferenceSetsRequest const&
              request) {
        return child_->ListPreferenceSets(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::migrationcenter::v1::PreferenceSet>
MigrationCenterLogging::GetPreferenceSet(
    grpc::ClientContext& context, Options const& options,
    google::cloud::migrationcenter::v1::GetPreferenceSetRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::GetPreferenceSetRequest const&
                 request) {
        return child_->GetPreferenceSet(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
MigrationCenterLogging::AsyncCreatePreferenceSet(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::migrationcenter::v1::CreatePreferenceSetRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::migrationcenter::v1::CreatePreferenceSetRequest const&
              request) {
        return child_->AsyncCreatePreferenceSet(cq, std::move(context),
                                                std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
MigrationCenterLogging::CreatePreferenceSet(
    grpc::ClientContext& context, Options options,
    google::cloud::migrationcenter::v1::CreatePreferenceSetRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::migrationcenter::v1::CreatePreferenceSetRequest const&
              request) {
        return child_->CreatePreferenceSet(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
MigrationCenterLogging::AsyncUpdatePreferenceSet(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::migrationcenter::v1::UpdatePreferenceSetRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::migrationcenter::v1::UpdatePreferenceSetRequest const&
              request) {
        return child_->AsyncUpdatePreferenceSet(cq, std::move(context),
                                                std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
MigrationCenterLogging::UpdatePreferenceSet(
    grpc::ClientContext& context, Options options,
    google::cloud::migrationcenter::v1::UpdatePreferenceSetRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::migrationcenter::v1::UpdatePreferenceSetRequest const&
              request) {
        return child_->UpdatePreferenceSet(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
MigrationCenterLogging::AsyncDeletePreferenceSet(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::migrationcenter::v1::DeletePreferenceSetRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::migrationcenter::v1::DeletePreferenceSetRequest const&
              request) {
        return child_->AsyncDeletePreferenceSet(cq, std::move(context),
                                                std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
MigrationCenterLogging::DeletePreferenceSet(
    grpc::ClientContext& context, Options options,
    google::cloud::migrationcenter::v1::DeletePreferenceSetRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::migrationcenter::v1::DeletePreferenceSetRequest const&
              request) {
        return child_->DeletePreferenceSet(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::migrationcenter::v1::Settings>
MigrationCenterLogging::GetSettings(
    grpc::ClientContext& context, Options const& options,
    google::cloud::migrationcenter::v1::GetSettingsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::GetSettingsRequest const&
                 request) {
        return child_->GetSettings(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
MigrationCenterLogging::AsyncUpdateSettings(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::migrationcenter::v1::UpdateSettingsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::migrationcenter::v1::UpdateSettingsRequest const&
                 request) {
        return child_->AsyncUpdateSettings(cq, std::move(context),
                                           std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> MigrationCenterLogging::UpdateSettings(
    grpc::ClientContext& context, Options options,
    google::cloud::migrationcenter::v1::UpdateSettingsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::UpdateSettingsRequest const&
                 request) {
        return child_->UpdateSettings(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
MigrationCenterLogging::AsyncCreateReportConfig(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::migrationcenter::v1::CreateReportConfigRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::migrationcenter::v1::CreateReportConfigRequest const&
              request) {
        return child_->AsyncCreateReportConfig(cq, std::move(context),
                                               std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
MigrationCenterLogging::CreateReportConfig(
    grpc::ClientContext& context, Options options,
    google::cloud::migrationcenter::v1::CreateReportConfigRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::migrationcenter::v1::CreateReportConfigRequest const&
              request) {
        return child_->CreateReportConfig(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::migrationcenter::v1::ReportConfig>
MigrationCenterLogging::GetReportConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::migrationcenter::v1::GetReportConfigRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::GetReportConfigRequest const&
                 request) {
        return child_->GetReportConfig(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::migrationcenter::v1::ListReportConfigsResponse>
MigrationCenterLogging::ListReportConfigs(
    grpc::ClientContext& context, Options const& options,
    google::cloud::migrationcenter::v1::ListReportConfigsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::ListReportConfigsRequest const&
                 request) {
        return child_->ListReportConfigs(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
MigrationCenterLogging::AsyncDeleteReportConfig(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::migrationcenter::v1::DeleteReportConfigRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::migrationcenter::v1::DeleteReportConfigRequest const&
              request) {
        return child_->AsyncDeleteReportConfig(cq, std::move(context),
                                               std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
MigrationCenterLogging::DeleteReportConfig(
    grpc::ClientContext& context, Options options,
    google::cloud::migrationcenter::v1::DeleteReportConfigRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::migrationcenter::v1::DeleteReportConfigRequest const&
              request) {
        return child_->DeleteReportConfig(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
MigrationCenterLogging::AsyncCreateReport(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::migrationcenter::v1::CreateReportRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::migrationcenter::v1::CreateReportRequest const&
                 request) {
        return child_->AsyncCreateReport(cq, std::move(context),
                                         std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> MigrationCenterLogging::CreateReport(
    grpc::ClientContext& context, Options options,
    google::cloud::migrationcenter::v1::CreateReportRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::CreateReportRequest const&
                 request) {
        return child_->CreateReport(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::migrationcenter::v1::Report>
MigrationCenterLogging::GetReport(
    grpc::ClientContext& context, Options const& options,
    google::cloud::migrationcenter::v1::GetReportRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::migrationcenter::v1::GetReportRequest const& request) {
        return child_->GetReport(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::migrationcenter::v1::ListReportsResponse>
MigrationCenterLogging::ListReports(
    grpc::ClientContext& context, Options const& options,
    google::cloud::migrationcenter::v1::ListReportsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::ListReportsRequest const&
                 request) {
        return child_->ListReports(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
MigrationCenterLogging::AsyncDeleteReport(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::migrationcenter::v1::DeleteReportRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::migrationcenter::v1::DeleteReportRequest const&
                 request) {
        return child_->AsyncDeleteReport(cq, std::move(context),
                                         std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> MigrationCenterLogging::DeleteReport(
    grpc::ClientContext& context, Options options,
    google::cloud::migrationcenter::v1::DeleteReportRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::migrationcenter::v1::DeleteReportRequest const&
                 request) {
        return child_->DeleteReport(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
MigrationCenterLogging::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::longrunning::GetOperationRequest const& request) {
        return child_->AsyncGetOperation(cq, std::move(context),
                                         std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

future<Status> MigrationCenterLogging::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::longrunning::CancelOperationRequest const& request) {
        return child_->AsyncCancelOperation(cq, std::move(context),
                                            std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace migrationcenter_v1_internal
}  // namespace cloud
}  // namespace google
