// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/metastore/v1/metastore_federation.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_METASTORE_V1_DATAPROC_METASTORE_FEDERATION_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_METASTORE_V1_DATAPROC_METASTORE_FEDERATION_CLIENT_H

#include "google/cloud/metastore/v1/dataproc_metastore_federation_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace metastore_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Configures and manages metastore federation services.
/// Dataproc Metastore Federation Service allows federating a collection of
/// backend metastores like BigQuery, Dataplex Lakes, and other Dataproc
/// Metastores. The Federation Service exposes a gRPC URL through which metadata
/// from the backend metastores are served at query time.
///
/// The Dataproc Metastore Federation API defines the following resource model:
/// * The service works with a collection of Google Cloud projects.
/// * Each project has a collection of available locations.
/// * Each location has a collection of federations.
/// * Dataproc Metastore Federations are resources with names of the
/// form:
/// `projects/{project_number}/locations/{location_id}/federations/{federation_id}`.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class DataprocMetastoreFederationClient {
 public:
  explicit DataprocMetastoreFederationClient(
      std::shared_ptr<DataprocMetastoreFederationConnection> connection,
      Options opts = {});
  ~DataprocMetastoreFederationClient();

  ///@{
  /// @name Copy and move support
  DataprocMetastoreFederationClient(DataprocMetastoreFederationClient const&) =
      default;
  DataprocMetastoreFederationClient& operator=(
      DataprocMetastoreFederationClient const&) = default;
  DataprocMetastoreFederationClient(DataprocMetastoreFederationClient&&) =
      default;
  DataprocMetastoreFederationClient& operator=(
      DataprocMetastoreFederationClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(DataprocMetastoreFederationClient const& a,
                         DataprocMetastoreFederationClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(DataprocMetastoreFederationClient const& a,
                         DataprocMetastoreFederationClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists federations in a project and location.
  ///
  /// @param parent  Required. The relative resource name of the location of metastore
  ///  federations to list, in the following form:
  ///  `projects/{project_number}/locations/{location_id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.metastore.v1.Federation], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.Federation]: @googleapis_reference_link{google/cloud/metastore/v1/metastore_federation.proto#L112}
  /// [google.cloud.metastore.v1.ListFederationsRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore_federation.proto#L213}
  ///
  // clang-format on
  StreamRange<google::cloud::metastore::v1::Federation> ListFederations(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists federations in a project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.metastore.v1.ListFederationsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.metastore.v1.Federation], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.Federation]: @googleapis_reference_link{google/cloud/metastore/v1/metastore_federation.proto#L112}
  /// [google.cloud.metastore.v1.ListFederationsRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore_federation.proto#L213}
  ///
  // clang-format on
  StreamRange<google::cloud::metastore::v1::Federation> ListFederations(
      google::cloud::metastore::v1::ListFederationsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets the details of a single federation.
  ///
  /// @param name  Required. The relative resource name of the metastore federation to
  ///  retrieve, in the following form:
  ///  @n
  ///  `projects/{project_number}/locations/{location_id}/federations/{federation_id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.metastore.v1.Federation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.Federation]: @googleapis_reference_link{google/cloud/metastore/v1/metastore_federation.proto#L112}
  /// [google.cloud.metastore.v1.GetFederationRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore_federation.proto#L263}
  ///
  // clang-format on
  StatusOr<google::cloud::metastore::v1::Federation> GetFederation(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets the details of a single federation.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.metastore.v1.GetFederationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.metastore.v1.Federation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.Federation]: @googleapis_reference_link{google/cloud/metastore/v1/metastore_federation.proto#L112}
  /// [google.cloud.metastore.v1.GetFederationRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore_federation.proto#L263}
  ///
  // clang-format on
  StatusOr<google::cloud::metastore::v1::Federation> GetFederation(
      google::cloud::metastore::v1::GetFederationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a metastore federation in a project and location.
  ///
  /// @param parent  Required. The relative resource name of the location in which to create a
  ///  federation service, in the following form:
  ///  @n
  ///  `projects/{project_number}/locations/{location_id}`.
  /// @param federation  Required. The Metastore Federation to create. The `name` field is
  ///  ignored. The ID of the created metastore federation must be
  ///  provided in the request's `federation_id` field.
  /// @param federation_id  Required. The ID of the metastore federation, which is used as the final
  ///  component of the metastore federation's name.
  ///  @n
  ///  This value must be between 2 and 63 characters long inclusive, begin with a
  ///  letter, end with a letter or number, and consist of alpha-numeric
  ///  ASCII characters or hyphens.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.metastore.v1.Federation] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.CreateFederationRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore_federation.proto#L277}
  /// [google.cloud.metastore.v1.Federation]: @googleapis_reference_link{google/cloud/metastore/v1/metastore_federation.proto#L112}
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::Federation>> CreateFederation(
      std::string const& parent,
      google::cloud::metastore::v1::Federation const& federation,
      std::string const& federation_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateFederation
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateFederation(
      NoAwaitTag, std::string const& parent,
      google::cloud::metastore::v1::Federation const& federation,
      std::string const& federation_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a metastore federation in a project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.metastore.v1.CreateFederationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.metastore.v1.Federation] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.CreateFederationRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore_federation.proto#L277}
  /// [google.cloud.metastore.v1.Federation]: @googleapis_reference_link{google/cloud/metastore/v1/metastore_federation.proto#L112}
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::Federation>> CreateFederation(
      google::cloud::metastore::v1::CreateFederationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateFederation
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateFederation(
      NoAwaitTag,
      google::cloud::metastore::v1::CreateFederationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateFederation
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::Federation>> CreateFederation(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Updates the fields of a federation.
  ///
  /// @param federation  Required. The metastore federation to update. The server only merges fields
  ///  in the service if they are specified in `update_mask`.
  ///  @n
  ///  The metastore federation's `name` field is used to identify the
  ///  metastore service to be updated.
  /// @param update_mask  Required. A field mask used to specify the fields to be overwritten in the
  ///  metastore federation resource by the update.
  ///  Fields specified in the `update_mask` are relative to the resource (not
  ///  to the full request). A field is overwritten if it is in the mask.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.metastore.v1.Federation] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.Federation]: @googleapis_reference_link{google/cloud/metastore/v1/metastore_federation.proto#L112}
  /// [google.cloud.metastore.v1.UpdateFederationRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore_federation.proto#L318}
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::Federation>> UpdateFederation(
      google::cloud::metastore::v1::Federation const& federation,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateFederation
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateFederation(
      NoAwaitTag, google::cloud::metastore::v1::Federation const& federation,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the fields of a federation.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.metastore.v1.UpdateFederationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.metastore.v1.Federation] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.Federation]: @googleapis_reference_link{google/cloud/metastore/v1/metastore_federation.proto#L112}
  /// [google.cloud.metastore.v1.UpdateFederationRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore_federation.proto#L318}
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::Federation>> UpdateFederation(
      google::cloud::metastore::v1::UpdateFederationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateFederation
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateFederation(
      NoAwaitTag,
      google::cloud::metastore::v1::UpdateFederationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateFederation
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::Federation>> UpdateFederation(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single federation.
  ///
  /// @param name  Required. The relative resource name of the metastore federation to delete,
  ///  in the following form:
  ///  @n
  ///  `projects/{project_number}/locations/{location_id}/federations/{federation_id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.metastore.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.DeleteFederationRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore_federation.proto#L349}
  /// [google.cloud.metastore.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1457}
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::OperationMetadata>>
  DeleteFederation(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteFederation
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteFederation(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single federation.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.metastore.v1.DeleteFederationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.metastore.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.DeleteFederationRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore_federation.proto#L349}
  /// [google.cloud.metastore.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1457}
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::OperationMetadata>>
  DeleteFederation(
      google::cloud::metastore::v1::DeleteFederationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteFederation
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteFederation(
      NoAwaitTag,
      google::cloud::metastore::v1::DeleteFederationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteFederation
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::OperationMetadata>>
  DeleteFederation(google::longrunning::Operation const& operation,
                   Options opts = {});

 private:
  std::shared_ptr<DataprocMetastoreFederationConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace metastore_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_METASTORE_V1_DATAPROC_METASTORE_FEDERATION_CLIENT_H
