// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/ids/v1/ids.proto

#include "google/cloud/ids/v1/internal/ids_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace ids_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

IDSTracingStub::IDSTracingStub(std::shared_ptr<IDSStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::ids::v1::ListEndpointsResponse>
IDSTracingStub::ListEndpoints(
    grpc::ClientContext& context, Options const& options,
    google::cloud::ids::v1::ListEndpointsRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.ids.v1.IDS", "ListEndpoints");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListEndpoints(context, options, request));
}

StatusOr<google::cloud::ids::v1::Endpoint> IDSTracingStub::GetEndpoint(
    grpc::ClientContext& context, Options const& options,
    google::cloud::ids::v1::GetEndpointRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.ids.v1.IDS", "GetEndpoint");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetEndpoint(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
IDSTracingStub::AsyncCreateEndpoint(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::ids::v1::CreateEndpointRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.ids.v1.IDS", "CreateEndpoint");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateEndpoint(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> IDSTracingStub::CreateEndpoint(
    grpc::ClientContext& context, Options options,
    google::cloud::ids::v1::CreateEndpointRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.ids.v1.IDS", "CreateEndpoint");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateEndpoint(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
IDSTracingStub::AsyncDeleteEndpoint(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::ids::v1::DeleteEndpointRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.ids.v1.IDS", "DeleteEndpoint");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteEndpoint(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> IDSTracingStub::DeleteEndpoint(
    grpc::ClientContext& context, Options options,
    google::cloud::ids::v1::DeleteEndpointRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.ids.v1.IDS", "DeleteEndpoint");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteEndpoint(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
IDSTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> IDSTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCancelOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<IDSStub> MakeIDSTracingStub(std::shared_ptr<IDSStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<IDSTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace ids_v1_internal
}  // namespace cloud
}  // namespace google
