// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/iap/v1/service.proto

#include "google/cloud/iap/v1/internal/identity_aware_proxy_o_auth_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/iap/v1/service.grpc.pb.h>
#include <memory>
#include <set>
#include <string>
#include <utility>

namespace google {
namespace cloud {
namespace iap_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

IdentityAwareProxyOAuthServiceLogging::IdentityAwareProxyOAuthServiceLogging(
    std::shared_ptr<IdentityAwareProxyOAuthServiceStub> child,
    TracingOptions tracing_options, std::set<std::string> const&)
    : child_(std::move(child)), tracing_options_(std::move(tracing_options)) {}

StatusOr<google::cloud::iap::v1::ListBrandsResponse>
IdentityAwareProxyOAuthServiceLogging::ListBrands(
    grpc::ClientContext& context, Options const& options,
    google::cloud::iap::v1::ListBrandsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::iap::v1::ListBrandsRequest const& request) {
        return child_->ListBrands(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::iap::v1::Brand>
IdentityAwareProxyOAuthServiceLogging::CreateBrand(
    grpc::ClientContext& context, Options const& options,
    google::cloud::iap::v1::CreateBrandRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::iap::v1::CreateBrandRequest const& request) {
        return child_->CreateBrand(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::iap::v1::Brand>
IdentityAwareProxyOAuthServiceLogging::GetBrand(
    grpc::ClientContext& context, Options const& options,
    google::cloud::iap::v1::GetBrandRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::iap::v1::GetBrandRequest const& request) {
        return child_->GetBrand(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::iap::v1::IdentityAwareProxyClient>
IdentityAwareProxyOAuthServiceLogging::CreateIdentityAwareProxyClient(
    grpc::ClientContext& context, Options const& options,
    google::cloud::iap::v1::CreateIdentityAwareProxyClientRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::iap::v1::CreateIdentityAwareProxyClientRequest const&
              request) {
        return child_->CreateIdentityAwareProxyClient(context, options,
                                                      request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::iap::v1::ListIdentityAwareProxyClientsResponse>
IdentityAwareProxyOAuthServiceLogging::ListIdentityAwareProxyClients(
    grpc::ClientContext& context, Options const& options,
    google::cloud::iap::v1::ListIdentityAwareProxyClientsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::iap::v1::ListIdentityAwareProxyClientsRequest const&
                 request) {
        return child_->ListIdentityAwareProxyClients(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::iap::v1::IdentityAwareProxyClient>
IdentityAwareProxyOAuthServiceLogging::GetIdentityAwareProxyClient(
    grpc::ClientContext& context, Options const& options,
    google::cloud::iap::v1::GetIdentityAwareProxyClientRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::iap::v1::GetIdentityAwareProxyClientRequest const&
                 request) {
        return child_->GetIdentityAwareProxyClient(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::iap::v1::IdentityAwareProxyClient>
IdentityAwareProxyOAuthServiceLogging::ResetIdentityAwareProxyClientSecret(
    grpc::ClientContext& context, Options const& options,
    google::cloud::iap::v1::ResetIdentityAwareProxyClientSecretRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::iap::v1::
                 ResetIdentityAwareProxyClientSecretRequest const& request) {
        return child_->ResetIdentityAwareProxyClientSecret(context, options,
                                                           request);
      },
      context, options, request, __func__, tracing_options_);
}

Status IdentityAwareProxyOAuthServiceLogging::DeleteIdentityAwareProxyClient(
    grpc::ClientContext& context, Options const& options,
    google::cloud::iap::v1::DeleteIdentityAwareProxyClientRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::iap::v1::DeleteIdentityAwareProxyClientRequest const&
              request) {
        return child_->DeleteIdentityAwareProxyClient(context, options,
                                                      request);
      },
      context, options, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace iap_v1_internal
}  // namespace cloud
}  // namespace google
