// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/iap/v1/service.proto

#include "google/cloud/iap/v1/identity_aware_proxy_admin_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace iap_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

IdentityAwareProxyAdminServiceConnectionIdempotencyPolicy::
    ~IdentityAwareProxyAdminServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<IdentityAwareProxyAdminServiceConnectionIdempotencyPolicy>
IdentityAwareProxyAdminServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<
      IdentityAwareProxyAdminServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency
IdentityAwareProxyAdminServiceConnectionIdempotencyPolicy::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return request.policy().etag().empty() ? Idempotency::kNonIdempotent
                                         : Idempotency::kIdempotent;
}

Idempotency
IdentityAwareProxyAdminServiceConnectionIdempotencyPolicy::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
IdentityAwareProxyAdminServiceConnectionIdempotencyPolicy::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
IdentityAwareProxyAdminServiceConnectionIdempotencyPolicy::GetIapSettings(
    google::cloud::iap::v1::GetIapSettingsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
IdentityAwareProxyAdminServiceConnectionIdempotencyPolicy::UpdateIapSettings(
    google::cloud::iap::v1::UpdateIapSettingsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
IdentityAwareProxyAdminServiceConnectionIdempotencyPolicy::ListTunnelDestGroups(
    google::cloud::iap::v1::ListTunnelDestGroupsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency IdentityAwareProxyAdminServiceConnectionIdempotencyPolicy::
    CreateTunnelDestGroup(
        google::cloud::iap::v1::CreateTunnelDestGroupRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
IdentityAwareProxyAdminServiceConnectionIdempotencyPolicy::GetTunnelDestGroup(
    google::cloud::iap::v1::GetTunnelDestGroupRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency IdentityAwareProxyAdminServiceConnectionIdempotencyPolicy::
    DeleteTunnelDestGroup(
        google::cloud::iap::v1::DeleteTunnelDestGroupRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency IdentityAwareProxyAdminServiceConnectionIdempotencyPolicy::
    UpdateTunnelDestGroup(
        google::cloud::iap::v1::UpdateTunnelDestGroupRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<IdentityAwareProxyAdminServiceConnectionIdempotencyPolicy>
MakeDefaultIdentityAwareProxyAdminServiceConnectionIdempotencyPolicy() {
  return std::make_unique<
      IdentityAwareProxyAdminServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace iap_v1
}  // namespace cloud
}  // namespace google
