// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkemulticloud/v1/aws_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GKEMULTICLOUD_V1_AWS_CLUSTERS_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GKEMULTICLOUD_V1_AWS_CLUSTERS_CLIENT_H

#include "google/cloud/gkemulticloud/v1/aws_clusters_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace gkemulticloud_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// The AwsClusters API provides a single centrally managed service
/// to create and manage Anthos clusters that run on AWS infrastructure.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class AwsClustersClient {
 public:
  explicit AwsClustersClient(std::shared_ptr<AwsClustersConnection> connection,
                             Options opts = {});
  ~AwsClustersClient();

  ///@{
  /// @name Copy and move support
  AwsClustersClient(AwsClustersClient const&) = default;
  AwsClustersClient& operator=(AwsClustersClient const&) = default;
  AwsClustersClient(AwsClustersClient&&) = default;
  AwsClustersClient& operator=(AwsClustersClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(AwsClustersClient const& a,
                         AwsClustersClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(AwsClustersClient const& a,
                         AwsClustersClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Creates a new [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster]
  /// resource on a given Google Cloud Platform project and region.
  ///
  /// If successful, the response contains a newly created
  /// [Operation][google.longrunning.Operation] resource that can be
  /// described to track the status of the operation.
  ///
  /// @param parent  Required. The parent location where this
  ///  [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resource will be
  ///  created.
  ///  @n
  ///  Location names are formatted as `projects/<project-id>/locations/<region>`.
  ///  @n
  ///  See [Resource Names](https://cloud.google.com/apis/design/resource_names)
  ///  for more details on Google Cloud resource names.
  /// @param aws_cluster  Required. The specification of the
  ///  [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] to create.
  /// @param aws_cluster_id  Required. A client provided ID the resource. Must be unique within the
  ///  parent resource.
  ///  @n
  ///  The provided ID will be part of the
  ///  [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resource name
  ///  formatted as
  ///  `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>`.
  ///  @n
  ///  Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 63 characters.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkemulticloud.v1.AwsCluster] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AwsCluster]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L34}
  /// [google.cloud.gkemulticloud.v1.CreateAwsClusterRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_service.proto#L257}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::AwsCluster>>
  CreateAwsCluster(
      std::string const& parent,
      google::cloud::gkemulticloud::v1::AwsCluster const& aws_cluster,
      std::string const& aws_cluster_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateAwsCluster
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateAwsCluster(
      NoAwaitTag, std::string const& parent,
      google::cloud::gkemulticloud::v1::AwsCluster const& aws_cluster,
      std::string const& aws_cluster_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster]
  /// resource on a given Google Cloud Platform project and region.
  ///
  /// If successful, the response contains a newly created
  /// [Operation][google.longrunning.Operation] resource that can be
  /// described to track the status of the operation.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.CreateAwsClusterRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkemulticloud.v1.AwsCluster] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AwsCluster]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L34}
  /// [google.cloud.gkemulticloud.v1.CreateAwsClusterRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_service.proto#L257}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::AwsCluster>>
  CreateAwsCluster(
      google::cloud::gkemulticloud::v1::CreateAwsClusterRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateAwsCluster
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateAwsCluster(
      NoAwaitTag,
      google::cloud::gkemulticloud::v1::CreateAwsClusterRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateAwsCluster
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::AwsCluster>>
  CreateAwsCluster(google::longrunning::Operation const& operation,
                   Options opts = {});

  // clang-format off
  ///
  /// Updates an [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster].
  ///
  /// @param aws_cluster  Required. The [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster]
  ///  resource to update.
  /// @param update_mask  Required. Mask of fields to update. At least one path must be supplied in
  ///  this field.
  ///  @n
  ///  For more information, see [UpdateAwsClusterRequest][google.cloud.gkemulticloud.v1.UpdateAwsClusterRequest].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkemulticloud.v1.AwsCluster] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AwsCluster]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L34}
  /// [google.cloud.gkemulticloud.v1.UpdateAwsClusterRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_service.proto#L293}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::AwsCluster>>
  UpdateAwsCluster(
      google::cloud::gkemulticloud::v1::AwsCluster const& aws_cluster,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateAwsCluster
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateAwsCluster(
      NoAwaitTag,
      google::cloud::gkemulticloud::v1::AwsCluster const& aws_cluster,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates an [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.UpdateAwsClusterRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkemulticloud.v1.AwsCluster] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AwsCluster]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L34}
  /// [google.cloud.gkemulticloud.v1.UpdateAwsClusterRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_service.proto#L293}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::AwsCluster>>
  UpdateAwsCluster(
      google::cloud::gkemulticloud::v1::UpdateAwsClusterRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateAwsCluster
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateAwsCluster(
      NoAwaitTag,
      google::cloud::gkemulticloud::v1::UpdateAwsClusterRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateAwsCluster
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::AwsCluster>>
  UpdateAwsCluster(google::longrunning::Operation const& operation,
                   Options opts = {});

  // clang-format off
  ///
  /// Describes a specific [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster]
  /// resource.
  ///
  /// @param name  Required. The name of the
  ///  [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resource to
  ///  describe.
  ///  @n
  ///  `AwsCluster` names are formatted as
  ///  `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>`.
  ///  @n
  ///  See [Resource Names](https://cloud.google.com/apis/design/resource_names)
  ///  for more details on Google Cloud Platform resource names.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkemulticloud.v1.AwsCluster])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AwsCluster]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L34}
  /// [google.cloud.gkemulticloud.v1.GetAwsClusterRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_service.proto#L337}
  ///
  // clang-format on
  StatusOr<google::cloud::gkemulticloud::v1::AwsCluster> GetAwsCluster(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Describes a specific [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster]
  /// resource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.GetAwsClusterRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkemulticloud.v1.AwsCluster])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AwsCluster]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L34}
  /// [google.cloud.gkemulticloud.v1.GetAwsClusterRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_service.proto#L337}
  ///
  // clang-format on
  StatusOr<google::cloud::gkemulticloud::v1::AwsCluster> GetAwsCluster(
      google::cloud::gkemulticloud::v1::GetAwsClusterRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists all [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resources
  /// on a given Google Cloud project and region.
  ///
  /// @param parent  Required. The parent location which owns this collection of
  ///  [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resources.
  ///  @n
  ///  Location names are formatted as `projects/<project-id>/locations/<region>`.
  ///  @n
  ///  See [Resource Names](https://cloud.google.com/apis/design/resource_names)
  ///  for more details on Google Cloud Platform resource names.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.gkemulticloud.v1.AwsCluster], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AwsCluster]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L34}
  /// [google.cloud.gkemulticloud.v1.ListAwsClustersRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_service.proto#L356}
  ///
  // clang-format on
  StreamRange<google::cloud::gkemulticloud::v1::AwsCluster> ListAwsClusters(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists all [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resources
  /// on a given Google Cloud project and region.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.ListAwsClustersRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.gkemulticloud.v1.AwsCluster], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AwsCluster]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L34}
  /// [google.cloud.gkemulticloud.v1.ListAwsClustersRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_service.proto#L356}
  ///
  // clang-format on
  StreamRange<google::cloud::gkemulticloud::v1::AwsCluster> ListAwsClusters(
      google::cloud::gkemulticloud::v1::ListAwsClustersRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a specific [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster]
  /// resource.
  ///
  /// Fails if the cluster has one or more associated
  /// [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] resources.
  ///
  /// If successful, the response contains a newly created
  /// [Operation][google.longrunning.Operation] resource that can be
  /// described to track the status of the operation.
  ///
  /// @param name  Required. The resource name the
  ///  [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] to delete.
  ///  @n
  ///  `AwsCluster` names are formatted as
  ///  `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>`.
  ///  @n
  ///  See [Resource Names](https://cloud.google.com/apis/design/resource_names)
  ///  for more details on Google Cloud Platform resource names.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkemulticloud.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AwsCluster]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L34}
  /// [google.cloud.gkemulticloud.v1.AwsNodePool]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L376}
  /// [google.cloud.gkemulticloud.v1.DeleteAwsClusterRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_service.proto#L398}
  /// [google.cloud.gkemulticloud.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/common_resources.proto#L80}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
  DeleteAwsCluster(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteAwsCluster
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteAwsCluster(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a specific [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster]
  /// resource.
  ///
  /// Fails if the cluster has one or more associated
  /// [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] resources.
  ///
  /// If successful, the response contains a newly created
  /// [Operation][google.longrunning.Operation] resource that can be
  /// described to track the status of the operation.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.DeleteAwsClusterRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkemulticloud.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AwsCluster]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L34}
  /// [google.cloud.gkemulticloud.v1.AwsNodePool]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L376}
  /// [google.cloud.gkemulticloud.v1.DeleteAwsClusterRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_service.proto#L398}
  /// [google.cloud.gkemulticloud.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/common_resources.proto#L80}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
  DeleteAwsCluster(
      google::cloud::gkemulticloud::v1::DeleteAwsClusterRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteAwsCluster
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteAwsCluster(
      NoAwaitTag,
      google::cloud::gkemulticloud::v1::DeleteAwsClusterRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteAwsCluster
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
  DeleteAwsCluster(google::longrunning::Operation const& operation,
                   Options opts = {});

  // clang-format off
  ///
  /// Generates an access token for a cluster agent.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.GenerateAwsClusterAgentTokenRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkemulticloud.v1.GenerateAwsClusterAgentTokenResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.GenerateAwsClusterAgentTokenRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_service.proto#L733}
  /// [google.cloud.gkemulticloud.v1.GenerateAwsClusterAgentTokenResponse]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_service.proto#L770}
  ///
  // clang-format on
  StatusOr<
      google::cloud::gkemulticloud::v1::GenerateAwsClusterAgentTokenResponse>
  GenerateAwsClusterAgentToken(
      google::cloud::gkemulticloud::v1::
          GenerateAwsClusterAgentTokenRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Generates a short-lived access token to authenticate to a given
  /// [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.GenerateAwsAccessTokenRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkemulticloud.v1.GenerateAwsAccessTokenResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AwsCluster]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L34}
  /// [google.cloud.gkemulticloud.v1.GenerateAwsAccessTokenRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_service.proto#L705}
  /// [google.cloud.gkemulticloud.v1.GenerateAwsAccessTokenResponse]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_service.proto#L724}
  ///
  // clang-format on
  StatusOr<google::cloud::gkemulticloud::v1::GenerateAwsAccessTokenResponse>
  GenerateAwsAccessToken(
      google::cloud::gkemulticloud::v1::GenerateAwsAccessTokenRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool],
  /// attached to a given [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster].
  ///
  /// If successful, the response contains a newly created
  /// [Operation][google.longrunning.Operation] resource that can be
  /// described to track the status of the operation.
  ///
  /// @param parent  Required. The [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster]
  ///  resource where this node pool will be created.
  ///  @n
  ///  `AwsCluster` names are formatted as
  ///  `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>`.
  ///  @n
  ///  See [Resource Names](https://cloud.google.com/apis/design/resource_names)
  ///  for more details on Google Cloud resource names.
  /// @param aws_node_pool  Required. The specification of the
  ///  [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] to create.
  /// @param aws_node_pool_id  Required. A client provided ID the resource. Must be unique within the
  ///  parent resource.
  ///  @n
  ///  The provided ID will be part of the
  ///  [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] resource name
  ///  formatted as
  ///  `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>/awsNodePools/<node-pool-id>`.
  ///  @n
  ///  Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 63 characters.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkemulticloud.v1.AwsNodePool] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AwsCluster]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L34}
  /// [google.cloud.gkemulticloud.v1.AwsNodePool]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L376}
  /// [google.cloud.gkemulticloud.v1.CreateAwsNodePoolRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_service.proto#L442}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>>
  CreateAwsNodePool(
      std::string const& parent,
      google::cloud::gkemulticloud::v1::AwsNodePool const& aws_node_pool,
      std::string const& aws_node_pool_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateAwsNodePool
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateAwsNodePool(
      NoAwaitTag, std::string const& parent,
      google::cloud::gkemulticloud::v1::AwsNodePool const& aws_node_pool,
      std::string const& aws_node_pool_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool],
  /// attached to a given [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster].
  ///
  /// If successful, the response contains a newly created
  /// [Operation][google.longrunning.Operation] resource that can be
  /// described to track the status of the operation.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.CreateAwsNodePoolRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkemulticloud.v1.AwsNodePool] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AwsCluster]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L34}
  /// [google.cloud.gkemulticloud.v1.AwsNodePool]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L376}
  /// [google.cloud.gkemulticloud.v1.CreateAwsNodePoolRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_service.proto#L442}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>>
  CreateAwsNodePool(
      google::cloud::gkemulticloud::v1::CreateAwsNodePoolRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateAwsNodePool
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateAwsNodePool(
      NoAwaitTag,
      google::cloud::gkemulticloud::v1::CreateAwsNodePoolRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateAwsNodePool
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>>
  CreateAwsNodePool(google::longrunning::Operation const& operation,
                    Options opts = {});

  // clang-format off
  ///
  /// Updates an [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool].
  ///
  /// @param aws_node_pool  Required. The [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool]
  ///  resource to update.
  /// @param update_mask  Required. Mask of fields to update. At least one path must be supplied in
  ///  this field.
  ///  @n
  ///  For more information, see [UpdateAwsNodePoolRequest][google.cloud.gkemulticloud.v1.UpdateAwsNodePoolRequest].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkemulticloud.v1.AwsNodePool] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AwsNodePool]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L376}
  /// [google.cloud.gkemulticloud.v1.UpdateAwsNodePoolRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_service.proto#L479}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>>
  UpdateAwsNodePool(
      google::cloud::gkemulticloud::v1::AwsNodePool const& aws_node_pool,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateAwsNodePool
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateAwsNodePool(
      NoAwaitTag,
      google::cloud::gkemulticloud::v1::AwsNodePool const& aws_node_pool,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates an [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.UpdateAwsNodePoolRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkemulticloud.v1.AwsNodePool] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AwsNodePool]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L376}
  /// [google.cloud.gkemulticloud.v1.UpdateAwsNodePoolRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_service.proto#L479}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>>
  UpdateAwsNodePool(
      google::cloud::gkemulticloud::v1::UpdateAwsNodePoolRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateAwsNodePool
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateAwsNodePool(
      NoAwaitTag,
      google::cloud::gkemulticloud::v1::UpdateAwsNodePoolRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateAwsNodePool
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>>
  UpdateAwsNodePool(google::longrunning::Operation const& operation,
                    Options opts = {});

  // clang-format off
  ///
  /// Rolls back a previously aborted or failed
  /// [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] update request.
  /// Makes no changes if the last update request successfully finished.
  /// If an update request is in progress, you cannot rollback the update.
  /// You must first cancel or let it finish unsuccessfully before you can
  /// rollback.
  ///
  /// @param name  Required. The name of the
  ///  [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] resource to
  ///  rollback.
  ///  @n
  ///  `AwsNodePool` names are formatted as
  ///  `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>/awsNodePools/<node-pool-id>`.
  ///  @n
  ///  See [Resource Names](https://cloud.google.com/apis/design/resource_names)
  ///  for more details on Google Cloud resource names.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkemulticloud.v1.AwsNodePool] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AwsNodePool]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L376}
  /// [google.cloud.gkemulticloud.v1.RollbackAwsNodePoolUpdateRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_service.proto#L526}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>>
  RollbackAwsNodePoolUpdate(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief RollbackAwsNodePoolUpdate
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> RollbackAwsNodePoolUpdate(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Rolls back a previously aborted or failed
  /// [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] update request.
  /// Makes no changes if the last update request successfully finished.
  /// If an update request is in progress, you cannot rollback the update.
  /// You must first cancel or let it finish unsuccessfully before you can
  /// rollback.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.RollbackAwsNodePoolUpdateRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkemulticloud.v1.AwsNodePool] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AwsNodePool]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L376}
  /// [google.cloud.gkemulticloud.v1.RollbackAwsNodePoolUpdateRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_service.proto#L526}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>>
  RollbackAwsNodePoolUpdate(
      google::cloud::gkemulticloud::v1::RollbackAwsNodePoolUpdateRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RollbackAwsNodePoolUpdate
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> RollbackAwsNodePoolUpdate(
      NoAwaitTag,
      google::cloud::gkemulticloud::v1::RollbackAwsNodePoolUpdateRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RollbackAwsNodePoolUpdate
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>>
  RollbackAwsNodePoolUpdate(google::longrunning::Operation const& operation,
                            Options opts = {});

  // clang-format off
  ///
  /// Describes a specific
  /// [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] resource.
  ///
  /// @param name  Required. The name of the
  ///  [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] resource to
  ///  describe.
  ///  @n
  ///  `AwsNodePool` names are formatted as
  ///  `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>/awsNodePools/<node-pool-id>`.
  ///  @n
  ///  See [Resource Names](https://cloud.google.com/apis/design/resource_names)
  ///  for more details on Google Cloud resource names.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkemulticloud.v1.AwsNodePool])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AwsNodePool]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L376}
  /// [google.cloud.gkemulticloud.v1.GetAwsNodePoolRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_service.proto#L549}
  ///
  // clang-format on
  StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool> GetAwsNodePool(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Describes a specific
  /// [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] resource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.GetAwsNodePoolRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkemulticloud.v1.AwsNodePool])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AwsNodePool]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L376}
  /// [google.cloud.gkemulticloud.v1.GetAwsNodePoolRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_service.proto#L549}
  ///
  // clang-format on
  StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool> GetAwsNodePool(
      google::cloud::gkemulticloud::v1::GetAwsNodePoolRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists all [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool]
  /// resources on a given
  /// [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster].
  ///
  /// @param parent  Required. The parent `AwsCluster` which owns this collection of
  ///  [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] resources.
  ///  @n
  ///  `AwsCluster` names are formatted as
  ///  `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>`.
  ///  @n
  ///  See [Resource Names](https://cloud.google.com/apis/design/resource_names)
  ///  for more details on Google Cloud resource names.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.gkemulticloud.v1.AwsNodePool], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AwsCluster]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L34}
  /// [google.cloud.gkemulticloud.v1.AwsNodePool]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L376}
  /// [google.cloud.gkemulticloud.v1.ListAwsNodePoolsRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_service.proto#L568}
  ///
  // clang-format on
  StreamRange<google::cloud::gkemulticloud::v1::AwsNodePool> ListAwsNodePools(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists all [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool]
  /// resources on a given
  /// [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.ListAwsNodePoolsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.gkemulticloud.v1.AwsNodePool], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AwsCluster]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L34}
  /// [google.cloud.gkemulticloud.v1.AwsNodePool]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L376}
  /// [google.cloud.gkemulticloud.v1.ListAwsNodePoolsRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_service.proto#L568}
  ///
  // clang-format on
  StreamRange<google::cloud::gkemulticloud::v1::AwsNodePool> ListAwsNodePools(
      google::cloud::gkemulticloud::v1::ListAwsNodePoolsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a specific [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool]
  /// resource.
  ///
  /// If successful, the response contains a newly created
  /// [Operation][google.longrunning.Operation] resource that can be
  /// described to track the status of the operation.
  ///
  /// @param name  Required. The resource name the
  ///  [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] to delete.
  ///  @n
  ///  `AwsNodePool` names are formatted as
  ///  `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>/awsNodePools/<node-pool-id>`.
  ///  @n
  ///  See [Resource Names](https://cloud.google.com/apis/design/resource_names)
  ///  for more details on Google Cloud resource names.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkemulticloud.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AwsNodePool]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L376}
  /// [google.cloud.gkemulticloud.v1.DeleteAwsNodePoolRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_service.proto#L611}
  /// [google.cloud.gkemulticloud.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/common_resources.proto#L80}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
  DeleteAwsNodePool(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteAwsNodePool
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteAwsNodePool(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a specific [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool]
  /// resource.
  ///
  /// If successful, the response contains a newly created
  /// [Operation][google.longrunning.Operation] resource that can be
  /// described to track the status of the operation.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.DeleteAwsNodePoolRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkemulticloud.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AwsNodePool]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L376}
  /// [google.cloud.gkemulticloud.v1.DeleteAwsNodePoolRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_service.proto#L611}
  /// [google.cloud.gkemulticloud.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/common_resources.proto#L80}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
  DeleteAwsNodePool(
      google::cloud::gkemulticloud::v1::DeleteAwsNodePoolRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteAwsNodePool
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteAwsNodePool(
      NoAwaitTag,
      google::cloud::gkemulticloud::v1::DeleteAwsNodePoolRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteAwsNodePool
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
  DeleteAwsNodePool(google::longrunning::Operation const& operation,
                    Options opts = {});

  // clang-format off
  ///
  /// Gets the OIDC discovery document for the cluster.
  /// See the
  /// [OpenID Connect Discovery 1.0
  /// specification](https://openid.net/specs/openid-connect-discovery-1_0.html)
  /// for details.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.GetAwsOpenIdConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkemulticloud.v1.AwsOpenIdConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AwsOpenIdConfig]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L631}
  /// [google.cloud.gkemulticloud.v1.GetAwsOpenIdConfigRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_service.proto#L657}
  ///
  // clang-format on
  StatusOr<google::cloud::gkemulticloud::v1::AwsOpenIdConfig>
  GetAwsOpenIdConfig(
      google::cloud::gkemulticloud::v1::GetAwsOpenIdConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets the public component of the cluster signing keys in
  /// JSON Web Key format.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.GetAwsJsonWebKeysRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkemulticloud.v1.AwsJsonWebKeys])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AwsJsonWebKeys]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L655}
  /// [google.cloud.gkemulticloud.v1.GetAwsJsonWebKeysRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_service.proto#L673}
  ///
  // clang-format on
  StatusOr<google::cloud::gkemulticloud::v1::AwsJsonWebKeys> GetAwsJsonWebKeys(
      google::cloud::gkemulticloud::v1::GetAwsJsonWebKeysRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns information, such as supported AWS regions and Kubernetes
  /// versions, on a given Google Cloud location.
  ///
  /// @param name  Required. The name of the
  ///  [AwsServerConfig][google.cloud.gkemulticloud.v1.AwsServerConfig] resource
  ///  to describe.
  ///  @n
  ///  `AwsServerConfig` names are formatted as
  ///  `projects/<project-id>/locations/<region>/awsServerConfig`.
  ///  @n
  ///  See [Resource Names](https://cloud.google.com/apis/design/resource_names)
  ///  for more details on Google Cloud resource names.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkemulticloud.v1.AwsServerConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AwsServerConfig]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L662}
  /// [google.cloud.gkemulticloud.v1.GetAwsServerConfigRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_service.proto#L686}
  ///
  // clang-format on
  StatusOr<google::cloud::gkemulticloud::v1::AwsServerConfig>
  GetAwsServerConfig(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Returns information, such as supported AWS regions and Kubernetes
  /// versions, on a given Google Cloud location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.GetAwsServerConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkemulticloud.v1.AwsServerConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AwsServerConfig]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_resources.proto#L662}
  /// [google.cloud.gkemulticloud.v1.GetAwsServerConfigRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/aws_service.proto#L686}
  ///
  // clang-format on
  StatusOr<google::cloud::gkemulticloud::v1::AwsServerConfig>
  GetAwsServerConfig(
      google::cloud::gkemulticloud::v1::GetAwsServerConfigRequest const&
          request,
      Options opts = {});

 private:
  std::shared_ptr<AwsClustersConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkemulticloud_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GKEMULTICLOUD_V1_AWS_CLUSTERS_CLIENT_H
