// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkeconnect/gateway/v1/control.proto

#include "google/cloud/gkeconnect/gateway/v1/internal/gateway_control_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace gkeconnect_gateway_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

GatewayControlTracingConnection::GatewayControlTracingConnection(
    std::shared_ptr<gkeconnect_gateway_v1::GatewayControlConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::gkeconnect::gateway::v1::GenerateCredentialsResponse>
GatewayControlTracingConnection::GenerateCredentials(
    google::cloud::gkeconnect::gateway::v1::GenerateCredentialsRequest const&
        request) {
  auto span = internal::MakeSpan(
      "gkeconnect_gateway_v1::GatewayControlConnection::GenerateCredentials");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GenerateCredentials(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<gkeconnect_gateway_v1::GatewayControlConnection>
MakeGatewayControlTracingConnection(
    std::shared_ptr<gkeconnect_gateway_v1::GatewayControlConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<GatewayControlTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkeconnect_gateway_v1_internal
}  // namespace cloud
}  // namespace google
