// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkeconnect/gateway/v1/control.proto

#include "google/cloud/gkeconnect/gateway/v1/gateway_control_connection.h"
#include "google/cloud/gkeconnect/gateway/v1/gateway_control_options.h"
#include "google/cloud/gkeconnect/gateway/v1/internal/gateway_control_connection_impl.h"
#include "google/cloud/gkeconnect/gateway/v1/internal/gateway_control_option_defaults.h"
#include "google/cloud/gkeconnect/gateway/v1/internal/gateway_control_stub_factory.h"
#include "google/cloud/gkeconnect/gateway/v1/internal/gateway_control_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace gkeconnect_gateway_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

GatewayControlConnection::~GatewayControlConnection() = default;

StatusOr<google::cloud::gkeconnect::gateway::v1::GenerateCredentialsResponse>
GatewayControlConnection::GenerateCredentials(
    google::cloud::gkeconnect::gateway::v1::GenerateCredentialsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<GatewayControlConnection> MakeGatewayControlConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 GatewayControlPolicyOptionList>(options,
                                                                 __func__);
  options = gkeconnect_gateway_v1_internal::GatewayControlDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = gkeconnect_gateway_v1_internal::CreateDefaultGatewayControlStub(
      std::move(auth), options);
  return gkeconnect_gateway_v1_internal::MakeGatewayControlTracingConnection(
      std::make_shared<
          gkeconnect_gateway_v1_internal::GatewayControlConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkeconnect_gateway_v1
}  // namespace cloud
}  // namespace google
