// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/domains/v1/domains.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DOMAINS_V1_MOCKS_MOCK_DOMAINS_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DOMAINS_V1_MOCKS_MOCK_DOMAINS_CONNECTION_H

#include "google/cloud/domains/v1/domains_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace domains_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `DomainsConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `DomainsClient`. To do so,
 * construct an object of type `DomainsClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockDomainsConnection : public domains_v1::DomainsConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD(StatusOr<google::cloud::domains::v1::SearchDomainsResponse>,
              SearchDomains,
              (google::cloud::domains::v1::SearchDomainsRequest const& request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::domains::v1::RetrieveRegisterParametersResponse>,
      RetrieveRegisterParameters,
      (google::cloud::domains::v1::RetrieveRegisterParametersRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// RegisterDomain(Matcher<google::cloud::domains::v1::RegisterDomainRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::domains::v1::Registration>>,
      RegisterDomain,
      (google::cloud::domains::v1::RegisterDomainRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, RegisterDomain(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, RegisterDomain,
      (NoAwaitTag,
       google::cloud::domains::v1::RegisterDomainRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, RegisterDomain(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::domains::v1::Registration>>,
              RegisterDomain, (google::longrunning::Operation const& operation),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::domains::v1::RetrieveTransferParametersResponse>,
      RetrieveTransferParameters,
      (google::cloud::domains::v1::RetrieveTransferParametersRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// TransferDomain(Matcher<google::cloud::domains::v1::TransferDomainRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::domains::v1::Registration>>,
      TransferDomain,
      (google::cloud::domains::v1::TransferDomainRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, TransferDomain(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, TransferDomain,
      (NoAwaitTag,
       google::cloud::domains::v1::TransferDomainRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, TransferDomain(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::domains::v1::Registration>>,
              TransferDomain, (google::longrunning::Operation const& operation),
              (override));

  MOCK_METHOD((StreamRange<google::cloud::domains::v1::Registration>),
              ListRegistrations,
              (google::cloud::domains::v1::ListRegistrationsRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::domains::v1::Registration>, GetRegistration,
      (google::cloud::domains::v1::GetRegistrationRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateRegistration(Matcher<google::cloud::domains::v1::UpdateRegistrationRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::domains::v1::Registration>>,
      UpdateRegistration,
      (google::cloud::domains::v1::UpdateRegistrationRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateRegistration(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UpdateRegistration,
      (NoAwaitTag,
       google::cloud::domains::v1::UpdateRegistrationRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateRegistration(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::domains::v1::Registration>>,
              UpdateRegistration,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// ConfigureManagementSettings(Matcher<google::cloud::domains::v1::ConfigureManagementSettingsRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::domains::v1::Registration>>,
      ConfigureManagementSettings,
      (google::cloud::domains::v1::ConfigureManagementSettingsRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, ConfigureManagementSettings(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, ConfigureManagementSettings,
      (NoAwaitTag,
       google::cloud::domains::v1::ConfigureManagementSettingsRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// ConfigureManagementSettings(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::domains::v1::Registration>>,
              ConfigureManagementSettings,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// ConfigureDnsSettings(Matcher<google::cloud::domains::v1::ConfigureDnsSettingsRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::domains::v1::Registration>>,
      ConfigureDnsSettings,
      (google::cloud::domains::v1::ConfigureDnsSettingsRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, ConfigureDnsSettings(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, ConfigureDnsSettings,
      (NoAwaitTag,
       google::cloud::domains::v1::ConfigureDnsSettingsRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// ConfigureDnsSettings(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::domains::v1::Registration>>,
              ConfigureDnsSettings,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// ConfigureContactSettings(Matcher<google::cloud::domains::v1::ConfigureContactSettingsRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::domains::v1::Registration>>,
      ConfigureContactSettings,
      (google::cloud::domains::v1::ConfigureContactSettingsRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, ConfigureContactSettings(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, ConfigureContactSettings,
      (NoAwaitTag,
       google::cloud::domains::v1::ConfigureContactSettingsRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// ConfigureContactSettings(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::domains::v1::Registration>>,
              ConfigureContactSettings,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// ExportRegistration(Matcher<google::cloud::domains::v1::ExportRegistrationRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::domains::v1::Registration>>,
      ExportRegistration,
      (google::cloud::domains::v1::ExportRegistrationRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, ExportRegistration(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, ExportRegistration,
      (NoAwaitTag,
       google::cloud::domains::v1::ExportRegistrationRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// ExportRegistration(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::domains::v1::Registration>>,
              ExportRegistration,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteRegistration(Matcher<google::cloud::domains::v1::DeleteRegistrationRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::domains::v1::OperationMetadata>>,
      DeleteRegistration,
      (google::cloud::domains::v1::DeleteRegistrationRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteRegistration(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteRegistration,
      (NoAwaitTag,
       google::cloud::domains::v1::DeleteRegistrationRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteRegistration(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::domains::v1::OperationMetadata>>,
              DeleteRegistration,
              (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD(
      StatusOr<google::cloud::domains::v1::AuthorizationCode>,
      RetrieveAuthorizationCode,
      (google::cloud::domains::v1::RetrieveAuthorizationCodeRequest const&
           request),
      (override));

  MOCK_METHOD(StatusOr<google::cloud::domains::v1::AuthorizationCode>,
              ResetAuthorizationCode,
              (google::cloud::domains::v1::ResetAuthorizationCodeRequest const&
                   request),
              (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace domains_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DOMAINS_V1_MOCKS_MOCK_DOMAINS_CONNECTION_H
