// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/domains/v1/domains.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DOMAINS_V1_DOMAINS_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DOMAINS_V1_DOMAINS_CLIENT_H

#include "google/cloud/domains/v1/domains_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace domains_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// The Cloud Domains API enables management and configuration of domain names.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class DomainsClient {
 public:
  explicit DomainsClient(std::shared_ptr<DomainsConnection> connection,
                         Options opts = {});
  ~DomainsClient();

  ///@{
  /// @name Copy and move support
  DomainsClient(DomainsClient const&) = default;
  DomainsClient& operator=(DomainsClient const&) = default;
  DomainsClient(DomainsClient&&) = default;
  DomainsClient& operator=(DomainsClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(DomainsClient const& a, DomainsClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(DomainsClient const& a, DomainsClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Searches for available domain names similar to the provided query.
  ///
  /// Availability results from this method are approximate; call
  /// `RetrieveRegisterParameters` on a domain before registering to confirm
  /// availability.
  ///
  /// @param location  Required. The location. Must be in the format `projects/*/locations/*`.
  /// @param query  Required. String used to search for available domain names.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.domains.v1.SearchDomainsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.domains.v1.SearchDomainsRequest]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L668}
  /// [google.cloud.domains.v1.SearchDomainsResponse]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L682}
  ///
  // clang-format on
  StatusOr<google::cloud::domains::v1::SearchDomainsResponse> SearchDomains(
      std::string const& location, std::string const& query, Options opts = {});

  // clang-format off
  ///
  /// Searches for available domain names similar to the provided query.
  ///
  /// Availability results from this method are approximate; call
  /// `RetrieveRegisterParameters` on a domain before registering to confirm
  /// availability.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.domains.v1.SearchDomainsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.domains.v1.SearchDomainsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.domains.v1.SearchDomainsRequest]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L668}
  /// [google.cloud.domains.v1.SearchDomainsResponse]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L682}
  ///
  // clang-format on
  StatusOr<google::cloud::domains::v1::SearchDomainsResponse> SearchDomains(
      google::cloud::domains::v1::SearchDomainsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets parameters needed to register a new domain name, including price and
  /// up-to-date availability. Use the returned values to call `RegisterDomain`.
  ///
  /// @param location  Required. The location. Must be in the format `projects/*/locations/*`.
  /// @param domain_name  Required. The domain name. Unicode domain names must be expressed in Punycode format.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.domains.v1.RetrieveRegisterParametersResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.domains.v1.RetrieveRegisterParametersRequest]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L688}
  /// [google.cloud.domains.v1.RetrieveRegisterParametersResponse]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L702}
  ///
  // clang-format on
  StatusOr<google::cloud::domains::v1::RetrieveRegisterParametersResponse>
  RetrieveRegisterParameters(std::string const& location,
                             std::string const& domain_name, Options opts = {});

  // clang-format off
  ///
  /// Gets parameters needed to register a new domain name, including price and
  /// up-to-date availability. Use the returned values to call `RegisterDomain`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.domains.v1.RetrieveRegisterParametersRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.domains.v1.RetrieveRegisterParametersResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.domains.v1.RetrieveRegisterParametersRequest]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L688}
  /// [google.cloud.domains.v1.RetrieveRegisterParametersResponse]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L702}
  ///
  // clang-format on
  StatusOr<google::cloud::domains::v1::RetrieveRegisterParametersResponse>
  RetrieveRegisterParameters(
      google::cloud::domains::v1::RetrieveRegisterParametersRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Registers a new domain name and creates a corresponding `Registration`
  /// resource.
  ///
  /// Call `RetrieveRegisterParameters` first to check availability of the domain
  /// name and determine parameters like price that are needed to build a call to
  /// this method.
  ///
  /// A successful call creates a `Registration` resource in state
  /// `REGISTRATION_PENDING`, which resolves to `ACTIVE` within 1-2
  /// minutes, indicating that the domain was successfully registered. If the
  /// resource ends up in state `REGISTRATION_FAILED`, it indicates that the
  /// domain was not registered successfully, and you can safely delete the
  /// resource and retry registration.
  ///
  /// @param parent  Required. The parent resource of the `Registration`. Must be in the
  ///  format `projects/*/locations/*`.
  /// @param registration  Required. The complete `Registration` resource to be created.
  /// @param yearly_price  Required. Yearly price to register or renew the domain.
  ///  The value that should be put here can be obtained from
  ///  RetrieveRegisterParameters or SearchDomains calls.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.domains.v1.Registration] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.domains.v1.RegisterDomainRequest]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L708}
  /// [google.cloud.domains.v1.Registration]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L297}
  ///
  // clang-format on
  future<StatusOr<google::cloud::domains::v1::Registration>> RegisterDomain(
      std::string const& parent,
      google::cloud::domains::v1::Registration const& registration,
      google::type::Money const& yearly_price, Options opts = {});

  // clang-format off
  ///
  /// @copybrief RegisterDomain
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> RegisterDomain(
      NoAwaitTag, std::string const& parent,
      google::cloud::domains::v1::Registration const& registration,
      google::type::Money const& yearly_price, Options opts = {});

  // clang-format off
  ///
  /// Registers a new domain name and creates a corresponding `Registration`
  /// resource.
  ///
  /// Call `RetrieveRegisterParameters` first to check availability of the domain
  /// name and determine parameters like price that are needed to build a call to
  /// this method.
  ///
  /// A successful call creates a `Registration` resource in state
  /// `REGISTRATION_PENDING`, which resolves to `ACTIVE` within 1-2
  /// minutes, indicating that the domain was successfully registered. If the
  /// resource ends up in state `REGISTRATION_FAILED`, it indicates that the
  /// domain was not registered successfully, and you can safely delete the
  /// resource and retry registration.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.domains.v1.RegisterDomainRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.domains.v1.Registration] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.domains.v1.RegisterDomainRequest]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L708}
  /// [google.cloud.domains.v1.Registration]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L297}
  ///
  // clang-format on
  future<StatusOr<google::cloud::domains::v1::Registration>> RegisterDomain(
      google::cloud::domains::v1::RegisterDomainRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RegisterDomain
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> RegisterDomain(
      NoAwaitTag,
      google::cloud::domains::v1::RegisterDomainRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RegisterDomain
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::domains::v1::Registration>> RegisterDomain(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Gets parameters needed to transfer a domain name from another registrar to
  /// Cloud Domains. For domains managed by Google Domains, transferring to Cloud
  /// Domains is not supported.
  ///
  ///
  /// Use the returned values to call `TransferDomain`.
  ///
  /// @param location  Required. The location. Must be in the format `projects/*/locations/*`.
  /// @param domain_name  Required. The domain name. Unicode domain names must be expressed in Punycode format.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.domains.v1.RetrieveTransferParametersResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.domains.v1.RetrieveTransferParametersRequest]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L742}
  /// [google.cloud.domains.v1.RetrieveTransferParametersResponse]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L756}
  ///
  // clang-format on
  StatusOr<google::cloud::domains::v1::RetrieveTransferParametersResponse>
  RetrieveTransferParameters(std::string const& location,
                             std::string const& domain_name, Options opts = {});

  // clang-format off
  ///
  /// Gets parameters needed to transfer a domain name from another registrar to
  /// Cloud Domains. For domains managed by Google Domains, transferring to Cloud
  /// Domains is not supported.
  ///
  ///
  /// Use the returned values to call `TransferDomain`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.domains.v1.RetrieveTransferParametersRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.domains.v1.RetrieveTransferParametersResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.domains.v1.RetrieveTransferParametersRequest]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L742}
  /// [google.cloud.domains.v1.RetrieveTransferParametersResponse]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L756}
  ///
  // clang-format on
  StatusOr<google::cloud::domains::v1::RetrieveTransferParametersResponse>
  RetrieveTransferParameters(
      google::cloud::domains::v1::RetrieveTransferParametersRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Transfers a domain name from another registrar to Cloud Domains.  For
  /// domains managed by Google Domains, transferring to Cloud Domains is not
  /// supported.
  ///
  ///
  /// Before calling this method, go to the domain's current registrar to unlock
  /// the domain for transfer and retrieve the domain's transfer authorization
  /// code. Then call `RetrieveTransferParameters` to confirm that the domain is
  /// unlocked and to get values needed to build a call to this method.
  ///
  /// A successful call creates a `Registration` resource in state
  /// `TRANSFER_PENDING`. It can take several days to complete the transfer
  /// process. The registrant can often speed up this process by approving the
  /// transfer through the current registrar, either by clicking a link in an
  /// email from the registrar or by visiting the registrar's website.
  ///
  /// A few minutes after transfer approval, the resource transitions to state
  /// `ACTIVE`, indicating that the transfer was successful. If the transfer is
  /// rejected or the request expires without being approved, the resource can
  /// end up in state `TRANSFER_FAILED`. If transfer fails, you can safely delete
  /// the resource and retry the transfer.
  ///
  /// @param parent  Required. The parent resource of the `Registration`. Must be in the
  ///  format `projects/*/locations/*`.
  /// @param registration  Required. The complete `Registration` resource to be created.
  ///  @n
  ///  You can leave `registration.dns_settings` unset to import the
  ///  domain's current DNS configuration from its current registrar. Use this
  ///  option only if you are sure that the domain's current DNS service
  ///  does not cease upon transfer, as is often the case for DNS services
  ///  provided for free by the registrar.
  /// @param yearly_price  Required. Acknowledgement of the price to transfer or renew the domain for one year.
  ///  Call `RetrieveTransferParameters` to obtain the price, which you must
  ///  acknowledge.
  /// @param authorization_code  The domain's transfer authorization code. You can obtain this from the
  ///  domain's current registrar.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.domains.v1.Registration] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.domains.v1.Registration]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L297}
  /// [google.cloud.domains.v1.TransferDomainRequest]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L762}
  ///
  // clang-format on
  future<StatusOr<google::cloud::domains::v1::Registration>> TransferDomain(
      std::string const& parent,
      google::cloud::domains::v1::Registration const& registration,
      google::type::Money const& yearly_price,
      google::cloud::domains::v1::AuthorizationCode const& authorization_code,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief TransferDomain
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> TransferDomain(
      NoAwaitTag, std::string const& parent,
      google::cloud::domains::v1::Registration const& registration,
      google::type::Money const& yearly_price,
      google::cloud::domains::v1::AuthorizationCode const& authorization_code,
      Options opts = {});

  // clang-format off
  ///
  /// Transfers a domain name from another registrar to Cloud Domains.  For
  /// domains managed by Google Domains, transferring to Cloud Domains is not
  /// supported.
  ///
  ///
  /// Before calling this method, go to the domain's current registrar to unlock
  /// the domain for transfer and retrieve the domain's transfer authorization
  /// code. Then call `RetrieveTransferParameters` to confirm that the domain is
  /// unlocked and to get values needed to build a call to this method.
  ///
  /// A successful call creates a `Registration` resource in state
  /// `TRANSFER_PENDING`. It can take several days to complete the transfer
  /// process. The registrant can often speed up this process by approving the
  /// transfer through the current registrar, either by clicking a link in an
  /// email from the registrar or by visiting the registrar's website.
  ///
  /// A few minutes after transfer approval, the resource transitions to state
  /// `ACTIVE`, indicating that the transfer was successful. If the transfer is
  /// rejected or the request expires without being approved, the resource can
  /// end up in state `TRANSFER_FAILED`. If transfer fails, you can safely delete
  /// the resource and retry the transfer.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.domains.v1.TransferDomainRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.domains.v1.Registration] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.domains.v1.Registration]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L297}
  /// [google.cloud.domains.v1.TransferDomainRequest]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L762}
  ///
  // clang-format on
  future<StatusOr<google::cloud::domains::v1::Registration>> TransferDomain(
      google::cloud::domains::v1::TransferDomainRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief TransferDomain
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> TransferDomain(
      NoAwaitTag,
      google::cloud::domains::v1::TransferDomainRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief TransferDomain
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::domains::v1::Registration>> TransferDomain(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Lists the `Registration` resources in a project.
  ///
  /// @param parent  Required. The project and location from which to list `Registration`s, specified in
  ///  the format `projects/*/locations/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.domains.v1.Registration], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.domains.v1.ListRegistrationsRequest]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L800}
  /// [google.cloud.domains.v1.Registration]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L297}
  ///
  // clang-format on
  StreamRange<google::cloud::domains::v1::Registration> ListRegistrations(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists the `Registration` resources in a project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.domains.v1.ListRegistrationsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.domains.v1.Registration], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.domains.v1.ListRegistrationsRequest]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L800}
  /// [google.cloud.domains.v1.Registration]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L297}
  ///
  // clang-format on
  StreamRange<google::cloud::domains::v1::Registration> ListRegistrations(
      google::cloud::domains::v1::ListRegistrationsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets the details of a `Registration` resource.
  ///
  /// @param name  Required. The name of the `Registration` to get, in the format
  ///  `projects/*/locations/*/registrations/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.domains.v1.Registration])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.domains.v1.GetRegistrationRequest]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L847}
  /// [google.cloud.domains.v1.Registration]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L297}
  ///
  // clang-format on
  StatusOr<google::cloud::domains::v1::Registration> GetRegistration(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets the details of a `Registration` resource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.domains.v1.GetRegistrationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.domains.v1.Registration])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.domains.v1.GetRegistrationRequest]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L847}
  /// [google.cloud.domains.v1.Registration]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L297}
  ///
  // clang-format on
  StatusOr<google::cloud::domains::v1::Registration> GetRegistration(
      google::cloud::domains::v1::GetRegistrationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates select fields of a `Registration` resource, notably `labels`. To
  /// update other fields, use the appropriate custom update method:
  ///
  /// * To update management settings, see `ConfigureManagementSettings`
  /// * To update DNS configuration, see `ConfigureDnsSettings`
  /// * To update contact information, see `ConfigureContactSettings`
  ///
  /// @param registration  Fields of the `Registration` to update.
  /// @param update_mask  Required. The field mask describing which fields to update as a comma-separated list.
  ///  For example, if only the labels are being updated, the `update_mask` is
  ///  `"labels"`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.domains.v1.Registration] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.domains.v1.Registration]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L297}
  /// [google.cloud.domains.v1.UpdateRegistrationRequest]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L859}
  ///
  // clang-format on
  future<StatusOr<google::cloud::domains::v1::Registration>> UpdateRegistration(
      google::cloud::domains::v1::Registration const& registration,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateRegistration
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateRegistration(
      NoAwaitTag, google::cloud::domains::v1::Registration const& registration,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates select fields of a `Registration` resource, notably `labels`. To
  /// update other fields, use the appropriate custom update method:
  ///
  /// * To update management settings, see `ConfigureManagementSettings`
  /// * To update DNS configuration, see `ConfigureDnsSettings`
  /// * To update contact information, see `ConfigureContactSettings`
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.domains.v1.UpdateRegistrationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.domains.v1.Registration] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.domains.v1.Registration]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L297}
  /// [google.cloud.domains.v1.UpdateRegistrationRequest]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L859}
  ///
  // clang-format on
  future<StatusOr<google::cloud::domains::v1::Registration>> UpdateRegistration(
      google::cloud::domains::v1::UpdateRegistrationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateRegistration
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateRegistration(
      NoAwaitTag,
      google::cloud::domains::v1::UpdateRegistrationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateRegistration
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::domains::v1::Registration>> UpdateRegistration(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Updates a `Registration`'s management settings.
  ///
  /// @param registration  Required. The name of the `Registration` whose management settings are being updated,
  ///  in the format `projects/*/locations/*/registrations/*`.
  /// @param management_settings  Fields of the `ManagementSettings` to update.
  /// @param update_mask  Required. The field mask describing which fields to update as a comma-separated list.
  ///  For example, if only the transfer lock is being updated, the `update_mask`
  ///  is `"transfer_lock_state"`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.domains.v1.Registration] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.domains.v1.ConfigureManagementSettingsRequest]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L870}
  /// [google.cloud.domains.v1.Registration]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L297}
  ///
  // clang-format on
  future<StatusOr<google::cloud::domains::v1::Registration>>
  ConfigureManagementSettings(
      std::string const& registration,
      google::cloud::domains::v1::ManagementSettings const& management_settings,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief ConfigureManagementSettings
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ConfigureManagementSettings(
      NoAwaitTag, std::string const& registration,
      google::cloud::domains::v1::ManagementSettings const& management_settings,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a `Registration`'s management settings.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.domains.v1.ConfigureManagementSettingsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.domains.v1.Registration] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.domains.v1.ConfigureManagementSettingsRequest]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L870}
  /// [google.cloud.domains.v1.Registration]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L297}
  ///
  // clang-format on
  future<StatusOr<google::cloud::domains::v1::Registration>>
  ConfigureManagementSettings(
      google::cloud::domains::v1::ConfigureManagementSettingsRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ConfigureManagementSettings
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ConfigureManagementSettings(
      NoAwaitTag,
      google::cloud::domains::v1::ConfigureManagementSettingsRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ConfigureManagementSettings
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::domains::v1::Registration>>
  ConfigureManagementSettings(google::longrunning::Operation const& operation,
                              Options opts = {});

  // clang-format off
  ///
  /// Updates a `Registration`'s DNS settings.
  ///
  /// @param registration  Required. The name of the `Registration` whose DNS settings are being updated,
  ///  in the format `projects/*/locations/*/registrations/*`.
  /// @param dns_settings  Fields of the `DnsSettings` to update.
  /// @param update_mask  Required. The field mask describing which fields to update as a comma-separated list.
  ///  For example, if only the name servers are being updated for an existing
  ///  Custom DNS configuration, the `update_mask` is
  ///  `"custom_dns.name_servers"`.
  ///  @n
  ///  When changing the DNS provider from one type to another, pass the new
  ///  provider's field name as part of the field mask. For example, when changing
  ///  from a Google Domains DNS configuration to a Custom DNS configuration, the
  ///  `update_mask` is `"custom_dns"`. //
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.domains.v1.Registration] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.domains.v1.ConfigureDnsSettingsRequest]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L890}
  /// [google.cloud.domains.v1.Registration]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L297}
  ///
  // clang-format on
  future<StatusOr<google::cloud::domains::v1::Registration>>
  ConfigureDnsSettings(
      std::string const& registration,
      google::cloud::domains::v1::DnsSettings const& dns_settings,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief ConfigureDnsSettings
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ConfigureDnsSettings(
      NoAwaitTag, std::string const& registration,
      google::cloud::domains::v1::DnsSettings const& dns_settings,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a `Registration`'s DNS settings.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.domains.v1.ConfigureDnsSettingsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.domains.v1.Registration] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.domains.v1.ConfigureDnsSettingsRequest]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L890}
  /// [google.cloud.domains.v1.Registration]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L297}
  ///
  // clang-format on
  future<StatusOr<google::cloud::domains::v1::Registration>>
  ConfigureDnsSettings(
      google::cloud::domains::v1::ConfigureDnsSettingsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ConfigureDnsSettings
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ConfigureDnsSettings(
      NoAwaitTag,
      google::cloud::domains::v1::ConfigureDnsSettingsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ConfigureDnsSettings
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::domains::v1::Registration>>
  ConfigureDnsSettings(google::longrunning::Operation const& operation,
                       Options opts = {});

  // clang-format off
  ///
  /// Updates a `Registration`'s contact settings. Some changes require
  /// confirmation by the domain's registrant contact .
  ///
  /// @param registration  Required. The name of the `Registration` whose contact settings are being updated,
  ///  in the format `projects/*/locations/*/registrations/*`.
  /// @param contact_settings  Fields of the `ContactSettings` to update.
  /// @param update_mask  Required. The field mask describing which fields to update as a comma-separated list.
  ///  For example, if only the registrant contact is being updated, the
  ///  `update_mask` is `"registrant_contact"`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.domains.v1.Registration] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.domains.v1.ConfigureContactSettingsRequest]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L919}
  /// [google.cloud.domains.v1.Registration]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L297}
  ///
  // clang-format on
  future<StatusOr<google::cloud::domains::v1::Registration>>
  ConfigureContactSettings(
      std::string const& registration,
      google::cloud::domains::v1::ContactSettings const& contact_settings,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief ConfigureContactSettings
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ConfigureContactSettings(
      NoAwaitTag, std::string const& registration,
      google::cloud::domains::v1::ContactSettings const& contact_settings,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a `Registration`'s contact settings. Some changes require
  /// confirmation by the domain's registrant contact .
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.domains.v1.ConfigureContactSettingsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.domains.v1.Registration] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.domains.v1.ConfigureContactSettingsRequest]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L919}
  /// [google.cloud.domains.v1.Registration]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L297}
  ///
  // clang-format on
  future<StatusOr<google::cloud::domains::v1::Registration>>
  ConfigureContactSettings(
      google::cloud::domains::v1::ConfigureContactSettingsRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ConfigureContactSettings
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ConfigureContactSettings(
      NoAwaitTag,
      google::cloud::domains::v1::ConfigureContactSettingsRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ConfigureContactSettings
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::domains::v1::Registration>>
  ConfigureContactSettings(google::longrunning::Operation const& operation,
                           Options opts = {});

  // clang-format off
  ///
  /// Exports a `Registration` resource, such that it is no longer managed by
  /// Cloud Domains.
  ///
  /// When an active domain is successfully exported, you can continue to use the
  /// domain in [Google Domains](https://domains.google/) until it expires. The
  /// calling user becomes the domain's sole owner in Google Domains, and
  /// permissions for the domain are subsequently managed there. The domain does
  /// not renew automatically unless the new owner sets up billing in Google
  /// Domains.
  ///
  /// @param name  Required. The name of the `Registration` to export,
  ///  in the format `projects/*/locations/*/registrations/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.domains.v1.Registration] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.domains.v1.ExportRegistrationRequest]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L946}
  /// [google.cloud.domains.v1.Registration]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L297}
  ///
  // clang-format on
  future<StatusOr<google::cloud::domains::v1::Registration>> ExportRegistration(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief ExportRegistration
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ExportRegistration(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Exports a `Registration` resource, such that it is no longer managed by
  /// Cloud Domains.
  ///
  /// When an active domain is successfully exported, you can continue to use the
  /// domain in [Google Domains](https://domains.google/) until it expires. The
  /// calling user becomes the domain's sole owner in Google Domains, and
  /// permissions for the domain are subsequently managed there. The domain does
  /// not renew automatically unless the new owner sets up billing in Google
  /// Domains.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.domains.v1.ExportRegistrationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.domains.v1.Registration] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.domains.v1.ExportRegistrationRequest]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L946}
  /// [google.cloud.domains.v1.Registration]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L297}
  ///
  // clang-format on
  future<StatusOr<google::cloud::domains::v1::Registration>> ExportRegistration(
      google::cloud::domains::v1::ExportRegistrationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ExportRegistration
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ExportRegistration(
      NoAwaitTag,
      google::cloud::domains::v1::ExportRegistrationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ExportRegistration
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::domains::v1::Registration>> ExportRegistration(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Deletes a `Registration` resource.
  ///
  /// This method works on any `Registration` resource using [Subscription or
  /// Commitment billing](/domains/pricing#billing-models), provided that the
  /// resource was created at least 1 day in the past.
  ///
  /// For `Registration` resources using
  /// [Monthly billing](/domains/pricing#billing-models), this method works if:
  ///
  /// * `state` is `EXPORTED` with `expire_time` in the past
  /// * `state` is `REGISTRATION_FAILED`
  /// * `state` is `TRANSFER_FAILED`
  ///
  /// When an active registration is successfully deleted, you can continue to
  /// use the domain in [Google Domains](https://domains.google/) until it
  /// expires. The calling user becomes the domain's sole owner in Google
  /// Domains, and permissions for the domain are subsequently managed there. The
  /// domain does not renew automatically unless the new owner sets up billing in
  /// Google Domains.
  ///
  /// @param name  Required. The name of the `Registration` to delete,
  ///  in the format `projects/*/locations/*/registrations/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.domains.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.domains.v1.DeleteRegistrationRequest]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L958}
  /// [google.cloud.domains.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L1065}
  ///
  // clang-format on
  future<StatusOr<google::cloud::domains::v1::OperationMetadata>>
  DeleteRegistration(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteRegistration
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteRegistration(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a `Registration` resource.
  ///
  /// This method works on any `Registration` resource using [Subscription or
  /// Commitment billing](/domains/pricing#billing-models), provided that the
  /// resource was created at least 1 day in the past.
  ///
  /// For `Registration` resources using
  /// [Monthly billing](/domains/pricing#billing-models), this method works if:
  ///
  /// * `state` is `EXPORTED` with `expire_time` in the past
  /// * `state` is `REGISTRATION_FAILED`
  /// * `state` is `TRANSFER_FAILED`
  ///
  /// When an active registration is successfully deleted, you can continue to
  /// use the domain in [Google Domains](https://domains.google/) until it
  /// expires. The calling user becomes the domain's sole owner in Google
  /// Domains, and permissions for the domain are subsequently managed there. The
  /// domain does not renew automatically unless the new owner sets up billing in
  /// Google Domains.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.domains.v1.DeleteRegistrationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.domains.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.domains.v1.DeleteRegistrationRequest]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L958}
  /// [google.cloud.domains.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L1065}
  ///
  // clang-format on
  future<StatusOr<google::cloud::domains::v1::OperationMetadata>>
  DeleteRegistration(
      google::cloud::domains::v1::DeleteRegistrationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteRegistration
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteRegistration(
      NoAwaitTag,
      google::cloud::domains::v1::DeleteRegistrationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteRegistration
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::domains::v1::OperationMetadata>>
  DeleteRegistration(google::longrunning::Operation const& operation,
                     Options opts = {});

  // clang-format off
  ///
  /// Gets the authorization code of the `Registration` for the purpose of
  /// transferring the domain to another registrar.
  ///
  /// You can call this method only after 60 days have elapsed since the initial
  /// domain registration.
  ///
  /// @param registration  Required. The name of the `Registration` whose authorization code is being retrieved,
  ///  in the format `projects/*/locations/*/registrations/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.domains.v1.AuthorizationCode])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.domains.v1.AuthorizationCode]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L1058}
  /// [google.cloud.domains.v1.RetrieveAuthorizationCodeRequest]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L970}
  ///
  // clang-format on
  StatusOr<google::cloud::domains::v1::AuthorizationCode>
  RetrieveAuthorizationCode(std::string const& registration, Options opts = {});

  // clang-format off
  ///
  /// Gets the authorization code of the `Registration` for the purpose of
  /// transferring the domain to another registrar.
  ///
  /// You can call this method only after 60 days have elapsed since the initial
  /// domain registration.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.domains.v1.RetrieveAuthorizationCodeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.domains.v1.AuthorizationCode])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.domains.v1.AuthorizationCode]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L1058}
  /// [google.cloud.domains.v1.RetrieveAuthorizationCodeRequest]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L970}
  ///
  // clang-format on
  StatusOr<google::cloud::domains::v1::AuthorizationCode>
  RetrieveAuthorizationCode(
      google::cloud::domains::v1::RetrieveAuthorizationCodeRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Resets the authorization code of the `Registration` to a new random string.
  ///
  /// You can call this method only after 60 days have elapsed since the initial
  /// domain registration.
  ///
  /// @param registration  Required. The name of the `Registration` whose authorization code is being reset,
  ///  in the format `projects/*/locations/*/registrations/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.domains.v1.AuthorizationCode])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.domains.v1.AuthorizationCode]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L1058}
  /// [google.cloud.domains.v1.ResetAuthorizationCodeRequest]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L982}
  ///
  // clang-format on
  StatusOr<google::cloud::domains::v1::AuthorizationCode>
  ResetAuthorizationCode(std::string const& registration, Options opts = {});

  // clang-format off
  ///
  /// Resets the authorization code of the `Registration` to a new random string.
  ///
  /// You can call this method only after 60 days have elapsed since the initial
  /// domain registration.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.domains.v1.ResetAuthorizationCodeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.domains.v1.AuthorizationCode])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.domains.v1.AuthorizationCode]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L1058}
  /// [google.cloud.domains.v1.ResetAuthorizationCodeRequest]: @googleapis_reference_link{google/cloud/domains/v1/domains.proto#L982}
  ///
  // clang-format on
  StatusOr<google::cloud::domains::v1::AuthorizationCode>
  ResetAuthorizationCode(
      google::cloud::domains::v1::ResetAuthorizationCodeRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<DomainsConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace domains_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DOMAINS_V1_DOMAINS_CLIENT_H
