// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/schema_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_INTERNAL_SCHEMA_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_INTERNAL_SCHEMA_CONNECTION_IMPL_H

#include "google/cloud/discoveryengine/v1/internal/schema_retry_traits.h"
#include "google/cloud/discoveryengine/v1/internal/schema_stub.h"
#include "google/cloud/discoveryengine/v1/schema_connection.h"
#include "google/cloud/discoveryengine/v1/schema_connection_idempotency_policy.h"
#include "google/cloud/discoveryengine/v1/schema_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace discoveryengine_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class SchemaServiceConnectionImpl
    : public discoveryengine_v1::SchemaServiceConnection {
 public:
  ~SchemaServiceConnectionImpl() override = default;

  SchemaServiceConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<discoveryengine_v1_internal::SchemaServiceStub> stub,
      Options options);

  Options options() override { return options_; }

  StatusOr<google::cloud::discoveryengine::v1::Schema> GetSchema(
      google::cloud::discoveryengine::v1::GetSchemaRequest const& request)
      override;

  StreamRange<google::cloud::discoveryengine::v1::Schema> ListSchemas(
      google::cloud::discoveryengine::v1::ListSchemasRequest request) override;

  future<StatusOr<google::cloud::discoveryengine::v1::Schema>> CreateSchema(
      google::cloud::discoveryengine::v1::CreateSchemaRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateSchema(
      NoAwaitTag,
      google::cloud::discoveryengine::v1::CreateSchemaRequest const& request)
      override;

  future<StatusOr<google::cloud::discoveryengine::v1::Schema>> CreateSchema(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::discoveryengine::v1::Schema>> UpdateSchema(
      google::cloud::discoveryengine::v1::UpdateSchemaRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateSchema(
      NoAwaitTag,
      google::cloud::discoveryengine::v1::UpdateSchemaRequest const& request)
      override;

  future<StatusOr<google::cloud::discoveryengine::v1::Schema>> UpdateSchema(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::discoveryengine::v1::DeleteSchemaMetadata>>
  DeleteSchema(google::cloud::discoveryengine::v1::DeleteSchemaRequest const&
                   request) override;

  StatusOr<google::longrunning::Operation> DeleteSchema(
      NoAwaitTag,
      google::cloud::discoveryengine::v1::DeleteSchemaRequest const& request)
      override;

  future<StatusOr<google::cloud::discoveryengine::v1::DeleteSchemaMetadata>>
  DeleteSchema(google::longrunning::Operation const& operation) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<discoveryengine_v1_internal::SchemaServiceStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_INTERNAL_SCHEMA_CONNECTION_IMPL_H
