// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/intent.proto

#include "google/cloud/dialogflow_es/internal/intents_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dialogflow_es_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

IntentsTracingConnection::IntentsTracingConnection(
    std::shared_ptr<dialogflow_es::IntentsConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::dialogflow::v2::Intent>
IntentsTracingConnection::ListIntents(
    google::cloud::dialogflow::v2::ListIntentsRequest request) {
  auto span =
      internal::MakeSpan("dialogflow_es::IntentsConnection::ListIntents");
  internal::OTelScope scope(span);
  auto sr = child_->ListIntents(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::dialogflow::v2::Intent>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::dialogflow::v2::Intent>
IntentsTracingConnection::GetIntent(
    google::cloud::dialogflow::v2::GetIntentRequest const& request) {
  auto span = internal::MakeSpan("dialogflow_es::IntentsConnection::GetIntent");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIntent(request));
}

StatusOr<google::cloud::dialogflow::v2::Intent>
IntentsTracingConnection::CreateIntent(
    google::cloud::dialogflow::v2::CreateIntentRequest const& request) {
  auto span =
      internal::MakeSpan("dialogflow_es::IntentsConnection::CreateIntent");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateIntent(request));
}

StatusOr<google::cloud::dialogflow::v2::Intent>
IntentsTracingConnection::UpdateIntent(
    google::cloud::dialogflow::v2::UpdateIntentRequest const& request) {
  auto span =
      internal::MakeSpan("dialogflow_es::IntentsConnection::UpdateIntent");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateIntent(request));
}

Status IntentsTracingConnection::DeleteIntent(
    google::cloud::dialogflow::v2::DeleteIntentRequest const& request) {
  auto span =
      internal::MakeSpan("dialogflow_es::IntentsConnection::DeleteIntent");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteIntent(request));
}

future<StatusOr<google::cloud::dialogflow::v2::BatchUpdateIntentsResponse>>
IntentsTracingConnection::BatchUpdateIntents(
    google::cloud::dialogflow::v2::BatchUpdateIntentsRequest const& request) {
  auto span = internal::MakeSpan(
      "dialogflow_es::IntentsConnection::BatchUpdateIntents");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->BatchUpdateIntents(request));
}

StatusOr<google::longrunning::Operation>
IntentsTracingConnection::BatchUpdateIntents(
    NoAwaitTag,
    google::cloud::dialogflow::v2::BatchUpdateIntentsRequest const& request) {
  auto span = internal::MakeSpan(
      "dialogflow_es::IntentsConnection::BatchUpdateIntents");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->BatchUpdateIntents(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::dialogflow::v2::BatchUpdateIntentsResponse>>
IntentsTracingConnection::BatchUpdateIntents(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "dialogflow_es::IntentsConnection::BatchUpdateIntents");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->BatchUpdateIntents(operation));
}

future<StatusOr<google::protobuf::Struct>>
IntentsTracingConnection::BatchDeleteIntents(
    google::cloud::dialogflow::v2::BatchDeleteIntentsRequest const& request) {
  auto span = internal::MakeSpan(
      "dialogflow_es::IntentsConnection::BatchDeleteIntents");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->BatchDeleteIntents(request));
}

StatusOr<google::longrunning::Operation>
IntentsTracingConnection::BatchDeleteIntents(
    NoAwaitTag,
    google::cloud::dialogflow::v2::BatchDeleteIntentsRequest const& request) {
  auto span = internal::MakeSpan(
      "dialogflow_es::IntentsConnection::BatchDeleteIntents");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->BatchDeleteIntents(NoAwaitTag{}, request));
}

future<StatusOr<google::protobuf::Struct>>
IntentsTracingConnection::BatchDeleteIntents(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "dialogflow_es::IntentsConnection::BatchDeleteIntents");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->BatchDeleteIntents(operation));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<dialogflow_es::IntentsConnection> MakeIntentsTracingConnection(
    std::shared_ptr<dialogflow_es::IntentsConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<IntentsTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es_internal
}  // namespace cloud
}  // namespace google
