// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/conversation_profile.proto

#include "google/cloud/dialogflow_es/internal/conversation_profiles_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dialogflow_es_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

ConversationProfilesTracingConnection::ConversationProfilesTracingConnection(
    std::shared_ptr<dialogflow_es::ConversationProfilesConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::dialogflow::v2::ConversationProfile>
ConversationProfilesTracingConnection::ListConversationProfiles(
    google::cloud::dialogflow::v2::ListConversationProfilesRequest request) {
  auto span = internal::MakeSpan(
      "dialogflow_es::ConversationProfilesConnection::"
      "ListConversationProfiles");
  internal::OTelScope scope(span);
  auto sr = child_->ListConversationProfiles(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::dialogflow::v2::ConversationProfile>(std::move(span),
                                                          std::move(sr));
}

StatusOr<google::cloud::dialogflow::v2::ConversationProfile>
ConversationProfilesTracingConnection::GetConversationProfile(
    google::cloud::dialogflow::v2::GetConversationProfileRequest const&
        request) {
  auto span = internal::MakeSpan(
      "dialogflow_es::ConversationProfilesConnection::GetConversationProfile");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetConversationProfile(request));
}

StatusOr<google::cloud::dialogflow::v2::ConversationProfile>
ConversationProfilesTracingConnection::CreateConversationProfile(
    google::cloud::dialogflow::v2::CreateConversationProfileRequest const&
        request) {
  auto span = internal::MakeSpan(
      "dialogflow_es::ConversationProfilesConnection::"
      "CreateConversationProfile");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateConversationProfile(request));
}

StatusOr<google::cloud::dialogflow::v2::ConversationProfile>
ConversationProfilesTracingConnection::UpdateConversationProfile(
    google::cloud::dialogflow::v2::UpdateConversationProfileRequest const&
        request) {
  auto span = internal::MakeSpan(
      "dialogflow_es::ConversationProfilesConnection::"
      "UpdateConversationProfile");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateConversationProfile(request));
}

Status ConversationProfilesTracingConnection::DeleteConversationProfile(
    google::cloud::dialogflow::v2::DeleteConversationProfileRequest const&
        request) {
  auto span = internal::MakeSpan(
      "dialogflow_es::ConversationProfilesConnection::"
      "DeleteConversationProfile");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteConversationProfile(request));
}

future<StatusOr<google::cloud::dialogflow::v2::ConversationProfile>>
ConversationProfilesTracingConnection::SetSuggestionFeatureConfig(
    google::cloud::dialogflow::v2::SetSuggestionFeatureConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "dialogflow_es::ConversationProfilesConnection::"
      "SetSuggestionFeatureConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->SetSuggestionFeatureConfig(request));
}

StatusOr<google::longrunning::Operation>
ConversationProfilesTracingConnection::SetSuggestionFeatureConfig(
    NoAwaitTag,
    google::cloud::dialogflow::v2::SetSuggestionFeatureConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "dialogflow_es::ConversationProfilesConnection::"
      "SetSuggestionFeatureConfig");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->SetSuggestionFeatureConfig(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::dialogflow::v2::ConversationProfile>>
ConversationProfilesTracingConnection::SetSuggestionFeatureConfig(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "dialogflow_es::ConversationProfilesConnection::"
      "SetSuggestionFeatureConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->SetSuggestionFeatureConfig(operation));
}

future<StatusOr<google::cloud::dialogflow::v2::ConversationProfile>>
ConversationProfilesTracingConnection::ClearSuggestionFeatureConfig(
    google::cloud::dialogflow::v2::ClearSuggestionFeatureConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "dialogflow_es::ConversationProfilesConnection::"
      "ClearSuggestionFeatureConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->ClearSuggestionFeatureConfig(request));
}

StatusOr<google::longrunning::Operation>
ConversationProfilesTracingConnection::ClearSuggestionFeatureConfig(
    NoAwaitTag,
    google::cloud::dialogflow::v2::ClearSuggestionFeatureConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "dialogflow_es::ConversationProfilesConnection::"
      "ClearSuggestionFeatureConfig");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->ClearSuggestionFeatureConfig(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::dialogflow::v2::ConversationProfile>>
ConversationProfilesTracingConnection::ClearSuggestionFeatureConfig(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "dialogflow_es::ConversationProfilesConnection::"
      "ClearSuggestionFeatureConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->ClearSuggestionFeatureConfig(operation));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<dialogflow_es::ConversationProfilesConnection>
MakeConversationProfilesTracingConnection(
    std::shared_ptr<dialogflow_es::ConversationProfilesConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<ConversationProfilesTracingConnection>(
        std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es_internal
}  // namespace cloud
}  // namespace google
