// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/conversation_dataset.proto

#include "google/cloud/dialogflow_es/conversation_datasets_connection.h"
#include "google/cloud/dialogflow_es/conversation_datasets_options.h"
#include "google/cloud/dialogflow_es/internal/conversation_datasets_connection_impl.h"
#include "google/cloud/dialogflow_es/internal/conversation_datasets_option_defaults.h"
#include "google/cloud/dialogflow_es/internal/conversation_datasets_stub_factory.h"
#include "google/cloud/dialogflow_es/internal/conversation_datasets_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dialogflow_es {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ConversationDatasetsConnection::~ConversationDatasetsConnection() = default;

future<StatusOr<google::cloud::dialogflow::v2::ConversationDataset>>
ConversationDatasetsConnection::CreateConversationDataset(
    google::cloud::dialogflow::v2::CreateConversationDatasetRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dialogflow::v2::ConversationDataset>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
ConversationDatasetsConnection::CreateConversationDataset(
    NoAwaitTag,
    google::cloud::dialogflow::v2::CreateConversationDatasetRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dialogflow::v2::ConversationDataset>>
ConversationDatasetsConnection::CreateConversationDataset(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dialogflow::v2::ConversationDataset>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::dialogflow::v2::ConversationDataset>
ConversationDatasetsConnection::GetConversationDataset(
    google::cloud::dialogflow::v2::GetConversationDatasetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::dialogflow::v2::ConversationDataset>
ConversationDatasetsConnection::ListConversationDatasets(
    google::cloud::dialogflow::v2::
        ListConversationDatasetsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::dialogflow::v2::ConversationDataset>>();
}

future<StatusOr<
    google::cloud::dialogflow::v2::DeleteConversationDatasetOperationMetadata>>
ConversationDatasetsConnection::DeleteConversationDataset(
    google::cloud::dialogflow::v2::DeleteConversationDatasetRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dialogflow::v2::
                   DeleteConversationDatasetOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
ConversationDatasetsConnection::DeleteConversationDataset(
    NoAwaitTag,
    google::cloud::dialogflow::v2::DeleteConversationDatasetRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<
    google::cloud::dialogflow::v2::DeleteConversationDatasetOperationMetadata>>
ConversationDatasetsConnection::DeleteConversationDataset(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dialogflow::v2::
                   DeleteConversationDatasetOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<
    google::cloud::dialogflow::v2::ImportConversationDataOperationResponse>>
ConversationDatasetsConnection::ImportConversationData(
    google::cloud::dialogflow::v2::ImportConversationDataRequest const&) {
  return google::cloud::make_ready_future<StatusOr<
      google::cloud::dialogflow::v2::ImportConversationDataOperationResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
ConversationDatasetsConnection::ImportConversationData(
    NoAwaitTag,
    google::cloud::dialogflow::v2::ImportConversationDataRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<
    google::cloud::dialogflow::v2::ImportConversationDataOperationResponse>>
ConversationDatasetsConnection::ImportConversationData(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<StatusOr<
      google::cloud::dialogflow::v2::ImportConversationDataOperationResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<ConversationDatasetsConnection>
MakeConversationDatasetsConnection(std::string const& location,
                                   Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 ConversationDatasetsPolicyOptionList>(
      options, __func__);
  options = dialogflow_es_internal::ConversationDatasetsDefaultOptions(
      location, std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = dialogflow_es_internal::CreateDefaultConversationDatasetsStub(
      std::move(auth), options);
  return dialogflow_es_internal::MakeConversationDatasetsTracingConnection(
      std::make_shared<
          dialogflow_es_internal::ConversationDatasetsConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

std::shared_ptr<ConversationDatasetsConnection>
MakeConversationDatasetsConnection(Options options) {
  return MakeConversationDatasetsConnection(std::string{}, std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es
}  // namespace cloud
}  // namespace google
