// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/test_case.proto

#include "google/cloud/dialogflow_cx/internal/test_cases_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/dialogflow/cx/v3/test_case.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace dialogflow_cx_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TestCasesMetadata::TestCasesMetadata(
    std::shared_ptr<TestCasesStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::cloud::dialogflow::cx::v3::ListTestCasesResponse>
TestCasesMetadata::ListTestCases(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::ListTestCasesRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListTestCases(context, options, request);
}

Status TestCasesMetadata::BatchDeleteTestCases(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::BatchDeleteTestCasesRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->BatchDeleteTestCases(context, options, request);
}

StatusOr<google::cloud::dialogflow::cx::v3::TestCase>
TestCasesMetadata::GetTestCase(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::GetTestCaseRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetTestCase(context, options, request);
}

StatusOr<google::cloud::dialogflow::cx::v3::TestCase>
TestCasesMetadata::CreateTestCase(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::CreateTestCaseRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateTestCase(context, options, request);
}

StatusOr<google::cloud::dialogflow::cx::v3::TestCase>
TestCasesMetadata::UpdateTestCase(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::UpdateTestCaseRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("test_case.name=",
                           internal::UrlEncode(request.test_case().name())));
  return child_->UpdateTestCase(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
TestCasesMetadata::AsyncRunTestCase(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::dialogflow::cx::v3::RunTestCaseRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncRunTestCase(cq, std::move(context), std::move(options),
                                  request);
}

StatusOr<google::longrunning::Operation> TestCasesMetadata::RunTestCase(
    grpc::ClientContext& context, Options options,
    google::cloud::dialogflow::cx::v3::RunTestCaseRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->RunTestCase(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
TestCasesMetadata::AsyncBatchRunTestCases(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::dialogflow::cx::v3::BatchRunTestCasesRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncBatchRunTestCases(cq, std::move(context),
                                        std::move(options), request);
}

StatusOr<google::longrunning::Operation> TestCasesMetadata::BatchRunTestCases(
    grpc::ClientContext& context, Options options,
    google::cloud::dialogflow::cx::v3::BatchRunTestCasesRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->BatchRunTestCases(context, options, request);
}

StatusOr<google::cloud::dialogflow::cx::v3::CalculateCoverageResponse>
TestCasesMetadata::CalculateCoverage(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::CalculateCoverageRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("agent=", internal::UrlEncode(request.agent())));
  return child_->CalculateCoverage(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
TestCasesMetadata::AsyncImportTestCases(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::dialogflow::cx::v3::ImportTestCasesRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncImportTestCases(cq, std::move(context),
                                      std::move(options), request);
}

StatusOr<google::longrunning::Operation> TestCasesMetadata::ImportTestCases(
    grpc::ClientContext& context, Options options,
    google::cloud::dialogflow::cx::v3::ImportTestCasesRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ImportTestCases(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
TestCasesMetadata::AsyncExportTestCases(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::dialogflow::cx::v3::ExportTestCasesRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncExportTestCases(cq, std::move(context),
                                      std::move(options), request);
}

StatusOr<google::longrunning::Operation> TestCasesMetadata::ExportTestCases(
    grpc::ClientContext& context, Options options,
    google::cloud::dialogflow::cx::v3::ExportTestCasesRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ExportTestCases(context, options, request);
}

StatusOr<google::cloud::dialogflow::cx::v3::ListTestCaseResultsResponse>
TestCasesMetadata::ListTestCaseResults(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::ListTestCaseResultsRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListTestCaseResults(context, options, request);
}

StatusOr<google::cloud::dialogflow::cx::v3::TestCaseResult>
TestCasesMetadata::GetTestCaseResult(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::GetTestCaseResultRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetTestCaseResult(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
TestCasesMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncGetOperation(cq, std::move(context), std::move(options),
                                   request);
}

future<Status> TestCasesMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncCancelOperation(cq, std::move(context),
                                      std::move(options), request);
}

void TestCasesMetadata::SetMetadata(grpc::ClientContext& context,
                                    Options const& options,
                                    std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void TestCasesMetadata::SetMetadata(grpc::ClientContext& context,
                                    Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx_internal
}  // namespace cloud
}  // namespace google
