// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/environment.proto

#include "google/cloud/dialogflow_cx/internal/environments_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dialogflow_cx_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

EnvironmentsTracingStub::EnvironmentsTracingStub(
    std::shared_ptr<EnvironmentsStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::dialogflow::cx::v3::ListEnvironmentsResponse>
EnvironmentsTracingStub::ListEnvironments(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::ListEnvironmentsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.dialogflow.cx.v3.Environments", "ListEnvironments");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListEnvironments(context, options, request));
}

StatusOr<google::cloud::dialogflow::cx::v3::Environment>
EnvironmentsTracingStub::GetEnvironment(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::GetEnvironmentRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.dialogflow.cx.v3.Environments", "GetEnvironment");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetEnvironment(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
EnvironmentsTracingStub::AsyncCreateEnvironment(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::dialogflow::cx::v3::CreateEnvironmentRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.dialogflow.cx.v3.Environments", "CreateEnvironment");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateEnvironment(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
EnvironmentsTracingStub::CreateEnvironment(
    grpc::ClientContext& context, Options options,
    google::cloud::dialogflow::cx::v3::CreateEnvironmentRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.dialogflow.cx.v3.Environments", "CreateEnvironment");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->CreateEnvironment(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
EnvironmentsTracingStub::AsyncUpdateEnvironment(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::dialogflow::cx::v3::UpdateEnvironmentRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.dialogflow.cx.v3.Environments", "UpdateEnvironment");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUpdateEnvironment(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
EnvironmentsTracingStub::UpdateEnvironment(
    grpc::ClientContext& context, Options options,
    google::cloud::dialogflow::cx::v3::UpdateEnvironmentRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.dialogflow.cx.v3.Environments", "UpdateEnvironment");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->UpdateEnvironment(context, options, request));
}

Status EnvironmentsTracingStub::DeleteEnvironment(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::DeleteEnvironmentRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.dialogflow.cx.v3.Environments", "DeleteEnvironment");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->DeleteEnvironment(context, options, request));
}

StatusOr<google::cloud::dialogflow::cx::v3::LookupEnvironmentHistoryResponse>
EnvironmentsTracingStub::LookupEnvironmentHistory(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::LookupEnvironmentHistoryRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.dialogflow.cx.v3.Environments", "LookupEnvironmentHistory");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->LookupEnvironmentHistory(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
EnvironmentsTracingStub::AsyncRunContinuousTest(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::dialogflow::cx::v3::RunContinuousTestRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.dialogflow.cx.v3.Environments", "RunContinuousTest");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncRunContinuousTest(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
EnvironmentsTracingStub::RunContinuousTest(
    grpc::ClientContext& context, Options options,
    google::cloud::dialogflow::cx::v3::RunContinuousTestRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.dialogflow.cx.v3.Environments", "RunContinuousTest");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->RunContinuousTest(context, options, request));
}

StatusOr<google::cloud::dialogflow::cx::v3::ListContinuousTestResultsResponse>
EnvironmentsTracingStub::ListContinuousTestResults(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::ListContinuousTestResultsRequest const&
        request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.dialogflow.cx.v3.Environments",
                             "ListContinuousTestResults");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->ListContinuousTestResults(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
EnvironmentsTracingStub::AsyncDeployFlow(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::dialogflow::cx::v3::DeployFlowRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.dialogflow.cx.v3.Environments", "DeployFlow");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeployFlow(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> EnvironmentsTracingStub::DeployFlow(
    grpc::ClientContext& context, Options options,
    google::cloud::dialogflow::cx::v3::DeployFlowRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.dialogflow.cx.v3.Environments", "DeployFlow");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeployFlow(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
EnvironmentsTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> EnvironmentsTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCancelOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<EnvironmentsStub> MakeEnvironmentsTracingStub(
    std::shared_ptr<EnvironmentsStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<EnvironmentsTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx_internal
}  // namespace cloud
}  // namespace google
