// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/deployment.proto

#include "google/cloud/dialogflow_cx/internal/deployments_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/dialogflow/cx/v3/deployment.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dialogflow_cx_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DeploymentsStub::~DeploymentsStub() = default;

StatusOr<google::cloud::dialogflow::cx::v3::ListDeploymentsResponse>
DefaultDeploymentsStub::ListDeployments(
    grpc::ClientContext& context, Options const&,
    google::cloud::dialogflow::cx::v3::ListDeploymentsRequest const& request) {
  google::cloud::dialogflow::cx::v3::ListDeploymentsResponse response;
  auto status = grpc_stub_->ListDeployments(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::dialogflow::cx::v3::Deployment>
DefaultDeploymentsStub::GetDeployment(
    grpc::ClientContext& context, Options const&,
    google::cloud::dialogflow::cx::v3::GetDeploymentRequest const& request) {
  google::cloud::dialogflow::cx::v3::Deployment response;
  auto status = grpc_stub_->GetDeployment(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx_internal
}  // namespace cloud
}  // namespace google
