// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/entity_type.proto

#include "google/cloud/dialogflow_cx/entity_types_connection.h"
#include "google/cloud/dialogflow_cx/entity_types_options.h"
#include "google/cloud/dialogflow_cx/internal/entity_types_connection_impl.h"
#include "google/cloud/dialogflow_cx/internal/entity_types_option_defaults.h"
#include "google/cloud/dialogflow_cx/internal/entity_types_stub_factory.h"
#include "google/cloud/dialogflow_cx/internal/entity_types_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dialogflow_cx {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

EntityTypesConnection::~EntityTypesConnection() = default;

StatusOr<google::cloud::dialogflow::cx::v3::EntityType>
EntityTypesConnection::GetEntityType(
    google::cloud::dialogflow::cx::v3::GetEntityTypeRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::dialogflow::cx::v3::EntityType>
EntityTypesConnection::CreateEntityType(
    google::cloud::dialogflow::cx::v3::CreateEntityTypeRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::dialogflow::cx::v3::EntityType>
EntityTypesConnection::UpdateEntityType(
    google::cloud::dialogflow::cx::v3::UpdateEntityTypeRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status EntityTypesConnection::DeleteEntityType(
    google::cloud::dialogflow::cx::v3::DeleteEntityTypeRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::dialogflow::cx::v3::EntityType>
EntityTypesConnection::ListEntityTypes(
    google::cloud::dialogflow::cx::v3::
        ListEntityTypesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::dialogflow::cx::v3::EntityType>>();
}

future<StatusOr<google::cloud::dialogflow::cx::v3::ExportEntityTypesResponse>>
EntityTypesConnection::ExportEntityTypes(
    google::cloud::dialogflow::cx::v3::ExportEntityTypesRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dialogflow::cx::v3::ExportEntityTypesResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
EntityTypesConnection::ExportEntityTypes(
    NoAwaitTag,
    google::cloud::dialogflow::cx::v3::ExportEntityTypesRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dialogflow::cx::v3::ExportEntityTypesResponse>>
EntityTypesConnection::ExportEntityTypes(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dialogflow::cx::v3::ExportEntityTypesResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dialogflow::cx::v3::ImportEntityTypesResponse>>
EntityTypesConnection::ImportEntityTypes(
    google::cloud::dialogflow::cx::v3::ImportEntityTypesRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dialogflow::cx::v3::ImportEntityTypesResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
EntityTypesConnection::ImportEntityTypes(
    NoAwaitTag,
    google::cloud::dialogflow::cx::v3::ImportEntityTypesRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dialogflow::cx::v3::ImportEntityTypesResponse>>
EntityTypesConnection::ImportEntityTypes(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dialogflow::cx::v3::ImportEntityTypesResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<EntityTypesConnection> MakeEntityTypesConnection(
    std::string const& location, Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 EntityTypesPolicyOptionList>(options,
                                                              __func__);
  options = dialogflow_cx_internal::EntityTypesDefaultOptions(
      location, std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = dialogflow_cx_internal::CreateDefaultEntityTypesStub(
      std::move(auth), options);
  return dialogflow_cx_internal::MakeEntityTypesTracingConnection(
      std::make_shared<dialogflow_cx_internal::EntityTypesConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

std::shared_ptr<EntityTypesConnection> MakeEntityTypesConnection(
    Options options) {
  return MakeEntityTypesConnection(std::string{}, std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx
}  // namespace cloud
}  // namespace google
