// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/developerconnect/v1/developer_connect.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DEVELOPERCONNECT_V1_DEVELOPER_CONNECT_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DEVELOPERCONNECT_V1_DEVELOPER_CONNECT_CLIENT_H

#include "google/cloud/developerconnect/v1/developer_connect_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace developerconnect_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Service describing handlers for resources
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class DeveloperConnectClient {
 public:
  explicit DeveloperConnectClient(
      std::shared_ptr<DeveloperConnectConnection> connection,
      Options opts = {});
  ~DeveloperConnectClient();

  ///@{
  /// @name Copy and move support
  DeveloperConnectClient(DeveloperConnectClient const&) = default;
  DeveloperConnectClient& operator=(DeveloperConnectClient const&) = default;
  DeveloperConnectClient(DeveloperConnectClient&&) = default;
  DeveloperConnectClient& operator=(DeveloperConnectClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(DeveloperConnectClient const& a,
                         DeveloperConnectClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(DeveloperConnectClient const& a,
                         DeveloperConnectClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists Connections in a given project and location.
  ///
  /// @param parent  Required. Parent value for ListConnectionsRequest
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.developerconnect.v1.Connection], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.developerconnect.v1.Connection]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L207}
  /// [google.cloud.developerconnect.v1.ListConnectionsRequest]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L358}
  ///
  // clang-format on
  StreamRange<google::cloud::developerconnect::v1::Connection> ListConnections(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists Connections in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.developerconnect.v1.ListConnectionsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.developerconnect.v1.Connection], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.developerconnect.v1.Connection]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L207}
  /// [google.cloud.developerconnect.v1.ListConnectionsRequest]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L358}
  ///
  // clang-format on
  StreamRange<google::cloud::developerconnect::v1::Connection> ListConnections(
      google::cloud::developerconnect::v1::ListConnectionsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single Connection.
  ///
  /// @param name  Required. Name of the resource
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.developerconnect.v1.Connection])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.developerconnect.v1.Connection]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L207}
  /// [google.cloud.developerconnect.v1.GetConnectionRequest]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L394}
  ///
  // clang-format on
  StatusOr<google::cloud::developerconnect::v1::Connection> GetConnection(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single Connection.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.developerconnect.v1.GetConnectionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.developerconnect.v1.Connection])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.developerconnect.v1.Connection]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L207}
  /// [google.cloud.developerconnect.v1.GetConnectionRequest]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L394}
  ///
  // clang-format on
  StatusOr<google::cloud::developerconnect::v1::Connection> GetConnection(
      google::cloud::developerconnect::v1::GetConnectionRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new Connection in a given project and location.
  ///
  /// @param parent  Required. Value for parent.
  /// @param connection  Required. The resource being created
  /// @param connection_id  Required. Id of the requesting object
  ///  If auto-generating Id server-side, remove this field and
  ///  connection_id from the method_signature of Create RPC
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.developerconnect.v1.Connection] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.developerconnect.v1.Connection]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L207}
  /// [google.cloud.developerconnect.v1.CreateConnectionRequest]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L405}
  ///
  // clang-format on
  future<StatusOr<google::cloud::developerconnect::v1::Connection>>
  CreateConnection(
      std::string const& parent,
      google::cloud::developerconnect::v1::Connection const& connection,
      std::string const& connection_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateConnection
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateConnection(
      NoAwaitTag, std::string const& parent,
      google::cloud::developerconnect::v1::Connection const& connection,
      std::string const& connection_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new Connection in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.developerconnect.v1.CreateConnectionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.developerconnect.v1.Connection] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.developerconnect.v1.Connection]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L207}
  /// [google.cloud.developerconnect.v1.CreateConnectionRequest]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L405}
  ///
  // clang-format on
  future<StatusOr<google::cloud::developerconnect::v1::Connection>>
  CreateConnection(
      google::cloud::developerconnect::v1::CreateConnectionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateConnection
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateConnection(
      NoAwaitTag,
      google::cloud::developerconnect::v1::CreateConnectionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateConnection
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::developerconnect::v1::Connection>>
  CreateConnection(google::longrunning::Operation const& operation,
                   Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single Connection.
  ///
  /// @param connection  Required. The resource being updated
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  Connection resource by the update.
  ///  The fields specified in the update_mask are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If the
  ///  user does not provide a mask then all fields will be overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.developerconnect.v1.Connection] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.developerconnect.v1.Connection]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L207}
  /// [google.cloud.developerconnect.v1.UpdateConnectionRequest]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L445}
  ///
  // clang-format on
  future<StatusOr<google::cloud::developerconnect::v1::Connection>>
  UpdateConnection(
      google::cloud::developerconnect::v1::Connection const& connection,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateConnection
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateConnection(
      NoAwaitTag,
      google::cloud::developerconnect::v1::Connection const& connection,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single Connection.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.developerconnect.v1.UpdateConnectionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.developerconnect.v1.Connection] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.developerconnect.v1.Connection]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L207}
  /// [google.cloud.developerconnect.v1.UpdateConnectionRequest]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L445}
  ///
  // clang-format on
  future<StatusOr<google::cloud::developerconnect::v1::Connection>>
  UpdateConnection(
      google::cloud::developerconnect::v1::UpdateConnectionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateConnection
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateConnection(
      NoAwaitTag,
      google::cloud::developerconnect::v1::UpdateConnectionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateConnection
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::developerconnect::v1::Connection>>
  UpdateConnection(google::longrunning::Operation const& operation,
                   Options opts = {});

  // clang-format off
  ///
  /// Deletes a single Connection.
  ///
  /// @param name  Required. Name of the resource
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.developerconnect.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.developerconnect.v1.DeleteConnectionRequest]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L487}
  /// [google.cloud.developerconnect.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L524}
  ///
  // clang-format on
  future<StatusOr<google::cloud::developerconnect::v1::OperationMetadata>>
  DeleteConnection(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteConnection
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteConnection(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single Connection.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.developerconnect.v1.DeleteConnectionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.developerconnect.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.developerconnect.v1.DeleteConnectionRequest]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L487}
  /// [google.cloud.developerconnect.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L524}
  ///
  // clang-format on
  future<StatusOr<google::cloud::developerconnect::v1::OperationMetadata>>
  DeleteConnection(
      google::cloud::developerconnect::v1::DeleteConnectionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteConnection
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteConnection(
      NoAwaitTag,
      google::cloud::developerconnect::v1::DeleteConnectionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteConnection
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::developerconnect::v1::OperationMetadata>>
  DeleteConnection(google::longrunning::Operation const& operation,
                   Options opts = {});

  // clang-format off
  ///
  /// Creates a GitRepositoryLink. Upon linking a Git Repository, Developer
  /// Connect will configure the Git Repository to send webhook events to
  /// Developer Connect. Connections that use Firebase GitHub Application will
  /// have events forwarded to the Firebase service. All other Connections will
  /// have events forwarded to Cloud Build.
  ///
  /// @param parent  Required. Value for parent.
  /// @param git_repository_link  Required. The resource being created
  /// @param git_repository_link_id  Required. The ID to use for the repository, which will become the final
  ///  component of the repository's resource name. This ID should be unique in
  ///  the connection. Allows alphanumeric characters and any of
  ///  -._~%!$&'()*+,;=@.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.developerconnect.v1.GitRepositoryLink] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.developerconnect.v1.CreateGitRepositoryLinkRequest]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L606}
  /// [google.cloud.developerconnect.v1.GitRepositoryLink]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L554}
  ///
  // clang-format on
  future<StatusOr<google::cloud::developerconnect::v1::GitRepositoryLink>>
  CreateGitRepositoryLink(
      std::string const& parent,
      google::cloud::developerconnect::v1::GitRepositoryLink const&
          git_repository_link,
      std::string const& git_repository_link_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateGitRepositoryLink
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateGitRepositoryLink(
      NoAwaitTag, std::string const& parent,
      google::cloud::developerconnect::v1::GitRepositoryLink const&
          git_repository_link,
      std::string const& git_repository_link_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a GitRepositoryLink. Upon linking a Git Repository, Developer
  /// Connect will configure the Git Repository to send webhook events to
  /// Developer Connect. Connections that use Firebase GitHub Application will
  /// have events forwarded to the Firebase service. All other Connections will
  /// have events forwarded to Cloud Build.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.developerconnect.v1.CreateGitRepositoryLinkRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.developerconnect.v1.GitRepositoryLink] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.developerconnect.v1.CreateGitRepositoryLinkRequest]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L606}
  /// [google.cloud.developerconnect.v1.GitRepositoryLink]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L554}
  ///
  // clang-format on
  future<StatusOr<google::cloud::developerconnect::v1::GitRepositoryLink>>
  CreateGitRepositoryLink(
      google::cloud::developerconnect::v1::CreateGitRepositoryLinkRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateGitRepositoryLink
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateGitRepositoryLink(
      NoAwaitTag,
      google::cloud::developerconnect::v1::CreateGitRepositoryLinkRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateGitRepositoryLink
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::developerconnect::v1::GitRepositoryLink>>
  CreateGitRepositoryLink(google::longrunning::Operation const& operation,
                          Options opts = {});

  // clang-format off
  ///
  /// Deletes a single GitRepositoryLink.
  ///
  /// @param name  Required. Name of the resource
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.developerconnect.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.developerconnect.v1.DeleteGitRepositoryLinkRequest]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L648}
  /// [google.cloud.developerconnect.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L524}
  ///
  // clang-format on
  future<StatusOr<google::cloud::developerconnect::v1::OperationMetadata>>
  DeleteGitRepositoryLink(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteGitRepositoryLink
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteGitRepositoryLink(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single GitRepositoryLink.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.developerconnect.v1.DeleteGitRepositoryLinkRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.developerconnect.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.developerconnect.v1.DeleteGitRepositoryLinkRequest]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L648}
  /// [google.cloud.developerconnect.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L524}
  ///
  // clang-format on
  future<StatusOr<google::cloud::developerconnect::v1::OperationMetadata>>
  DeleteGitRepositoryLink(
      google::cloud::developerconnect::v1::DeleteGitRepositoryLinkRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteGitRepositoryLink
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteGitRepositoryLink(
      NoAwaitTag,
      google::cloud::developerconnect::v1::DeleteGitRepositoryLinkRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteGitRepositoryLink
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::developerconnect::v1::OperationMetadata>>
  DeleteGitRepositoryLink(google::longrunning::Operation const& operation,
                          Options opts = {});

  // clang-format off
  ///
  /// Lists GitRepositoryLinks in a given project, location, and connection.
  ///
  /// @param parent  Required. Parent value for ListGitRepositoryLinksRequest
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.developerconnect.v1.GitRepositoryLink], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.developerconnect.v1.GitRepositoryLink]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L554}
  /// [google.cloud.developerconnect.v1.ListGitRepositoryLinksRequest]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L685}
  ///
  // clang-format on
  StreamRange<google::cloud::developerconnect::v1::GitRepositoryLink>
  ListGitRepositoryLinks(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists GitRepositoryLinks in a given project, location, and connection.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.developerconnect.v1.ListGitRepositoryLinksRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.developerconnect.v1.GitRepositoryLink], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.developerconnect.v1.GitRepositoryLink]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L554}
  /// [google.cloud.developerconnect.v1.ListGitRepositoryLinksRequest]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L685}
  ///
  // clang-format on
  StreamRange<google::cloud::developerconnect::v1::GitRepositoryLink>
  ListGitRepositoryLinks(
      google::cloud::developerconnect::v1::ListGitRepositoryLinksRequest
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single GitRepositoryLink.
  ///
  /// @param name  Required. Name of the resource
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.developerconnect.v1.GitRepositoryLink])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.developerconnect.v1.GetGitRepositoryLinkRequest]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L721}
  /// [google.cloud.developerconnect.v1.GitRepositoryLink]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L554}
  ///
  // clang-format on
  StatusOr<google::cloud::developerconnect::v1::GitRepositoryLink>
  GetGitRepositoryLink(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single GitRepositoryLink.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.developerconnect.v1.GetGitRepositoryLinkRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.developerconnect.v1.GitRepositoryLink])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.developerconnect.v1.GetGitRepositoryLinkRequest]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L721}
  /// [google.cloud.developerconnect.v1.GitRepositoryLink]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L554}
  ///
  // clang-format on
  StatusOr<google::cloud::developerconnect::v1::GitRepositoryLink>
  GetGitRepositoryLink(
      google::cloud::developerconnect::v1::GetGitRepositoryLinkRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Fetches read/write token of a given gitRepositoryLink.
  ///
  /// @param git_repository_link  Required. The resource name of the gitRepositoryLink in the format
  ///  `projects/*/locations/*/connections/*/gitRepositoryLinks/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.developerconnect.v1.FetchReadWriteTokenResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.developerconnect.v1.FetchReadWriteTokenRequest]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L732}
  /// [google.cloud.developerconnect.v1.FetchReadWriteTokenResponse]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L770}
  ///
  // clang-format on
  StatusOr<google::cloud::developerconnect::v1::FetchReadWriteTokenResponse>
  FetchReadWriteToken(std::string const& git_repository_link,
                      Options opts = {});

  // clang-format off
  ///
  /// Fetches read/write token of a given gitRepositoryLink.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.developerconnect.v1.FetchReadWriteTokenRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.developerconnect.v1.FetchReadWriteTokenResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.developerconnect.v1.FetchReadWriteTokenRequest]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L732}
  /// [google.cloud.developerconnect.v1.FetchReadWriteTokenResponse]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L770}
  ///
  // clang-format on
  StatusOr<google::cloud::developerconnect::v1::FetchReadWriteTokenResponse>
  FetchReadWriteToken(
      google::cloud::developerconnect::v1::FetchReadWriteTokenRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Fetches read token of a given gitRepositoryLink.
  ///
  /// @param git_repository_link  Required. The resource name of the gitRepositoryLink in the format
  ///  `projects/*/locations/*/connections/*/gitRepositoryLinks/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.developerconnect.v1.FetchReadTokenResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.developerconnect.v1.FetchReadTokenRequest]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L744}
  /// [google.cloud.developerconnect.v1.FetchReadTokenResponse]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L756}
  ///
  // clang-format on
  StatusOr<google::cloud::developerconnect::v1::FetchReadTokenResponse>
  FetchReadToken(std::string const& git_repository_link, Options opts = {});

  // clang-format off
  ///
  /// Fetches read token of a given gitRepositoryLink.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.developerconnect.v1.FetchReadTokenRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.developerconnect.v1.FetchReadTokenResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.developerconnect.v1.FetchReadTokenRequest]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L744}
  /// [google.cloud.developerconnect.v1.FetchReadTokenResponse]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L756}
  ///
  // clang-format on
  StatusOr<google::cloud::developerconnect::v1::FetchReadTokenResponse>
  FetchReadToken(
      google::cloud::developerconnect::v1::FetchReadTokenRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// FetchLinkableGitRepositories returns a list of git repositories from an SCM
  /// that are available to be added to a Connection.
  ///
  /// @param connection  Required. The name of the Connection.
  ///  Format: `projects/*/locations/*/connections/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.developerconnect.v1.LinkableGitRepository], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.developerconnect.v1.FetchLinkableGitRepositoriesRequest]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L784}
  /// [google.cloud.developerconnect.v1.LinkableGitRepository]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L812}
  ///
  // clang-format on
  StreamRange<google::cloud::developerconnect::v1::LinkableGitRepository>
  FetchLinkableGitRepositories(std::string const& connection,
                               Options opts = {});

  // clang-format off
  ///
  /// FetchLinkableGitRepositories returns a list of git repositories from an SCM
  /// that are available to be added to a Connection.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.developerconnect.v1.FetchLinkableGitRepositoriesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.developerconnect.v1.LinkableGitRepository], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.developerconnect.v1.FetchLinkableGitRepositoriesRequest]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L784}
  /// [google.cloud.developerconnect.v1.LinkableGitRepository]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L812}
  ///
  // clang-format on
  StreamRange<google::cloud::developerconnect::v1::LinkableGitRepository>
  FetchLinkableGitRepositories(
      google::cloud::developerconnect::v1::FetchLinkableGitRepositoriesRequest
          request,
      Options opts = {});

  // clang-format off
  ///
  /// FetchGitHubInstallations returns the list of GitHub Installations that
  /// are available to be added to a Connection.
  /// For github.com, only installations accessible to the authorizer token
  /// are returned. For GitHub Enterprise, all installations are returned.
  ///
  /// @param connection  Required. The resource name of the connection in the format
  ///  `projects/*/locations/*/connections/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.developerconnect.v1.FetchGitHubInstallationsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.developerconnect.v1.FetchGitHubInstallationsRequest]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L818}
  /// [google.cloud.developerconnect.v1.FetchGitHubInstallationsResponse]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L830}
  ///
  // clang-format on
  StatusOr<
      google::cloud::developerconnect::v1::FetchGitHubInstallationsResponse>
  FetchGitHubInstallations(std::string const& connection, Options opts = {});

  // clang-format off
  ///
  /// FetchGitHubInstallations returns the list of GitHub Installations that
  /// are available to be added to a Connection.
  /// For github.com, only installations accessible to the authorizer token
  /// are returned. For GitHub Enterprise, all installations are returned.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.developerconnect.v1.FetchGitHubInstallationsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.developerconnect.v1.FetchGitHubInstallationsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.developerconnect.v1.FetchGitHubInstallationsRequest]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L818}
  /// [google.cloud.developerconnect.v1.FetchGitHubInstallationsResponse]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L830}
  ///
  // clang-format on
  StatusOr<
      google::cloud::developerconnect::v1::FetchGitHubInstallationsResponse>
  FetchGitHubInstallations(google::cloud::developerconnect::v1::
                               FetchGitHubInstallationsRequest const& request,
                           Options opts = {});

  // clang-format off
  ///
  /// Fetch the list of branches or tags for a given repository.
  ///
  /// @param git_repository_link  Required. The resource name of GitRepositoryLink in the format
  ///  `projects/*/locations/*/connections/*/gitRepositoryLinks/*`.
  /// @param ref_type  Required. Type of refs to fetch.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains a
  ///     [`std::string`].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.developerconnect.v1.FetchGitRefsRequest]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L849}
  ///
  // clang-format on
  StreamRange<std::string> FetchGitRefs(
      std::string const& git_repository_link,
      google::cloud::developerconnect::v1::FetchGitRefsRequest::RefType
          ref_type,
      Options opts = {});

  // clang-format off
  ///
  /// Fetch the list of branches or tags for a given repository.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.developerconnect.v1.FetchGitRefsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains a
  ///     [`std::string`].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.developerconnect.v1.FetchGitRefsRequest]: @googleapis_reference_link{google/cloud/developerconnect/v1/developer_connect.proto#L849}
  ///
  // clang-format on
  StreamRange<std::string> FetchGitRefs(
      google::cloud::developerconnect::v1::FetchGitRefsRequest request,
      Options opts = {});

 private:
  std::shared_ptr<DeveloperConnectConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace developerconnect_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DEVELOPERCONNECT_V1_DEVELOPER_CONNECT_CLIENT_H
