// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/datastore/v1/datastore.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATASTORE_V1_DATASTORE_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATASTORE_V1_DATASTORE_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/datastore/v1/datastore.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace datastore_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class DatastoreConnectionIdempotencyPolicy {
 public:
  virtual ~DatastoreConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<DatastoreConnectionIdempotencyPolicy> clone() const;

  virtual google::cloud::Idempotency Lookup(
      google::datastore::v1::LookupRequest const& request);

  virtual google::cloud::Idempotency RunQuery(
      google::datastore::v1::RunQueryRequest const& request);

  virtual google::cloud::Idempotency RunAggregationQuery(
      google::datastore::v1::RunAggregationQueryRequest const& request);

  virtual google::cloud::Idempotency BeginTransaction(
      google::datastore::v1::BeginTransactionRequest const& request);

  virtual google::cloud::Idempotency Commit(
      google::datastore::v1::CommitRequest const& request);

  virtual google::cloud::Idempotency Rollback(
      google::datastore::v1::RollbackRequest const& request);

  virtual google::cloud::Idempotency AllocateIds(
      google::datastore::v1::AllocateIdsRequest const& request);

  virtual google::cloud::Idempotency ReserveIds(
      google::datastore::v1::ReserveIdsRequest const& request);
};

std::unique_ptr<DatastoreConnectionIdempotencyPolicy>
MakeDefaultDatastoreConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datastore_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATASTORE_V1_DATASTORE_CONNECTION_IDEMPOTENCY_POLICY_H
