// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/catalog.proto

#include "google/cloud/dataplex/v1/internal/catalog_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dataplex_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

CatalogServiceTracingStub::CatalogServiceTracingStub(
    std::shared_ptr<CatalogServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

future<StatusOr<google::longrunning::Operation>>
CatalogServiceTracingStub::AsyncCreateEntryType(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::dataplex::v1::CreateEntryTypeRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "CreateEntryType");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateEntryType(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
CatalogServiceTracingStub::CreateEntryType(
    grpc::ClientContext& context, Options options,
    google::cloud::dataplex::v1::CreateEntryTypeRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "CreateEntryType");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateEntryType(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
CatalogServiceTracingStub::AsyncUpdateEntryType(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::dataplex::v1::UpdateEntryTypeRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "UpdateEntryType");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUpdateEntryType(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
CatalogServiceTracingStub::UpdateEntryType(
    grpc::ClientContext& context, Options options,
    google::cloud::dataplex::v1::UpdateEntryTypeRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "UpdateEntryType");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateEntryType(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
CatalogServiceTracingStub::AsyncDeleteEntryType(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::dataplex::v1::DeleteEntryTypeRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "DeleteEntryType");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteEntryType(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
CatalogServiceTracingStub::DeleteEntryType(
    grpc::ClientContext& context, Options options,
    google::cloud::dataplex::v1::DeleteEntryTypeRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "DeleteEntryType");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteEntryType(context, options, request));
}

StatusOr<google::cloud::dataplex::v1::ListEntryTypesResponse>
CatalogServiceTracingStub::ListEntryTypes(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataplex::v1::ListEntryTypesRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "ListEntryTypes");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListEntryTypes(context, options, request));
}

StatusOr<google::cloud::dataplex::v1::EntryType>
CatalogServiceTracingStub::GetEntryType(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataplex::v1::GetEntryTypeRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "GetEntryType");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetEntryType(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
CatalogServiceTracingStub::AsyncCreateAspectType(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::dataplex::v1::CreateAspectTypeRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "CreateAspectType");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateAspectType(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
CatalogServiceTracingStub::CreateAspectType(
    grpc::ClientContext& context, Options options,
    google::cloud::dataplex::v1::CreateAspectTypeRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "CreateAspectType");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateAspectType(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
CatalogServiceTracingStub::AsyncUpdateAspectType(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::dataplex::v1::UpdateAspectTypeRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "UpdateAspectType");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUpdateAspectType(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
CatalogServiceTracingStub::UpdateAspectType(
    grpc::ClientContext& context, Options options,
    google::cloud::dataplex::v1::UpdateAspectTypeRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "UpdateAspectType");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateAspectType(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
CatalogServiceTracingStub::AsyncDeleteAspectType(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::dataplex::v1::DeleteAspectTypeRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "DeleteAspectType");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteAspectType(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
CatalogServiceTracingStub::DeleteAspectType(
    grpc::ClientContext& context, Options options,
    google::cloud::dataplex::v1::DeleteAspectTypeRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "DeleteAspectType");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteAspectType(context, options, request));
}

StatusOr<google::cloud::dataplex::v1::ListAspectTypesResponse>
CatalogServiceTracingStub::ListAspectTypes(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataplex::v1::ListAspectTypesRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "ListAspectTypes");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListAspectTypes(context, options, request));
}

StatusOr<google::cloud::dataplex::v1::AspectType>
CatalogServiceTracingStub::GetAspectType(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataplex::v1::GetAspectTypeRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "GetAspectType");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetAspectType(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
CatalogServiceTracingStub::AsyncCreateEntryGroup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::dataplex::v1::CreateEntryGroupRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "CreateEntryGroup");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateEntryGroup(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
CatalogServiceTracingStub::CreateEntryGroup(
    grpc::ClientContext& context, Options options,
    google::cloud::dataplex::v1::CreateEntryGroupRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "CreateEntryGroup");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateEntryGroup(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
CatalogServiceTracingStub::AsyncUpdateEntryGroup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::dataplex::v1::UpdateEntryGroupRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "UpdateEntryGroup");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUpdateEntryGroup(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
CatalogServiceTracingStub::UpdateEntryGroup(
    grpc::ClientContext& context, Options options,
    google::cloud::dataplex::v1::UpdateEntryGroupRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "UpdateEntryGroup");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateEntryGroup(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
CatalogServiceTracingStub::AsyncDeleteEntryGroup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::dataplex::v1::DeleteEntryGroupRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "DeleteEntryGroup");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteEntryGroup(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
CatalogServiceTracingStub::DeleteEntryGroup(
    grpc::ClientContext& context, Options options,
    google::cloud::dataplex::v1::DeleteEntryGroupRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "DeleteEntryGroup");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteEntryGroup(context, options, request));
}

StatusOr<google::cloud::dataplex::v1::ListEntryGroupsResponse>
CatalogServiceTracingStub::ListEntryGroups(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataplex::v1::ListEntryGroupsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "ListEntryGroups");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListEntryGroups(context, options, request));
}

StatusOr<google::cloud::dataplex::v1::EntryGroup>
CatalogServiceTracingStub::GetEntryGroup(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataplex::v1::GetEntryGroupRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "GetEntryGroup");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetEntryGroup(context, options, request));
}

StatusOr<google::cloud::dataplex::v1::Entry>
CatalogServiceTracingStub::CreateEntry(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataplex::v1::CreateEntryRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "CreateEntry");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateEntry(context, options, request));
}

StatusOr<google::cloud::dataplex::v1::Entry>
CatalogServiceTracingStub::UpdateEntry(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataplex::v1::UpdateEntryRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "UpdateEntry");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateEntry(context, options, request));
}

StatusOr<google::cloud::dataplex::v1::Entry>
CatalogServiceTracingStub::DeleteEntry(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataplex::v1::DeleteEntryRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "DeleteEntry");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteEntry(context, options, request));
}

StatusOr<google::cloud::dataplex::v1::ListEntriesResponse>
CatalogServiceTracingStub::ListEntries(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataplex::v1::ListEntriesRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "ListEntries");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListEntries(context, options, request));
}

StatusOr<google::cloud::dataplex::v1::Entry>
CatalogServiceTracingStub::GetEntry(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataplex::v1::GetEntryRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "GetEntry");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetEntry(context, options, request));
}

StatusOr<google::cloud::dataplex::v1::Entry>
CatalogServiceTracingStub::LookupEntry(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataplex::v1::LookupEntryRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "LookupEntry");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->LookupEntry(context, options, request));
}

StatusOr<google::cloud::dataplex::v1::SearchEntriesResponse>
CatalogServiceTracingStub::SearchEntries(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataplex::v1::SearchEntriesRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.CatalogService",
                                     "SearchEntries");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->SearchEntries(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
CatalogServiceTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> CatalogServiceTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCancelOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<CatalogServiceStub> MakeCatalogServiceTracingStub(
    std::shared_ptr<CatalogServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<CatalogServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1_internal
}  // namespace cloud
}  // namespace google
