// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/contentwarehouse/v1/synonymset_service.proto

#include "google/cloud/contentwarehouse/v1/internal/synonym_set_option_defaults.h"
#include "google/cloud/contentwarehouse/v1/synonym_set_connection.h"
#include "google/cloud/contentwarehouse/v1/synonym_set_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace contentwarehouse_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options SynonymSetServiceDefaultOptions(Options options) {
  options = internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_SYNONYM_SET_SERVICE_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_SYNONYM_SET_SERVICE_AUTHORITY",
      "contentwarehouse.googleapis.com");
  options = internal::PopulateGrpcOptions(std::move(options));
  if (!options.has<contentwarehouse_v1::SynonymSetServiceRetryPolicyOption>()) {
    options.set<contentwarehouse_v1::SynonymSetServiceRetryPolicyOption>(
        contentwarehouse_v1::SynonymSetServiceLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options
           .has<contentwarehouse_v1::SynonymSetServiceBackoffPolicyOption>()) {
    options.set<contentwarehouse_v1::SynonymSetServiceBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<contentwarehouse_v1::
                       SynonymSetServiceConnectionIdempotencyPolicyOption>()) {
    options.set<contentwarehouse_v1::
                    SynonymSetServiceConnectionIdempotencyPolicyOption>(
        contentwarehouse_v1::
            MakeDefaultSynonymSetServiceConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace contentwarehouse_v1_internal
}  // namespace cloud
}  // namespace google
