// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/instance_settings/v1/instance_settings.proto

#include "google/cloud/compute/instance_settings/v1/internal/instance_settings_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_instance_settings_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

InstanceSettingsTracingConnection::InstanceSettingsTracingConnection(
    std::shared_ptr<compute_instance_settings_v1::InstanceSettingsConnection>
        child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::cpp::compute::v1::InstanceSettings>
InstanceSettingsTracingConnection::GetInstanceSettings(
    google::cloud::cpp::compute::instance_settings::v1::
        GetInstanceSettingsRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_instance_settings_v1::InstanceSettingsConnection::"
      "GetInstanceSettings");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetInstanceSettings(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceSettingsTracingConnection::PatchInstanceSettings(
    google::cloud::cpp::compute::instance_settings::v1::
        PatchInstanceSettingsRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_instance_settings_v1::InstanceSettingsConnection::"
      "PatchInstanceSettings");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->PatchInstanceSettings(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstanceSettingsTracingConnection::PatchInstanceSettings(
    NoAwaitTag, google::cloud::cpp::compute::instance_settings::v1::
                    PatchInstanceSettingsRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_instance_settings_v1::InstanceSettingsConnection::"
      "PatchInstanceSettings");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->PatchInstanceSettings(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceSettingsTracingConnection::PatchInstanceSettings(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_instance_settings_v1::InstanceSettingsConnection::"
      "PatchInstanceSettings");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->PatchInstanceSettings(operation));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<compute_instance_settings_v1::InstanceSettingsConnection>
MakeInstanceSettingsTracingConnection(
    std::shared_ptr<compute_instance_settings_v1::InstanceSettingsConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<InstanceSettingsTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_instance_settings_v1_internal
}  // namespace cloud
}  // namespace google
