// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/cloudcontrolspartner/v1/monitoring.proto

#include "google/cloud/cloudcontrolspartner/v1/internal/cloud_controls_partner_monitoring_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace cloudcontrolspartner_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

CloudControlsPartnerMonitoringTracingConnection::
    CloudControlsPartnerMonitoringTracingConnection(
        std::shared_ptr<
            cloudcontrolspartner_v1::CloudControlsPartnerMonitoringConnection>
            child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::cloudcontrolspartner::v1::Violation>
CloudControlsPartnerMonitoringTracingConnection::ListViolations(
    google::cloud::cloudcontrolspartner::v1::ListViolationsRequest request) {
  auto span = internal::MakeSpan(
      "cloudcontrolspartner_v1::CloudControlsPartnerMonitoringConnection::"
      "ListViolations");
  internal::OTelScope scope(span);
  auto sr = child_->ListViolations(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cloudcontrolspartner::v1::Violation>(std::move(span),
                                                          std::move(sr));
}

StatusOr<google::cloud::cloudcontrolspartner::v1::Violation>
CloudControlsPartnerMonitoringTracingConnection::GetViolation(
    google::cloud::cloudcontrolspartner::v1::GetViolationRequest const&
        request) {
  auto span = internal::MakeSpan(
      "cloudcontrolspartner_v1::CloudControlsPartnerMonitoringConnection::"
      "GetViolation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetViolation(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<
    cloudcontrolspartner_v1::CloudControlsPartnerMonitoringConnection>
MakeCloudControlsPartnerMonitoringTracingConnection(
    std::shared_ptr<
        cloudcontrolspartner_v1::CloudControlsPartnerMonitoringConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<CloudControlsPartnerMonitoringTracingConnection>(
        std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudcontrolspartner_v1_internal
}  // namespace cloud
}  // namespace google
