// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/v2/table.proto

#include "google/cloud/bigquerycontrol/v2/table_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace bigquerycontrol_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TableServiceClient::TableServiceClient(
    std::shared_ptr<TableServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
TableServiceClient::~TableServiceClient() = default;

StatusOr<google::cloud::bigquery::v2::Table> TableServiceClient::GetTable(
    google::cloud::bigquery::v2::GetTableRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetTable(request);
}

StatusOr<google::cloud::bigquery::v2::Table> TableServiceClient::InsertTable(
    google::cloud::bigquery::v2::InsertTableRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertTable(request);
}

StatusOr<google::cloud::bigquery::v2::Table> TableServiceClient::PatchTable(
    google::cloud::bigquery::v2::UpdateOrPatchTableRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchTable(request);
}

StatusOr<google::cloud::bigquery::v2::Table> TableServiceClient::UpdateTable(
    google::cloud::bigquery::v2::UpdateOrPatchTableRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateTable(request);
}

Status TableServiceClient::DeleteTable(
    google::cloud::bigquery::v2::DeleteTableRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTable(request);
}

StreamRange<google::cloud::bigquery::v2::ListFormatTable>
TableServiceClient::ListTables(
    google::cloud::bigquery::v2::ListTablesRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListTables(std::move(request));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquerycontrol_v2
}  // namespace cloud
}  // namespace google
