// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/v2/job.proto

#include "google/cloud/bigquerycontrol/v2/internal/job_rest_connection_impl.h"
#include "google/cloud/bigquerycontrol/v2/internal/job_rest_stub_factory.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/rest_retry_loop.h"
#include "google/cloud/rest_options.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace bigquerycontrol_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

JobServiceRestConnectionImpl::JobServiceRestConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<bigquerycontrol_v2_internal::JobServiceRestStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      JobServiceConnection::options())) {}

StatusOr<google::cloud::bigquery::v2::JobCancelResponse>
JobServiceRestConnectionImpl::CancelJob(
    google::cloud::bigquery::v2::CancelJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::rest_internal::RestRetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CancelJob(request),
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::bigquery::v2::CancelJobRequest const& request) {
        return stub_->CancelJob(rest_context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::bigquery::v2::Job> JobServiceRestConnectionImpl::GetJob(
    google::cloud::bigquery::v2::GetJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::rest_internal::RestRetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetJob(request),
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::bigquery::v2::GetJobRequest const& request) {
        return stub_->GetJob(rest_context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::bigquery::v2::Job>
JobServiceRestConnectionImpl::InsertJob(
    google::cloud::bigquery::v2::InsertJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::rest_internal::RestRetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->InsertJob(request),
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::bigquery::v2::InsertJobRequest const& request) {
        return stub_->InsertJob(rest_context, options, request);
      },
      *current, request, __func__);
}

Status JobServiceRestConnectionImpl::DeleteJob(
    google::cloud::bigquery::v2::DeleteJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::rest_internal::RestRetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteJob(request),
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::bigquery::v2::DeleteJobRequest const& request) {
        return stub_->DeleteJob(rest_context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::bigquery::v2::ListFormatJob>
JobServiceRestConnectionImpl::ListJobs(
    google::cloud::bigquery::v2::ListJobsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListJobs(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::bigquery::v2::ListFormatJob>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<bigquerycontrol_v2::JobServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::bigquery::v2::ListJobsRequest const& r) {
        return google::cloud::rest_internal::RestRetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                rest_internal::RestContext& rest_context,
                Options const& options,
                google::cloud::bigquery::v2::ListJobsRequest const& request) {
              return stub->ListJobs(rest_context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::bigquery::v2::JobList r) {
        std::vector<google::cloud::bigquery::v2::ListFormatJob> result(
            r.jobs().size());
        auto& messages = *r.mutable_jobs();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::bigquery::v2::GetQueryResultsResponse>
JobServiceRestConnectionImpl::GetQueryResults(
    google::cloud::bigquery::v2::GetQueryResultsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::rest_internal::RestRetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetQueryResults(request),
      [this](
          rest_internal::RestContext& rest_context, Options const& options,
          google::cloud::bigquery::v2::GetQueryResultsRequest const& request) {
        return stub_->GetQueryResults(rest_context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::bigquery::v2::QueryResponse>
JobServiceRestConnectionImpl::Query(
    google::cloud::bigquery::v2::PostQueryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::rest_internal::RestRetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->Query(request),
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::bigquery::v2::PostQueryRequest const& request) {
        return stub_->Query(rest_context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquerycontrol_v2_internal
}  // namespace cloud
}  // namespace google
