// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/datatransfer/v1/datatransfer.proto

#include "google/cloud/bigquery/datatransfer/v1/internal/data_transfer_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace bigquery_datatransfer_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

DataTransferServiceTracingConnection::DataTransferServiceTracingConnection(
    std::shared_ptr<bigquery_datatransfer_v1::DataTransferServiceConnection>
        child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::bigquery::datatransfer::v1::DataSource>
DataTransferServiceTracingConnection::GetDataSource(
    google::cloud::bigquery::datatransfer::v1::GetDataSourceRequest const&
        request) {
  auto span = internal::MakeSpan(
      "bigquery_datatransfer_v1::DataTransferServiceConnection::GetDataSource");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetDataSource(request));
}

StreamRange<google::cloud::bigquery::datatransfer::v1::DataSource>
DataTransferServiceTracingConnection::ListDataSources(
    google::cloud::bigquery::datatransfer::v1::ListDataSourcesRequest request) {
  auto span = internal::MakeSpan(
      "bigquery_datatransfer_v1::DataTransferServiceConnection::"
      "ListDataSources");
  internal::OTelScope scope(span);
  auto sr = child_->ListDataSources(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::bigquery::datatransfer::v1::DataSource>(std::move(span),
                                                             std::move(sr));
}

StatusOr<google::cloud::bigquery::datatransfer::v1::TransferConfig>
DataTransferServiceTracingConnection::CreateTransferConfig(
    google::cloud::bigquery::datatransfer::v1::
        CreateTransferConfigRequest const& request) {
  auto span = internal::MakeSpan(
      "bigquery_datatransfer_v1::DataTransferServiceConnection::"
      "CreateTransferConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateTransferConfig(request));
}

StatusOr<google::cloud::bigquery::datatransfer::v1::TransferConfig>
DataTransferServiceTracingConnection::UpdateTransferConfig(
    google::cloud::bigquery::datatransfer::v1::
        UpdateTransferConfigRequest const& request) {
  auto span = internal::MakeSpan(
      "bigquery_datatransfer_v1::DataTransferServiceConnection::"
      "UpdateTransferConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateTransferConfig(request));
}

Status DataTransferServiceTracingConnection::DeleteTransferConfig(
    google::cloud::bigquery::datatransfer::v1::
        DeleteTransferConfigRequest const& request) {
  auto span = internal::MakeSpan(
      "bigquery_datatransfer_v1::DataTransferServiceConnection::"
      "DeleteTransferConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteTransferConfig(request));
}

StatusOr<google::cloud::bigquery::datatransfer::v1::TransferConfig>
DataTransferServiceTracingConnection::GetTransferConfig(
    google::cloud::bigquery::datatransfer::v1::GetTransferConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "bigquery_datatransfer_v1::DataTransferServiceConnection::"
      "GetTransferConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetTransferConfig(request));
}

StreamRange<google::cloud::bigquery::datatransfer::v1::TransferConfig>
DataTransferServiceTracingConnection::ListTransferConfigs(
    google::cloud::bigquery::datatransfer::v1::ListTransferConfigsRequest
        request) {
  auto span = internal::MakeSpan(
      "bigquery_datatransfer_v1::DataTransferServiceConnection::"
      "ListTransferConfigs");
  internal::OTelScope scope(span);
  auto sr = child_->ListTransferConfigs(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::bigquery::datatransfer::v1::TransferConfig>(
      std::move(span), std::move(sr));
}

StatusOr<
    google::cloud::bigquery::datatransfer::v1::ScheduleTransferRunsResponse>
DataTransferServiceTracingConnection::ScheduleTransferRuns(
    google::cloud::bigquery::datatransfer::v1::
        ScheduleTransferRunsRequest const& request) {
  auto span = internal::MakeSpan(
      "bigquery_datatransfer_v1::DataTransferServiceConnection::"
      "ScheduleTransferRuns");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->ScheduleTransferRuns(request));
}

StatusOr<
    google::cloud::bigquery::datatransfer::v1::StartManualTransferRunsResponse>
DataTransferServiceTracingConnection::StartManualTransferRuns(
    google::cloud::bigquery::datatransfer::v1::
        StartManualTransferRunsRequest const& request) {
  auto span = internal::MakeSpan(
      "bigquery_datatransfer_v1::DataTransferServiceConnection::"
      "StartManualTransferRuns");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->StartManualTransferRuns(request));
}

StatusOr<google::cloud::bigquery::datatransfer::v1::TransferRun>
DataTransferServiceTracingConnection::GetTransferRun(
    google::cloud::bigquery::datatransfer::v1::GetTransferRunRequest const&
        request) {
  auto span = internal::MakeSpan(
      "bigquery_datatransfer_v1::DataTransferServiceConnection::"
      "GetTransferRun");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetTransferRun(request));
}

Status DataTransferServiceTracingConnection::DeleteTransferRun(
    google::cloud::bigquery::datatransfer::v1::DeleteTransferRunRequest const&
        request) {
  auto span = internal::MakeSpan(
      "bigquery_datatransfer_v1::DataTransferServiceConnection::"
      "DeleteTransferRun");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteTransferRun(request));
}

StreamRange<google::cloud::bigquery::datatransfer::v1::TransferRun>
DataTransferServiceTracingConnection::ListTransferRuns(
    google::cloud::bigquery::datatransfer::v1::ListTransferRunsRequest
        request) {
  auto span = internal::MakeSpan(
      "bigquery_datatransfer_v1::DataTransferServiceConnection::"
      "ListTransferRuns");
  internal::OTelScope scope(span);
  auto sr = child_->ListTransferRuns(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::bigquery::datatransfer::v1::TransferRun>(std::move(span),
                                                              std::move(sr));
}

StreamRange<google::cloud::bigquery::datatransfer::v1::TransferMessage>
DataTransferServiceTracingConnection::ListTransferLogs(
    google::cloud::bigquery::datatransfer::v1::ListTransferLogsRequest
        request) {
  auto span = internal::MakeSpan(
      "bigquery_datatransfer_v1::DataTransferServiceConnection::"
      "ListTransferLogs");
  internal::OTelScope scope(span);
  auto sr = child_->ListTransferLogs(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::bigquery::datatransfer::v1::TransferMessage>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::bigquery::datatransfer::v1::CheckValidCredsResponse>
DataTransferServiceTracingConnection::CheckValidCreds(
    google::cloud::bigquery::datatransfer::v1::CheckValidCredsRequest const&
        request) {
  auto span = internal::MakeSpan(
      "bigquery_datatransfer_v1::DataTransferServiceConnection::"
      "CheckValidCreds");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CheckValidCreds(request));
}

Status DataTransferServiceTracingConnection::EnrollDataSources(
    google::cloud::bigquery::datatransfer::v1::EnrollDataSourcesRequest const&
        request) {
  auto span = internal::MakeSpan(
      "bigquery_datatransfer_v1::DataTransferServiceConnection::"
      "EnrollDataSources");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->EnrollDataSources(request));
}

Status DataTransferServiceTracingConnection::UnenrollDataSources(
    google::cloud::bigquery::datatransfer::v1::UnenrollDataSourcesRequest const&
        request) {
  auto span = internal::MakeSpan(
      "bigquery_datatransfer_v1::DataTransferServiceConnection::"
      "UnenrollDataSources");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UnenrollDataSources(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<bigquery_datatransfer_v1::DataTransferServiceConnection>
MakeDataTransferServiceTracingConnection(
    std::shared_ptr<bigquery_datatransfer_v1::DataTransferServiceConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn =
        std::make_shared<DataTransferServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_datatransfer_v1_internal
}  // namespace cloud
}  // namespace google
