// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/datapolicies/v1/datapolicy.proto

#include "google/cloud/bigquery/datapolicies/v1/data_policy_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace bigquery_datapolicies_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

DataPolicyServiceConnectionIdempotencyPolicy::
    ~DataPolicyServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<DataPolicyServiceConnectionIdempotencyPolicy>
DataPolicyServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<DataPolicyServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency DataPolicyServiceConnectionIdempotencyPolicy::CreateDataPolicy(
    google::cloud::bigquery::datapolicies::v1::CreateDataPolicyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataPolicyServiceConnectionIdempotencyPolicy::UpdateDataPolicy(
    google::cloud::bigquery::datapolicies::v1::UpdateDataPolicyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataPolicyServiceConnectionIdempotencyPolicy::RenameDataPolicy(
    google::cloud::bigquery::datapolicies::v1::RenameDataPolicyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataPolicyServiceConnectionIdempotencyPolicy::DeleteDataPolicy(
    google::cloud::bigquery::datapolicies::v1::DeleteDataPolicyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataPolicyServiceConnectionIdempotencyPolicy::GetDataPolicy(
    google::cloud::bigquery::datapolicies::v1::GetDataPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency DataPolicyServiceConnectionIdempotencyPolicy::ListDataPolicies(
    google::cloud::bigquery::datapolicies::v1::
        ListDataPoliciesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency DataPolicyServiceConnectionIdempotencyPolicy::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency DataPolicyServiceConnectionIdempotencyPolicy::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return request.policy().etag().empty() ? Idempotency::kNonIdempotent
                                         : Idempotency::kIdempotent;
}

Idempotency DataPolicyServiceConnectionIdempotencyPolicy::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Idempotency::kIdempotent;
}

std::unique_ptr<DataPolicyServiceConnectionIdempotencyPolicy>
MakeDefaultDataPolicyServiceConnectionIdempotencyPolicy() {
  return std::make_unique<DataPolicyServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_datapolicies_v1
}  // namespace cloud
}  // namespace google
