// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/apphub/v1/apphub_service.proto

#include "google/cloud/apphub/v1/internal/app_hub_connection_impl.h"
#include "google/cloud/apphub/v1/internal/app_hub_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace apphub_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<apphub_v1::AppHubRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<apphub_v1::AppHubRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<apphub_v1::AppHubBackoffPolicyOption>()->clone();
}

std::unique_ptr<apphub_v1::AppHubConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options.get<apphub_v1::AppHubConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<apphub_v1::AppHubPollingPolicyOption>()->clone();
}

}  // namespace

AppHubConnectionImpl::AppHubConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<apphub_v1_internal::AppHubStub> stub, Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      AppHubConnection::options())) {}

StatusOr<google::cloud::apphub::v1::LookupServiceProjectAttachmentResponse>
AppHubConnectionImpl::LookupServiceProjectAttachment(
    google::cloud::apphub::v1::LookupServiceProjectAttachmentRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->LookupServiceProjectAttachment(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::apphub::v1::
                 LookupServiceProjectAttachmentRequest const& request) {
        return stub_->LookupServiceProjectAttachment(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::apphub::v1::ServiceProjectAttachment>
AppHubConnectionImpl::ListServiceProjectAttachments(
    google::cloud::apphub::v1::ListServiceProjectAttachmentsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListServiceProjectAttachments(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::apphub::v1::ServiceProjectAttachment>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<apphub_v1::AppHubRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::apphub::v1::ListServiceProjectAttachmentsRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::apphub::v1::
                       ListServiceProjectAttachmentsRequest const& request) {
              return stub->ListServiceProjectAttachments(context, options,
                                                         request);
            },
            options, r, function_name);
      },
      [](google::cloud::apphub::v1::ListServiceProjectAttachmentsResponse r) {
        std::vector<google::cloud::apphub::v1::ServiceProjectAttachment> result(
            r.service_project_attachments().size());
        auto& messages = *r.mutable_service_project_attachments();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::apphub::v1::ServiceProjectAttachment>>
AppHubConnectionImpl::CreateServiceProjectAttachment(
    google::cloud::apphub::v1::CreateServiceProjectAttachmentRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateServiceProjectAttachment(
          request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::apphub::v1::ServiceProjectAttachment>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::cloud::apphub::v1::
                         CreateServiceProjectAttachmentRequest const& request) {
        return stub->AsyncCreateServiceProjectAttachment(
            cq, std::move(context), std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::apphub::v1::ServiceProjectAttachment>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
AppHubConnectionImpl::CreateServiceProjectAttachment(
    NoAwaitTag,
    google::cloud::apphub::v1::CreateServiceProjectAttachmentRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateServiceProjectAttachment(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::apphub::v1::
                 CreateServiceProjectAttachmentRequest const& request) {
        return stub_->CreateServiceProjectAttachment(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::apphub::v1::ServiceProjectAttachment>>
AppHubConnectionImpl::CreateServiceProjectAttachment(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::apphub::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::apphub::v1::ServiceProjectAttachment>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateServiceProjectAttachment",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::apphub::v1::ServiceProjectAttachment>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::apphub::v1::ServiceProjectAttachment>,
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::apphub::v1::ServiceProjectAttachment>
AppHubConnectionImpl::GetServiceProjectAttachment(
    google::cloud::apphub::v1::GetServiceProjectAttachmentRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetServiceProjectAttachment(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::apphub::v1::GetServiceProjectAttachmentRequest const&
              request) {
        return stub_->GetServiceProjectAttachment(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubConnectionImpl::DeleteServiceProjectAttachment(
    google::cloud::apphub::v1::DeleteServiceProjectAttachmentRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteServiceProjectAttachment(
          request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::apphub::v1::OperationMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::cloud::apphub::v1::
                         DeleteServiceProjectAttachmentRequest const& request) {
        return stub->AsyncDeleteServiceProjectAttachment(
            cq, std::move(context), std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::apphub::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
AppHubConnectionImpl::DeleteServiceProjectAttachment(
    NoAwaitTag,
    google::cloud::apphub::v1::DeleteServiceProjectAttachmentRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteServiceProjectAttachment(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::apphub::v1::
                 DeleteServiceProjectAttachmentRequest const& request) {
        return stub_->DeleteServiceProjectAttachment(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubConnectionImpl::DeleteServiceProjectAttachment(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::apphub::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::apphub::v1::OperationMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteServiceProjectAttachment",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::apphub::v1::OperationMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::apphub::v1::OperationMetadata>,
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::apphub::v1::DetachServiceProjectAttachmentResponse>
AppHubConnectionImpl::DetachServiceProjectAttachment(
    google::cloud::apphub::v1::DetachServiceProjectAttachmentRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DetachServiceProjectAttachment(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::apphub::v1::
                 DetachServiceProjectAttachmentRequest const& request) {
        return stub_->DetachServiceProjectAttachment(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::apphub::v1::DiscoveredService>
AppHubConnectionImpl::ListDiscoveredServices(
    google::cloud::apphub::v1::ListDiscoveredServicesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListDiscoveredServices(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::apphub::v1::DiscoveredService>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<apphub_v1::AppHubRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::apphub::v1::ListDiscoveredServicesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::apphub::v1::ListDiscoveredServicesRequest const&
                    request) {
              return stub->ListDiscoveredServices(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::apphub::v1::ListDiscoveredServicesResponse r) {
        std::vector<google::cloud::apphub::v1::DiscoveredService> result(
            r.discovered_services().size());
        auto& messages = *r.mutable_discovered_services();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::apphub::v1::DiscoveredService>
AppHubConnectionImpl::GetDiscoveredService(
    google::cloud::apphub::v1::GetDiscoveredServiceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetDiscoveredService(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::apphub::v1::GetDiscoveredServiceRequest const&
                 request) {
        return stub_->GetDiscoveredService(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::apphub::v1::LookupDiscoveredServiceResponse>
AppHubConnectionImpl::LookupDiscoveredService(
    google::cloud::apphub::v1::LookupDiscoveredServiceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->LookupDiscoveredService(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::apphub::v1::LookupDiscoveredServiceRequest const&
                 request) {
        return stub_->LookupDiscoveredService(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::apphub::v1::Service>
AppHubConnectionImpl::ListServices(
    google::cloud::apphub::v1::ListServicesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListServices(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::apphub::v1::Service>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<apphub_v1::AppHubRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::apphub::v1::ListServicesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::apphub::v1::ListServicesRequest const& request) {
              return stub->ListServices(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::apphub::v1::ListServicesResponse r) {
        std::vector<google::cloud::apphub::v1::Service> result(
            r.services().size());
        auto& messages = *r.mutable_services();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::apphub::v1::Service>>
AppHubConnectionImpl::CreateService(
    google::cloud::apphub::v1::CreateServiceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateService(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::apphub::v1::Service>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::apphub::v1::CreateServiceRequest const& request) {
        return stub->AsyncCreateService(cq, std::move(context),
                                        std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::apphub::v1::Service>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation> AppHubConnectionImpl::CreateService(
    NoAwaitTag,
    google::cloud::apphub::v1::CreateServiceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateService(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::apphub::v1::CreateServiceRequest const& request) {
        return stub_->CreateService(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::apphub::v1::Service>>
AppHubConnectionImpl::CreateService(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::apphub::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::apphub::v1::Service>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateService",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::apphub::v1::Service>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::apphub::v1::Service>,
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::apphub::v1::Service> AppHubConnectionImpl::GetService(
    google::cloud::apphub::v1::GetServiceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetService(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::apphub::v1::GetServiceRequest const& request) {
        return stub_->GetService(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::apphub::v1::Service>>
AppHubConnectionImpl::UpdateService(
    google::cloud::apphub::v1::UpdateServiceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateService(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::apphub::v1::Service>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::apphub::v1::UpdateServiceRequest const& request) {
        return stub->AsyncUpdateService(cq, std::move(context),
                                        std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::apphub::v1::Service>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation> AppHubConnectionImpl::UpdateService(
    NoAwaitTag,
    google::cloud::apphub::v1::UpdateServiceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateService(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::apphub::v1::UpdateServiceRequest const& request) {
        return stub_->UpdateService(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::apphub::v1::Service>>
AppHubConnectionImpl::UpdateService(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::apphub::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::apphub::v1::Service>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateService",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::apphub::v1::Service>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::apphub::v1::Service>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubConnectionImpl::DeleteService(
    google::cloud::apphub::v1::DeleteServiceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteService(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::apphub::v1::OperationMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::apphub::v1::DeleteServiceRequest const& request) {
        return stub->AsyncDeleteService(cq, std::move(context),
                                        std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::apphub::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation> AppHubConnectionImpl::DeleteService(
    NoAwaitTag,
    google::cloud::apphub::v1::DeleteServiceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteService(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::apphub::v1::DeleteServiceRequest const& request) {
        return stub_->DeleteService(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubConnectionImpl::DeleteService(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::apphub::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::apphub::v1::OperationMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteService",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::apphub::v1::OperationMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::apphub::v1::OperationMetadata>,
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::apphub::v1::DiscoveredWorkload>
AppHubConnectionImpl::ListDiscoveredWorkloads(
    google::cloud::apphub::v1::ListDiscoveredWorkloadsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListDiscoveredWorkloads(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::apphub::v1::DiscoveredWorkload>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<apphub_v1::AppHubRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::apphub::v1::ListDiscoveredWorkloadsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::apphub::v1::ListDiscoveredWorkloadsRequest const&
                    request) {
              return stub->ListDiscoveredWorkloads(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::apphub::v1::ListDiscoveredWorkloadsResponse r) {
        std::vector<google::cloud::apphub::v1::DiscoveredWorkload> result(
            r.discovered_workloads().size());
        auto& messages = *r.mutable_discovered_workloads();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::apphub::v1::DiscoveredWorkload>
AppHubConnectionImpl::GetDiscoveredWorkload(
    google::cloud::apphub::v1::GetDiscoveredWorkloadRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetDiscoveredWorkload(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::apphub::v1::GetDiscoveredWorkloadRequest const&
                 request) {
        return stub_->GetDiscoveredWorkload(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::apphub::v1::LookupDiscoveredWorkloadResponse>
AppHubConnectionImpl::LookupDiscoveredWorkload(
    google::cloud::apphub::v1::LookupDiscoveredWorkloadRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->LookupDiscoveredWorkload(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::apphub::v1::LookupDiscoveredWorkloadRequest const&
                 request) {
        return stub_->LookupDiscoveredWorkload(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::apphub::v1::Workload>
AppHubConnectionImpl::ListWorkloads(
    google::cloud::apphub::v1::ListWorkloadsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListWorkloads(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::apphub::v1::Workload>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<apphub_v1::AppHubRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::apphub::v1::ListWorkloadsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::apphub::v1::ListWorkloadsRequest const&
                       request) {
              return stub->ListWorkloads(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::apphub::v1::ListWorkloadsResponse r) {
        std::vector<google::cloud::apphub::v1::Workload> result(
            r.workloads().size());
        auto& messages = *r.mutable_workloads();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::apphub::v1::Workload>>
AppHubConnectionImpl::CreateWorkload(
    google::cloud::apphub::v1::CreateWorkloadRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateWorkload(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::apphub::v1::Workload>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::apphub::v1::CreateWorkloadRequest const& request) {
        return stub->AsyncCreateWorkload(cq, std::move(context),
                                         std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::apphub::v1::Workload>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation> AppHubConnectionImpl::CreateWorkload(
    NoAwaitTag,
    google::cloud::apphub::v1::CreateWorkloadRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateWorkload(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::apphub::v1::CreateWorkloadRequest const& request) {
        return stub_->CreateWorkload(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::apphub::v1::Workload>>
AppHubConnectionImpl::CreateWorkload(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::apphub::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::apphub::v1::Workload>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateWorkload",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::apphub::v1::Workload>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::apphub::v1::Workload>,
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::apphub::v1::Workload> AppHubConnectionImpl::GetWorkload(
    google::cloud::apphub::v1::GetWorkloadRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetWorkload(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::apphub::v1::GetWorkloadRequest const& request) {
        return stub_->GetWorkload(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::apphub::v1::Workload>>
AppHubConnectionImpl::UpdateWorkload(
    google::cloud::apphub::v1::UpdateWorkloadRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateWorkload(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::apphub::v1::Workload>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::apphub::v1::UpdateWorkloadRequest const& request) {
        return stub->AsyncUpdateWorkload(cq, std::move(context),
                                         std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::apphub::v1::Workload>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation> AppHubConnectionImpl::UpdateWorkload(
    NoAwaitTag,
    google::cloud::apphub::v1::UpdateWorkloadRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateWorkload(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::apphub::v1::UpdateWorkloadRequest const& request) {
        return stub_->UpdateWorkload(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::apphub::v1::Workload>>
AppHubConnectionImpl::UpdateWorkload(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::apphub::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::apphub::v1::Workload>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateWorkload",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::apphub::v1::Workload>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::apphub::v1::Workload>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubConnectionImpl::DeleteWorkload(
    google::cloud::apphub::v1::DeleteWorkloadRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteWorkload(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::apphub::v1::OperationMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::apphub::v1::DeleteWorkloadRequest const& request) {
        return stub->AsyncDeleteWorkload(cq, std::move(context),
                                         std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::apphub::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation> AppHubConnectionImpl::DeleteWorkload(
    NoAwaitTag,
    google::cloud::apphub::v1::DeleteWorkloadRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteWorkload(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::apphub::v1::DeleteWorkloadRequest const& request) {
        return stub_->DeleteWorkload(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubConnectionImpl::DeleteWorkload(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::apphub::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::apphub::v1::OperationMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteWorkload",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::apphub::v1::OperationMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::apphub::v1::OperationMetadata>,
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::apphub::v1::Application>
AppHubConnectionImpl::ListApplications(
    google::cloud::apphub::v1::ListApplicationsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListApplications(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::apphub::v1::Application>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<apphub_v1::AppHubRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::apphub::v1::ListApplicationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::apphub::v1::ListApplicationsRequest const&
                       request) {
              return stub->ListApplications(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::apphub::v1::ListApplicationsResponse r) {
        std::vector<google::cloud::apphub::v1::Application> result(
            r.applications().size());
        auto& messages = *r.mutable_applications();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::apphub::v1::Application>>
AppHubConnectionImpl::CreateApplication(
    google::cloud::apphub::v1::CreateApplicationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateApplication(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::apphub::v1::Application>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::apphub::v1::CreateApplicationRequest const& request) {
        return stub->AsyncCreateApplication(cq, std::move(context),
                                            std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::apphub::v1::Application>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
AppHubConnectionImpl::CreateApplication(
    NoAwaitTag,
    google::cloud::apphub::v1::CreateApplicationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateApplication(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::apphub::v1::CreateApplicationRequest const& request) {
        return stub_->CreateApplication(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::apphub::v1::Application>>
AppHubConnectionImpl::CreateApplication(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::apphub::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::apphub::v1::Application>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateApplication",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::apphub::v1::Application>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::apphub::v1::Application>,
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::apphub::v1::Application>
AppHubConnectionImpl::GetApplication(
    google::cloud::apphub::v1::GetApplicationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetApplication(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::apphub::v1::GetApplicationRequest const& request) {
        return stub_->GetApplication(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::apphub::v1::Application>>
AppHubConnectionImpl::UpdateApplication(
    google::cloud::apphub::v1::UpdateApplicationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateApplication(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::apphub::v1::Application>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::apphub::v1::UpdateApplicationRequest const& request) {
        return stub->AsyncUpdateApplication(cq, std::move(context),
                                            std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::apphub::v1::Application>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
AppHubConnectionImpl::UpdateApplication(
    NoAwaitTag,
    google::cloud::apphub::v1::UpdateApplicationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateApplication(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::apphub::v1::UpdateApplicationRequest const& request) {
        return stub_->UpdateApplication(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::apphub::v1::Application>>
AppHubConnectionImpl::UpdateApplication(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::apphub::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::apphub::v1::Application>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateApplication",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::apphub::v1::Application>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::apphub::v1::Application>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubConnectionImpl::DeleteApplication(
    google::cloud::apphub::v1::DeleteApplicationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteApplication(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::apphub::v1::OperationMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::apphub::v1::DeleteApplicationRequest const& request) {
        return stub->AsyncDeleteApplication(cq, std::move(context),
                                            std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::apphub::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
AppHubConnectionImpl::DeleteApplication(
    NoAwaitTag,
    google::cloud::apphub::v1::DeleteApplicationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteApplication(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::apphub::v1::DeleteApplicationRequest const& request) {
        return stub_->DeleteApplication(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubConnectionImpl::DeleteApplication(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::apphub::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::apphub::v1::OperationMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteApplication",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::apphub::v1::OperationMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::apphub::v1::OperationMetadata>,
      polling_policy(*current), __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace apphub_v1_internal
}  // namespace cloud
}  // namespace google
