// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/persistent_resource_service.proto

#include "google/cloud/aiplatform/v1/persistent_resource_connection.h"
#include "google/cloud/aiplatform/v1/internal/persistent_resource_connection_impl.h"
#include "google/cloud/aiplatform/v1/internal/persistent_resource_option_defaults.h"
#include "google/cloud/aiplatform/v1/internal/persistent_resource_stub_factory.h"
#include "google/cloud/aiplatform/v1/internal/persistent_resource_tracing_connection.h"
#include "google/cloud/aiplatform/v1/persistent_resource_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

PersistentResourceServiceConnection::~PersistentResourceServiceConnection() =
    default;

future<StatusOr<google::cloud::aiplatform::v1::PersistentResource>>
PersistentResourceServiceConnection::CreatePersistentResource(
    google::cloud::aiplatform::v1::CreatePersistentResourceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::PersistentResource>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
PersistentResourceServiceConnection::CreatePersistentResource(
    NoAwaitTag,
    google::cloud::aiplatform::v1::CreatePersistentResourceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::PersistentResource>>
PersistentResourceServiceConnection::CreatePersistentResource(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::PersistentResource>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::aiplatform::v1::PersistentResource>
PersistentResourceServiceConnection::GetPersistentResource(
    google::cloud::aiplatform::v1::GetPersistentResourceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::aiplatform::v1::PersistentResource>
PersistentResourceServiceConnection::ListPersistentResources(
    google::cloud::aiplatform::v1::
        ListPersistentResourcesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::aiplatform::v1::PersistentResource>>();
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
PersistentResourceServiceConnection::DeletePersistentResource(
    google::cloud::aiplatform::v1::DeletePersistentResourceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
PersistentResourceServiceConnection::DeletePersistentResource(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeletePersistentResourceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
PersistentResourceServiceConnection::DeletePersistentResource(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::PersistentResource>>
PersistentResourceServiceConnection::UpdatePersistentResource(
    google::cloud::aiplatform::v1::UpdatePersistentResourceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::PersistentResource>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
PersistentResourceServiceConnection::UpdatePersistentResource(
    NoAwaitTag,
    google::cloud::aiplatform::v1::UpdatePersistentResourceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::PersistentResource>>
PersistentResourceServiceConnection::UpdatePersistentResource(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::PersistentResource>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::PersistentResource>>
PersistentResourceServiceConnection::RebootPersistentResource(
    google::cloud::aiplatform::v1::RebootPersistentResourceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::PersistentResource>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
PersistentResourceServiceConnection::RebootPersistentResource(
    NoAwaitTag,
    google::cloud::aiplatform::v1::RebootPersistentResourceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::PersistentResource>>
PersistentResourceServiceConnection::RebootPersistentResource(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::PersistentResource>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<PersistentResourceServiceConnection>
MakePersistentResourceServiceConnection(std::string const& location,
                                        Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 PersistentResourceServicePolicyOptionList>(
      options, __func__);
  options = aiplatform_v1_internal::PersistentResourceServiceDefaultOptions(
      location, std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub =
      aiplatform_v1_internal::CreateDefaultPersistentResourceServiceStub(
          std::move(auth), options);
  return aiplatform_v1_internal::MakePersistentResourceServiceTracingConnection(
      std::make_shared<
          aiplatform_v1_internal::PersistentResourceServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google
