// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/prediction_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_PREDICTION_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_PREDICTION_STUB_H

#include "google/cloud/async_streaming_read_write_rpc.h"
#include "google/cloud/completion_queue.h"
#include "google/cloud/internal/streaming_read_rpc.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/aiplatform/v1/prediction_service.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class PredictionServiceStub {
 public:
  virtual ~PredictionServiceStub() = 0;

  virtual StatusOr<google::cloud::aiplatform::v1::PredictResponse> Predict(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::PredictRequest const& request) = 0;

  virtual StatusOr<google::api::HttpBody> RawPredict(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::RawPredictRequest const& request) = 0;

  virtual std::unique_ptr<
      google::cloud::internal::StreamingReadRpc<google::api::HttpBody>>
  StreamRawPredict(std::shared_ptr<grpc::ClientContext> context,
                   Options const& options,
                   google::cloud::aiplatform::v1::StreamRawPredictRequest const&
                       request) = 0;

  virtual StatusOr<google::cloud::aiplatform::v1::DirectPredictResponse>
  DirectPredict(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::DirectPredictRequest const& request) = 0;

  virtual StatusOr<google::cloud::aiplatform::v1::DirectRawPredictResponse>
  DirectRawPredict(grpc::ClientContext& context, Options const& options,
                   google::cloud::aiplatform::v1::DirectRawPredictRequest const&
                       request) = 0;

  virtual std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
      google::cloud::aiplatform::v1::StreamDirectPredictRequest,
      google::cloud::aiplatform::v1::StreamDirectPredictResponse>>
  AsyncStreamDirectPredict(
      google::cloud::CompletionQueue const& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options) = 0;

  virtual std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
      google::cloud::aiplatform::v1::StreamDirectRawPredictRequest,
      google::cloud::aiplatform::v1::StreamDirectRawPredictResponse>>
  AsyncStreamDirectRawPredict(
      google::cloud::CompletionQueue const& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options) = 0;

  virtual std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
      google::cloud::aiplatform::v1::StreamingPredictRequest,
      google::cloud::aiplatform::v1::StreamingPredictResponse>>
  AsyncStreamingPredict(google::cloud::CompletionQueue const& cq,
                        std::shared_ptr<grpc::ClientContext> context,
                        google::cloud::internal::ImmutableOptions options) = 0;

  virtual std::unique_ptr<google::cloud::internal::StreamingReadRpc<
      google::cloud::aiplatform::v1::StreamingPredictResponse>>
  ServerStreamingPredict(
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::aiplatform::v1::StreamingPredictRequest const&
          request) = 0;

  virtual std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
      google::cloud::aiplatform::v1::StreamingRawPredictRequest,
      google::cloud::aiplatform::v1::StreamingRawPredictResponse>>
  AsyncStreamingRawPredict(
      google::cloud::CompletionQueue const& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options) = 0;

  virtual StatusOr<google::cloud::aiplatform::v1::ExplainResponse> Explain(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::ExplainRequest const& request) = 0;

  virtual StatusOr<google::cloud::aiplatform::v1::GenerateContentResponse>
  GenerateContent(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::GenerateContentRequest const& request) = 0;

  virtual std::unique_ptr<google::cloud::internal::StreamingReadRpc<
      google::cloud::aiplatform::v1::GenerateContentResponse>>
  StreamGenerateContent(
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::aiplatform::v1::GenerateContentRequest const& request) = 0;
};

class DefaultPredictionServiceStub : public PredictionServiceStub {
 public:
  explicit DefaultPredictionServiceStub(
      std::unique_ptr<
          google::cloud::aiplatform::v1::PredictionService::StubInterface>
          grpc_stub)
      : grpc_stub_(std::move(grpc_stub)) {}

  StatusOr<google::cloud::aiplatform::v1::PredictResponse> Predict(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::PredictRequest const& request) override;

  StatusOr<google::api::HttpBody> RawPredict(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::RawPredictRequest const& request) override;

  std::unique_ptr<
      google::cloud::internal::StreamingReadRpc<google::api::HttpBody>>
  StreamRawPredict(std::shared_ptr<grpc::ClientContext> context,
                   Options const& options,
                   google::cloud::aiplatform::v1::StreamRawPredictRequest const&
                       request) override;

  StatusOr<google::cloud::aiplatform::v1::DirectPredictResponse> DirectPredict(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::DirectPredictRequest const& request)
      override;

  StatusOr<google::cloud::aiplatform::v1::DirectRawPredictResponse>
  DirectRawPredict(grpc::ClientContext& context, Options const& options,
                   google::cloud::aiplatform::v1::DirectRawPredictRequest const&
                       request) override;

  std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
      google::cloud::aiplatform::v1::StreamDirectPredictRequest,
      google::cloud::aiplatform::v1::StreamDirectPredictResponse>>
  AsyncStreamDirectPredict(
      google::cloud::CompletionQueue const& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options) override;

  std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
      google::cloud::aiplatform::v1::StreamDirectRawPredictRequest,
      google::cloud::aiplatform::v1::StreamDirectRawPredictResponse>>
  AsyncStreamDirectRawPredict(
      google::cloud::CompletionQueue const& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options) override;

  std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
      google::cloud::aiplatform::v1::StreamingPredictRequest,
      google::cloud::aiplatform::v1::StreamingPredictResponse>>
  AsyncStreamingPredict(
      google::cloud::CompletionQueue const& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options) override;

  std::unique_ptr<google::cloud::internal::StreamingReadRpc<
      google::cloud::aiplatform::v1::StreamingPredictResponse>>
  ServerStreamingPredict(
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::aiplatform::v1::StreamingPredictRequest const& request)
      override;

  std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
      google::cloud::aiplatform::v1::StreamingRawPredictRequest,
      google::cloud::aiplatform::v1::StreamingRawPredictResponse>>
  AsyncStreamingRawPredict(
      google::cloud::CompletionQueue const& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options) override;

  StatusOr<google::cloud::aiplatform::v1::ExplainResponse> Explain(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::ExplainRequest const& request) override;

  StatusOr<google::cloud::aiplatform::v1::GenerateContentResponse>
  GenerateContent(grpc::ClientContext& context, Options const& options,
                  google::cloud::aiplatform::v1::GenerateContentRequest const&
                      request) override;

  std::unique_ptr<google::cloud::internal::StreamingReadRpc<
      google::cloud::aiplatform::v1::GenerateContentResponse>>
  StreamGenerateContent(
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::aiplatform::v1::GenerateContentRequest const& request)
      override;

 private:
  std::unique_ptr<
      google::cloud::aiplatform::v1::PredictionService::StubInterface>
      grpc_stub_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_PREDICTION_STUB_H
