// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/featurestore_online_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_FEATURESTORE_ONLINE_SERVING_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_FEATURESTORE_ONLINE_SERVING_TRACING_CONNECTION_H

#include "google/cloud/aiplatform/v1/featurestore_online_serving_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class FeaturestoreOnlineServingServiceTracingConnection
    : public aiplatform_v1::FeaturestoreOnlineServingServiceConnection {
 public:
  ~FeaturestoreOnlineServingServiceTracingConnection() override = default;

  explicit FeaturestoreOnlineServingServiceTracingConnection(
      std::shared_ptr<aiplatform_v1::FeaturestoreOnlineServingServiceConnection>
          child);

  Options options() override { return child_->options(); }

  StatusOr<google::cloud::aiplatform::v1::ReadFeatureValuesResponse>
  ReadFeatureValues(
      google::cloud::aiplatform::v1::ReadFeatureValuesRequest const& request)
      override;

  StreamRange<google::cloud::aiplatform::v1::ReadFeatureValuesResponse>
  StreamingReadFeatureValues(
      google::cloud::aiplatform::v1::StreamingReadFeatureValuesRequest const&
          request) override;

  StatusOr<google::cloud::aiplatform::v1::WriteFeatureValuesResponse>
  WriteFeatureValues(
      google::cloud::aiplatform::v1::WriteFeatureValuesRequest const& request)
      override;

 private:
  std::shared_ptr<aiplatform_v1::FeaturestoreOnlineServingServiceConnection>
      child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<aiplatform_v1::FeaturestoreOnlineServingServiceConnection>
MakeFeaturestoreOnlineServingServiceTracingConnection(
    std::shared_ptr<aiplatform_v1::FeaturestoreOnlineServingServiceConnection>
        conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_FEATURESTORE_ONLINE_SERVING_TRACING_CONNECTION_H
