// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/feature_registry_service.proto

#include "google/cloud/aiplatform/v1/internal/feature_registry_option_defaults.h"
#include "google/cloud/aiplatform/v1/feature_registry_connection.h"
#include "google/cloud/aiplatform/v1/feature_registry_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options FeatureRegistryServiceDefaultOptions(std::string const& location,
                                             Options options) {
  options = internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_FEATURE_REGISTRY_SERVICE_ENDPOINT",
      "", "GOOGLE_CLOUD_CPP_FEATURE_REGISTRY_SERVICE_AUTHORITY",
      absl::StrCat(location, "-", "aiplatform.googleapis.com"));
  options = internal::PopulateGrpcOptions(std::move(options));
  if (!options.has<aiplatform_v1::FeatureRegistryServiceRetryPolicyOption>()) {
    options.set<aiplatform_v1::FeatureRegistryServiceRetryPolicyOption>(
        aiplatform_v1::FeatureRegistryServiceLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options
           .has<aiplatform_v1::FeatureRegistryServiceBackoffPolicyOption>()) {
    options.set<aiplatform_v1::FeatureRegistryServiceBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options
           .has<aiplatform_v1::FeatureRegistryServicePollingPolicyOption>()) {
    options.set<aiplatform_v1::FeatureRegistryServicePollingPolicyOption>(
        GenericPollingPolicy<
            aiplatform_v1::FeatureRegistryServiceRetryPolicyOption::Type,
            aiplatform_v1::FeatureRegistryServiceBackoffPolicyOption::Type>(
            options
                .get<aiplatform_v1::FeatureRegistryServiceRetryPolicyOption>()
                ->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options.has<
          aiplatform_v1::
              FeatureRegistryServiceConnectionIdempotencyPolicyOption>()) {
    options.set<
        aiplatform_v1::FeatureRegistryServiceConnectionIdempotencyPolicyOption>(
        aiplatform_v1::
            MakeDefaultFeatureRegistryServiceConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google
