// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/genai_tuning_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_GEN_AI_TUNING_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_GEN_AI_TUNING_CLIENT_H

#include "google/cloud/aiplatform/v1/gen_ai_tuning_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// A service for creating and managing GenAI Tuning Jobs.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class GenAiTuningServiceClient {
 public:
  explicit GenAiTuningServiceClient(
      std::shared_ptr<GenAiTuningServiceConnection> connection,
      Options opts = {});
  ~GenAiTuningServiceClient();

  ///@{
  /// @name Copy and move support
  GenAiTuningServiceClient(GenAiTuningServiceClient const&) = default;
  GenAiTuningServiceClient& operator=(GenAiTuningServiceClient const&) =
      default;
  GenAiTuningServiceClient(GenAiTuningServiceClient&&) = default;
  GenAiTuningServiceClient& operator=(GenAiTuningServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(GenAiTuningServiceClient const& a,
                         GenAiTuningServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(GenAiTuningServiceClient const& a,
                         GenAiTuningServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Creates a TuningJob. A created TuningJob right away will be attempted to
  /// be run.
  ///
  /// @param parent  Required. The resource name of the Location to create the TuningJob in.
  ///  Format: `projects/{project}/locations/{location}`
  /// @param tuning_job  Required. The TuningJob to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.TuningJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateTuningJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/genai_tuning_service.proto#L108}
  /// [google.cloud.aiplatform.v1.TuningJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/tuning_job.proto#L36}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::TuningJob> CreateTuningJob(
      std::string const& parent,
      google::cloud::aiplatform::v1::TuningJob const& tuning_job,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a TuningJob. A created TuningJob right away will be attempted to
  /// be run.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CreateTuningJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.TuningJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateTuningJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/genai_tuning_service.proto#L108}
  /// [google.cloud.aiplatform.v1.TuningJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/tuning_job.proto#L36}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::TuningJob> CreateTuningJob(
      google::cloud::aiplatform::v1::CreateTuningJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a TuningJob.
  ///
  /// @param name  Required. The name of the TuningJob resource. Format:
  ///  `projects/{project}/locations/{location}/tuningJobs/{tuning_job}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.TuningJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.GetTuningJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/genai_tuning_service.proto#L124}
  /// [google.cloud.aiplatform.v1.TuningJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/tuning_job.proto#L36}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::TuningJob> GetTuningJob(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a TuningJob.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.GetTuningJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.TuningJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.GetTuningJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/genai_tuning_service.proto#L124}
  /// [google.cloud.aiplatform.v1.TuningJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/tuning_job.proto#L36}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::TuningJob> GetTuningJob(
      google::cloud::aiplatform::v1::GetTuningJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists TuningJobs in a Location.
  ///
  /// @param parent  Required. The resource name of the Location to list the TuningJobs from.
  ///  Format: `projects/{project}/locations/{location}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.TuningJob], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ListTuningJobsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/genai_tuning_service.proto#L137}
  /// [google.cloud.aiplatform.v1.TuningJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/tuning_job.proto#L36}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::TuningJob> ListTuningJobs(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists TuningJobs in a Location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ListTuningJobsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.TuningJob], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ListTuningJobsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/genai_tuning_service.proto#L137}
  /// [google.cloud.aiplatform.v1.TuningJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/tuning_job.proto#L36}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::TuningJob> ListTuningJobs(
      google::cloud::aiplatform::v1::ListTuningJobsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Cancels a TuningJob.
  /// Starts asynchronous cancellation on the TuningJob. The server makes a best
  /// effort to cancel the job, but success is not guaranteed. Clients can use
  /// [GenAiTuningService.GetTuningJob][google.cloud.aiplatform.v1.GenAiTuningService.GetTuningJob]
  /// or other methods to check whether the cancellation succeeded or whether the
  /// job completed despite cancellation. On successful cancellation, the
  /// TuningJob is not deleted; instead it becomes a job with a
  /// [TuningJob.error][google.cloud.aiplatform.v1.TuningJob.error] value with a
  /// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
  /// `Code.CANCELLED`, and
  /// [TuningJob.state][google.cloud.aiplatform.v1.TuningJob.state] is set to
  /// `CANCELLED`.
  ///
  /// @param name  Required. The name of the TuningJob to cancel. Format:
  ///  `projects/{project}/locations/{location}/tuningJobs/{tuning_job}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CancelTuningJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/genai_tuning_service.proto#L174}
  /// [google.cloud.aiplatform.v1.GenAiTuningService.GetTuningJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/genai_tuning_service.proto#L54}
  /// [google.cloud.aiplatform.v1.TuningJob.error]: @googleapis_reference_link{google/cloud/aiplatform/v1/tuning_job.proto#L98}
  /// [google.cloud.aiplatform.v1.TuningJob.state]: @googleapis_reference_link{google/cloud/aiplatform/v1/tuning_job.proto#L71}
  /// [google.rpc.Status.code]: @googleapis_reference_link{google/rpc/status.proto#L38}
  ///
  // clang-format on
  Status CancelTuningJob(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Cancels a TuningJob.
  /// Starts asynchronous cancellation on the TuningJob. The server makes a best
  /// effort to cancel the job, but success is not guaranteed. Clients can use
  /// [GenAiTuningService.GetTuningJob][google.cloud.aiplatform.v1.GenAiTuningService.GetTuningJob]
  /// or other methods to check whether the cancellation succeeded or whether the
  /// job completed despite cancellation. On successful cancellation, the
  /// TuningJob is not deleted; instead it becomes a job with a
  /// [TuningJob.error][google.cloud.aiplatform.v1.TuningJob.error] value with a
  /// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
  /// `Code.CANCELLED`, and
  /// [TuningJob.state][google.cloud.aiplatform.v1.TuningJob.state] is set to
  /// `CANCELLED`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CancelTuningJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CancelTuningJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/genai_tuning_service.proto#L174}
  /// [google.cloud.aiplatform.v1.GenAiTuningService.GetTuningJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/genai_tuning_service.proto#L54}
  /// [google.cloud.aiplatform.v1.TuningJob.error]: @googleapis_reference_link{google/cloud/aiplatform/v1/tuning_job.proto#L98}
  /// [google.cloud.aiplatform.v1.TuningJob.state]: @googleapis_reference_link{google/cloud/aiplatform/v1/tuning_job.proto#L71}
  /// [google.rpc.Status.code]: @googleapis_reference_link{google/rpc/status.proto#L38}
  ///
  // clang-format on
  Status CancelTuningJob(
      google::cloud::aiplatform::v1::CancelTuningJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Rebase a TunedModel.
  /// Creates a LongRunningOperation that takes a legacy Tuned GenAI model
  /// Reference and creates a TuningJob based on newly available model.
  ///
  /// @param parent  Required. The resource name of the Location into which to rebase the Model.
  ///  Format: `projects/{project}/locations/{location}`
  /// @param tuned_model_ref  Required. TunedModel reference to retrieve the legacy model information.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.TuningJob] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.RebaseTunedModelRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/genai_tuning_service.proto#L187}
  /// [google.cloud.aiplatform.v1.TuningJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/tuning_job.proto#L36}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::TuningJob>> RebaseTunedModel(
      std::string const& parent,
      google::cloud::aiplatform::v1::TunedModelRef const& tuned_model_ref,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RebaseTunedModel
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> RebaseTunedModel(
      NoAwaitTag, std::string const& parent,
      google::cloud::aiplatform::v1::TunedModelRef const& tuned_model_ref,
      Options opts = {});

  // clang-format off
  ///
  /// Rebase a TunedModel.
  /// Creates a LongRunningOperation that takes a legacy Tuned GenAI model
  /// Reference and creates a TuningJob based on newly available model.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.RebaseTunedModelRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.TuningJob] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.RebaseTunedModelRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/genai_tuning_service.proto#L187}
  /// [google.cloud.aiplatform.v1.TuningJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/tuning_job.proto#L36}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::TuningJob>> RebaseTunedModel(
      google::cloud::aiplatform::v1::RebaseTunedModelRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RebaseTunedModel
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> RebaseTunedModel(
      NoAwaitTag,
      google::cloud::aiplatform::v1::RebaseTunedModelRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RebaseTunedModel
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::TuningJob>> RebaseTunedModel(
      google::longrunning::Operation const& operation, Options opts = {});

 private:
  std::shared_ptr<GenAiTuningServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_GEN_AI_TUNING_CLIENT_H
