// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/feature_registry_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_FEATURE_REGISTRY_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_FEATURE_REGISTRY_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/aiplatform/v1/feature_registry_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class FeatureRegistryServiceConnectionIdempotencyPolicy {
 public:
  virtual ~FeatureRegistryServiceConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<FeatureRegistryServiceConnectionIdempotencyPolicy>
  clone() const;

  virtual google::cloud::Idempotency CreateFeatureGroup(
      google::cloud::aiplatform::v1::CreateFeatureGroupRequest const& request);

  virtual google::cloud::Idempotency GetFeatureGroup(
      google::cloud::aiplatform::v1::GetFeatureGroupRequest const& request);

  virtual google::cloud::Idempotency ListFeatureGroups(
      google::cloud::aiplatform::v1::ListFeatureGroupsRequest request);

  virtual google::cloud::Idempotency UpdateFeatureGroup(
      google::cloud::aiplatform::v1::UpdateFeatureGroupRequest const& request);

  virtual google::cloud::Idempotency DeleteFeatureGroup(
      google::cloud::aiplatform::v1::DeleteFeatureGroupRequest const& request);

  virtual google::cloud::Idempotency CreateFeature(
      google::cloud::aiplatform::v1::CreateFeatureRequest const& request);

  virtual google::cloud::Idempotency GetFeature(
      google::cloud::aiplatform::v1::GetFeatureRequest const& request);

  virtual google::cloud::Idempotency ListFeatures(
      google::cloud::aiplatform::v1::ListFeaturesRequest request);

  virtual google::cloud::Idempotency UpdateFeature(
      google::cloud::aiplatform::v1::UpdateFeatureRequest const& request);

  virtual google::cloud::Idempotency DeleteFeature(
      google::cloud::aiplatform::v1::DeleteFeatureRequest const& request);
};

std::unique_ptr<FeatureRegistryServiceConnectionIdempotencyPolicy>
MakeDefaultFeatureRegistryServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_FEATURE_REGISTRY_CONNECTION_IDEMPOTENCY_POLICY_H
