// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: generator/integration_tests/test2.proto

#include "generator/integration_tests/golden/v1/internal/golden_rest_only_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace golden_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

GoldenRestOnlyTracingConnection::GoldenRestOnlyTracingConnection(
    std::shared_ptr<golden_v1::GoldenRestOnlyConnection> child)
    : child_(std::move(child)) {}

Status
GoldenRestOnlyTracingConnection::Noop(google::protobuf::Empty const& request) {
  auto span = internal::MakeSpan("golden_v1::GoldenRestOnlyConnection::Noop");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->Noop(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<golden_v1::GoldenRestOnlyConnection>
MakeGoldenRestOnlyTracingConnection(
    std::shared_ptr<golden_v1::GoldenRestOnlyConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<GoldenRestOnlyTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace golden_v1_internal
}  // namespace cloud
}  // namespace google
