.TH THINKFAN "5" "December 2021" "thinkfan @THINKFAN_VERSION@" "thinkfan"
.SH NAME
thinkfan \- A simple fan control program
.SH SYNOPSIS
.SY thinkfan
.OP \-hnqDd
.OP \-b BIAS
.OP \-c CONFIG
.OP \-s SECONDS
.OP \-p \fR[\fIDELAY\fR]\fI
.YS



.SH DESCRIPTION

Thinkfan sets the fan speed according to temperature limits set in the config
file.
It can read temperatures from a number of sources:

.IP "/proc/acpi/ibm/thermal"
Which is provided by the thinkpad_acpi kernel module on older Thinkpads,

.IP "temp*_input files in sysfs"
Which may be provided by any hwmon drivers, including thinkpad_acpi on modern
Thinkpads,

.IP "Hard disks with S.M.A.R.T. support"
With the help of libatasmart, if thinkfan was compiled with
.B \-DUSE_ATASMART=ON

.IP "From the proprietary nVidia driver"
When the proprietary nVidia driver is used, no hwmon for the card will be
available. In this situation, thinkfan can use the proprietary NVML API to get
temperatures.

.P
The fan can be /proc/acpi/ibm/fan or some PWM file in 
/sys/class/hwmon. See
.BR thinkfan.conf (5)
for a detailed explanation of the config syntax.

.HP
\fBWARNING\fR: This program does only very basic sanity checking on the
configuration. That means that you can set your temperature limits as insane
as you like.
.P
There are two general modes of operation:


.SS COMPLEX MODE
In complex mode, temperature limits are defined for each sensor thinkfan knows
about. Setting suitable limits for each sensor in your system will probably
require a bit of experimentation and good knowledge about your hardware, but
it's the safest way of keeping each component within its specified temperature
range. See http://www.thinkwiki.org/wiki/Thermal_Sensors for details on
which sensor measures what temperature in a Thinkpad. On other systems you'll
have to find out on your own. See the example configs to learn about the
syntax.


.SS SIMPLE MODE
In simple mode, Thinkfan uses only the highest temperature found in the
system. That may be dangerous, e.g. for hard disks.  That's why you should
provide a correction value (i.e. add 10\-15 \[char176]C) for the sensor that has the
temperature of your hard disk (or battery...). See the example config files
for details about that.



.SH CONFIGURATION
Some example configurations are provided with the source package. For a detailed
see the config man page
.BR thinkfan.conf (5).



.SH OPTIONS

.TP
.B \-h
Show a short help message

.TP
.BI \-s " SECONDS"
Maximum seconds between temperature updates (default: 5)

.TP
.BI \-b " BIAS"
Floating point number (\-10 to 30) to control rising temperature exaggeration.
If the temperature increases by more than 2 \[char176]C during one cycle, this number
is used to calculate a bias, which is added to the current highest temperature
seen in the system:

 current_tmax = current_tmax + delta_t * \fIBIAS\fR / 10

This means that negative numbers can be used to even out short and sudden
temperature spikes like those seen on some on\-DIE sensors. Use DANGEROUS mode
to remove the \-10 to +30 limit. Note that you can't have a space between \-b
and a negative argument, because otherwise getopt will interpret things like
\-10 as an option and fail (i.e. write
.B \-b\-10
instead of
.BR "\-b \-10" ).

Default is 15.0

.TP
.BI \-c " FILE"
Load a different configuration file.
By default, thinkfan first tries to load /etc/thinkfan.yaml, and
/etc/thinkfan.conf after that.
The former must be in YAML format, while the latter can be either YAML or the
old legacy syntax.

If this option is specified, thinkfan attempts to load the config only from
.IR FILE .
If its name ends in \*(lq.yaml\*(rq, it must be in YAML format.
Otherwise, it can be either YAML or legacy syntax.
See
.BR thinkfan.conf (5)
and
.BR thinkfan.conf.legacy (5)
for details.

.TP
.B \-n
Do not become a daemon and log to terminal instead of syslog

.TP
.B \-q
Be quiet, i.e. reduce logging level from the default. Can be specified
multiple times until only errors are displayed/logged.

.TP
.B \-v
Be more verbose. Can be specified multiple times until every message is
displayed/logged.

.TP
.BR "\-p " [\fISECONDS\fR]
Use the pulsing\-fan workaround (for older Thinkpads). Takes an optional
floating\-point argument (0\-10s) as depulsing duration. Default 0.5s.

.TP
.B \-d
Do not read temperature from sleeping disks. Instead, 0 \[char176]C is used as that
disk's temperature. This is needed if reading the temperature causes your
disk to wake up unnecessarily.
NOTE: This option is only available if thinkfan was built with \-D USE_ATASMART.

.TP
.B \-D
DANGEROUS mode: Disable all sanity checks. May damage your hardware!!
.SH SIGNALS
SIGINT and SIGTERM simply interrupt operation and should cause thinkfan to
terminate cleanly.
.P
SIGHUP makes thinkfan reload its config. If there's any problem with the new
config, we keep the old one.
.P
SIGUSR1 causes thinkfan to dump all currently known temperatures either to
syslog, or to the console (if running with the \-n option).
.SH RETURN VALUE

.TP
.B 0
Normal exit

.TP
.B 1
Runtime error

.TP
.B 2
Unexpected runtime error

.TP
.B 3
Invalid commandline option



.SH SEE ALSO
.nf
The thinkfan config manpage:
.BR thinkfan.conf (5)

Example configs shipped with the source distribution, also available at:
.hy 0
https://github.com/vmatare/thinkfan/tree/master/examples

The Linux hwmon user interface documentation:
https://www.kernel.org/doc/html/latest/hwmon/sysfs\-interface.html

The thinkpad_acpi interface documentation:
https://www.kernel.org/doc/html/latest/admin\-guide/laptops/thinkpad\-acpi.html



.SH BUGS
If thinkfan tells you to, or if you feel like it, report issues at the Github
issue tracker:

.hy 0
https://github.com/vmatare/thinkfan/issues

