/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2020 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * rotate angles with iteration start/stop controls

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_rotation_iter_controls.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfRotationIterControlsIteration(
	REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	Q_UNUSED(aux);
	REAL4 tp;
	if (fractal->transformCommon.rotation44a.y != 0
			&& aux->i >= fractal->transformCommon.startIterationsA
			&& aux->i < fractal->transformCommon.stopIterationsA)
	{
		tp = z;
		REAL alpha = fractal->transformCommon.rotation44a.y * -M_PI_180_F;
		z.y = tp.y * native_cos(alpha) + tp.z * native_sin(alpha);
		z.z = tp.y * -native_sin(alpha) + tp.z * native_cos(alpha);
	}

	if (fractal->transformCommon.rotation44a.z != 0
			&& aux->i >= fractal->transformCommon.startIterationsB
			&& aux->i < fractal->transformCommon.stopIterationsB)
	{
		tp = z;
		REAL beta = fractal->transformCommon.rotation44a.z * M_PI_180_F;
		z.x = tp.x * native_cos(beta) + tp.z * native_sin(beta);
		z.z = tp.x * -native_sin(beta) + tp.z * native_cos(beta);
	}

	if (fractal->transformCommon.rotation44a.x != 0
			&& aux->i >= fractal->transformCommon.startIterationsC
			&& aux->i < fractal->transformCommon.stopIterationsC)
	{
		tp = z;
		REAL gamma = fractal->transformCommon.rotation44a.x * -M_PI_180_F;
		z.x = tp.x * native_cos(gamma) + tp.y * native_sin(gamma);
		z.y = tp.x * -native_sin(gamma) + tp.y * native_cos(gamma);
	}
	return z;
}